/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.freecol.common.i18n.Selector;

public class TurnSelector
implements Selector {
    private static final String turn = "(SPRING|AUTUMN)?\\s*(\\d+)";
    private static final Pattern turnPattern = Pattern.compile("(SPRING|AUTUMN)?\\s*(\\d+)\\s*-\\s*(SPRING|AUTUMN)?\\s*(\\d+)|(SPRING|AUTUMN)?\\s*(\\d+)");

    @Override
    public String getKey(String selector, String template) {
        String season = null;
        int offset = 5;
        if (!selector.startsWith("YEAR ")) {
            season = selector.substring(0, 6);
            offset = 7;
        }
        int year = Integer.parseInt(selector.substring(offset));
        Matcher matcher = turnPattern.matcher(template);
        while (matcher.find()) {
            if (!(matcher.group(6) != null ? this.compare(matcher.group(5), Integer.parseInt(matcher.group(6)), season, year) == 0 : this.compare(matcher.group(1), Integer.parseInt(matcher.group(2)), season, year) <= 0 && this.compare(matcher.group(3), Integer.parseInt(matcher.group(4)), season, year) >= 0)) continue;
            return matcher.group(0);
        }
        return selector;
    }

    public int compare(String season1, int year1, String season2, int year2) {
        if (year1 < year2) {
            return -1;
        }
        if (year1 > year2) {
            return 1;
        }
        if (year1 == year2) {
            if (season1 == null || season2 == null) {
                return 0;
            }
            if ("SPRING".equals(season1) && "AUTUMN".equals(season2)) {
                return -1;
            }
            if ("SPRING".equals(season2) && "AUTUMN".equals(season1)) {
                return 1;
            }
        }
        return 0;
    }
}

