/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;

public class FreeColDebugger {
    private static final Logger logger = Logger.getLogger(FreeColDebugger.class.getName());
    private static int debugMode = 0;
    private static int debugRunTurns = -1;
    private static String debugRunSave = null;
    private static boolean normalGameFogOfWar = false;
    private static boolean displayCoordinates = false;
    private static Player displayColonyValuePlayer = null;
    private static boolean showMission = false;
    private static boolean showMissionInfo = false;

    public static boolean isInDebugMode() {
        return debugMode != 0;
    }

    public static boolean isInDebugMode(DebugMode mode) {
        return (1 << mode.ordinal() & debugMode) != 0;
    }

    private static void setDebugMode(int mode) {
        debugMode = mode;
    }

    public static void enableDebugMode(DebugMode mode) {
        debugMode |= 1 << mode.ordinal();
    }

    public static String getDebugModes() {
        String ret = "";
        for (DebugMode mode : DebugMode.values()) {
            if (!FreeColDebugger.isInDebugMode(mode)) continue;
            ret = ret + "," + (Object)((Object)mode);
        }
        return ret.isEmpty() ? ret : ret.substring(1, ret.length());
    }

    public static boolean setDebugModes(String optionValue) {
        if (optionValue == null) {
            return false;
        }
        if (optionValue.isEmpty()) {
            return true;
        }
        try {
            int i = Integer.parseInt(optionValue);
            switch (i) {
                case 3: {
                    FreeColDebugger.enableDebugMode(DebugMode.COMMS);
                }
                case 2: {
                    FreeColDebugger.enableDebugMode(DebugMode.INIT);
                }
                case 1: {
                    FreeColDebugger.enableDebugMode(DebugMode.MENUS);
                    return true;
                }
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            for (String s : optionValue.split(",")) {
                try {
                    DebugMode mode = Enum.valueOf(DebugMode.class, s.toUpperCase(Locale.US));
                    FreeColDebugger.enableDebugMode(mode);
                }
                catch (Exception e) {
                    logger.warning("Unrecognized debug mode: " + optionValue);
                    return false;
                }
            }
            return true;
        }
    }

    public static void configureDebugRun(String option) {
        int comma = option.indexOf(44);
        String turns = option.substring(0, comma < 0 ? option.length() : comma);
        try {
            FreeColDebugger.setDebugRunTurns(Integer.parseInt(turns));
        }
        catch (NumberFormatException e) {
            FreeColDebugger.setDebugRunTurns(-1);
        }
        if (comma > 0) {
            FreeColDebugger.setDebugRunSave(option.substring(comma + 1));
        }
    }

    public static int getDebugRunTurns() {
        return debugRunTurns;
    }

    public static void setDebugRunTurns(int debugRunTurns) {
        FreeColDebugger.debugRunTurns = debugRunTurns;
    }

    public static String getDebugRunSave() {
        return debugRunSave;
    }

    public static void setDebugRunSave(String debugRunSave) {
        FreeColDebugger.debugRunSave = debugRunSave;
    }

    public static boolean getNormalGameFogOfWar() {
        return normalGameFogOfWar;
    }

    public static void setNormalGameFogOfWar(boolean normalGameFogOfWar) {
        FreeColDebugger.normalGameFogOfWar = normalGameFogOfWar;
    }

    public static boolean finishDebugRun(FreeColClient freeColClient, boolean force) {
        if (FreeColDebugger.getDebugRunTurns() < 0) {
            return false;
        }
        if (FreeColDebugger.getDebugRunTurns() > 0 && !force) {
            return false;
        }
        FreeColDebugger.setDebugRunTurns(-1);
        if (FreeColDebugger.getDebugRunSave() != null) {
            FreeColServer fcs = freeColClient.getFreeColServer();
            if (fcs != null) {
                try {
                    fcs.saveGame(new File(".", FreeColDebugger.getDebugRunSave()), freeColClient.getClientOptions());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            freeColClient.quit();
        }
        return true;
    }

    public static void signalEndDebugRun() {
        if (debugRunTurns > 0) {
            FreeColDebugger.setDebugRunTurns(0);
        }
    }

    public static boolean debugDisplayCoordinates() {
        return displayCoordinates;
    }

    public static void setDebugDisplayCoordinates(boolean display) {
        displayCoordinates = display;
    }

    public static Player debugDisplayColonyValuePlayer() {
        return displayColonyValuePlayer;
    }

    public static void setDebugDisplayColonyValuePlayer(Player display) {
        displayColonyValuePlayer = display;
    }

    public static boolean debugShowMission() {
        return showMission;
    }

    public static void setDebugShowMission(boolean display) {
        showMission = display;
    }

    public static boolean debugShowMissionInfo() {
        return showMissionInfo;
    }

    public static void setDebugShowMissionInfo(boolean display) {
        showMissionInfo = display;
    }

    public static void handleCrash() {
        if (debugRunSave != null) {
            FreeColDebugger.signalEndDebugRun();
        }
    }

    public static void debugLog(String msg) {
        try (FileOutputStream fos = new FileOutputStream("/tmp/freecol.debug", true);
             PrintStream prs = new PrintStream((OutputStream)fos, true, "UTF-8");){
            prs.println(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String stackTraceToString() {
        LogBuilder lb = new LogBuilder(512);
        FreeColDebugger.addStackTrace(lb);
        return lb.toString();
    }

    public static void addStackTrace(LogBuilder lb) {
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            lb.add(s.toString(), "\n");
        }
        lb.shrink("\n");
    }

    public static enum DebugMode {
        COMMS,
        DESYNC,
        MENUS,
        INIT,
        PATHS;

    }
}

