/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.plaf.LAFUtilities;

public class FreeColButtonUI
extends MetalButtonUI {
    private static final FreeColButtonUI sharedInstance = new FreeColButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LAFUtilities.setProperties(g, c);
        if (c.isOpaque()) {
            ImageLibrary.drawTiledImage("background.FreeColButton", g, c, null);
        }
        super.paint(g, c);
        AbstractButton a = (AbstractButton)c;
        if (a.isRolloverEnabled()) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, c);
            boolean rollover = c.contains(p);
            if (rollover) {
                this.paintButtonPressed(g, (AbstractButton)c);
            }
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton c) {
        if (c.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = c.getSize();
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setComposite(oldComposite);
            g2d.setColor(oldColor);
        }
    }
}

