/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

public class UnitDetailPanel
extends ColopediaGameObjectTypePanel<UnitType> {
    private static final int MODIFIERS_PER_ROW = 5;

    public UnitDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.UNITS.toString(), 0.5);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        ArrayList<UnitType> skills = new ArrayList<UnitType>();
        for (UnitType u : this.getSpecification().getUnitTypeList()) {
            if (u.getSkill() <= 0 || u.hasAbility("model.ability.expertSoldier")) {
                units.add(u);
                continue;
            }
            skills.add(u);
        }
        super.addSubTrees(root, "colopediaAction." + (Object)((Object)ColopediaAction.PanelType.UNITS), units);
        super.addSubTrees(root, "colopediaAction." + (Object)((Object)ColopediaAction.PanelType.SKILLS), skills);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildDetail(String id, JPanel panel) {
        Map<String, Boolean> abilities;
        Player player;
        if (this.getId().equals(id) || ("colopediaAction." + (Object)((Object)ColopediaAction.PanelType.SKILLS)).equals(id)) {
            return;
        }
        UnitType type = this.getSpecification().getUnitType(id);
        panel.setLayout(new MigLayout("wrap 4", "[]20[]40[]20[]"));
        JLabel name = GUI.localizedLabel(type.getNameKey());
        name.setFont(GUI.SMALL_HEADER_FONT);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(GUI.localizedLabel("colopedia.unit.offensivePower"));
        panel.add((Component)new JLabel(Integer.toString((int)type.getOffence())), "right");
        panel.add(GUI.localizedLabel("colopedia.unit.defensivePower"));
        panel.add((Component)new JLabel(Integer.toString((int)type.getDefence())), "right");
        panel.add(GUI.localizedLabel("colopedia.unit.movement"));
        panel.add((Component)new JLabel(String.valueOf(type.getMovement() / 3)), "right");
        if (type.canCarryGoods() || type.canCarryUnits()) {
            panel.add(GUI.localizedLabel("colopedia.unit.capacity"));
            panel.add((Component)new JLabel(Integer.toString(type.getSpace())), "right");
        }
        Europe europe = (player = this.getMyPlayer()) == null ? null : player.getEurope();
        String price = null;
        if (europe != null && europe.getUnitPrice(type) > 0) {
            price = Integer.toString(europe.getUnitPrice(type));
        } else if (type.getPrice() > 0) {
            price = Integer.toString(type.getPrice());
        }
        if (price != null) {
            panel.add(GUI.localizedLabel("colopedia.unit.price"));
            panel.add((Component)new JLabel(price), "right");
        }
        if (type.hasSkill()) {
            panel.add(GUI.localizedLabel("colopedia.unit.skill"));
            panel.add((Component)new JLabel(Integer.toString(type.getSkill())), "right");
            ArrayList<BuildingType> schools = new ArrayList<BuildingType>();
            for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                if (!buildingType.hasAbility("model.ability.teach") || !buildingType.canAdd(type)) continue;
                schools.add(buildingType);
            }
            if (!schools.isEmpty()) {
                panel.add((Component)GUI.localizedLabel("colopedia.unit.school"), "newline");
                int count = 0;
                for (BuildingType buildingType : schools) {
                    JButton jButton = this.getButton(buildingType);
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)jButton, "skip");
                    } else {
                        panel.add(jButton);
                    }
                    ++count;
                }
            }
            ArrayList<IndianNationType> nations = new ArrayList<IndianNationType>();
            for (IndianNationType indianNationType : this.getSpecification().getIndianNationTypes()) {
                for (RandomChoice<UnitType> randomChoice : indianNationType.getSkills()) {
                    if (randomChoice.getObject() != type) continue;
                    nations.add(indianNationType);
                }
            }
            if (!nations.isEmpty()) {
                panel.add((Component)GUI.localizedLabel("colopedia.unit.natives"), "newline");
                boolean bl = false;
                for (IndianNationType indianNationType : nations) {
                    void var10_16;
                    JButton jButton = this.getButton(indianNationType);
                    if (var10_16 > 0 && var10_16 % 3 == false) {
                        panel.add((Component)jButton, "skip");
                    } else {
                        panel.add(jButton);
                    }
                    ++var10_16;
                }
            }
        }
        if (!(abilities = type.getRequiredAbilities()).isEmpty()) {
            panel.add((Component)GUI.localizedLabel("colopedia.unit.requirements"), "newline, top");
            String key = abilities.keySet().iterator().next();
            try {
                JTextPane jTextPane = GUI.getDefaultTextPane();
                StyledDocument styledDocument = jTextPane.getStyledDocument();
                this.appendRequiredAbilities(styledDocument, type);
                panel.add((Component)jTextPane, "span, width 60%");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        ArrayList<Modifier> bonusList = new ArrayList<Modifier>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            bonusList.addAll(type.getModifiers(goodsType.getId()));
        }
        int n = bonusList.size();
        if (n > 0) {
            StringTemplate stringTemplate = StringTemplate.template("colopedia.unit.productionBonus").addAmount("%number%", n);
            panel.add((Component)GUI.localizedLabel(stringTemplate), "newline 20, top");
            JPanel jPanel = new JPanel(new GridLayout(0, 5));
            jPanel.setOpaque(false);
            for (Modifier productionBonus : bonusList) {
                GoodsType goodsType = this.getSpecification().getGoodsType(productionBonus.getId());
                String bonus = ModifierFormat.getModifierAsString(productionBonus);
                jPanel.add(this.getGoodsButton(goodsType, bonus));
            }
            panel.add((Component)jPanel, "span");
        }
        if (type.needsGoodsToBuild()) {
            panel.add((Component)GUI.localizedLabel("colopedia.unit.goodsRequired"), "newline 20");
            List<AbstractGoods> list = type.getRequiredGoods();
            AbstractGoods abstractGoods = list.get(0);
            if (list.size() > 1) {
                void var13_49;
                panel.add((Component)this.getGoodsButton(abstractGoods.getType(), abstractGoods.getAmount()), "span, split " + list.size());
                boolean bl = true;
                while (var13_49 < list.size()) {
                    AbstractGoods abstractGoods2 = list.get((int)var13_49);
                    panel.add(this.getGoodsButton(abstractGoods2.getType(), abstractGoods2.getAmount()));
                    ++var13_49;
                }
            } else {
                panel.add(this.getGoodsButton(abstractGoods.getType(), abstractGoods.getAmount()));
            }
        }
        panel.add((Component)GUI.localizedLabel("colopedia.unit.description"), "newline 20");
        panel.add((Component)GUI.getDefaultTextArea(Messages.getDescription(type), 30), "span");
    }
}

