/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

public final class TradeRoutePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(TradeRoutePanel.class.getName());
    private static final String DEASSIGN = "deassign";
    private static final Comparator<TradeRoute> tradeRouteComparator = new Comparator<TradeRoute>(){

        @Override
        public int compare(TradeRoute r1, TradeRoute r2) {
            return r1.getName().compareTo(r2.getName());
        }
    };
    private final Unit unit;
    private final DefaultListModel<TradeRoute> listModel = new DefaultListModel();
    private JList<TradeRoute> tradeRoutes;
    private final Map<TradeRoute, Integer> counts = new HashMap<TradeRoute, Integer>();
    private JButton newRouteButton;
    private JButton editRouteButton;
    private JButton deleteRouteButton;
    private JButton deassignRouteButton;

    public TradeRoutePanel(FreeColClient freeColClient, Unit unit) {
        super(freeColClient, new MigLayout("wrap 2", "[fill][fill]"));
        Player player = this.getMyPlayer();
        this.unit = unit;
        this.tradeRoutes = new JList<TradeRoute>(this.listModel);
        this.tradeRoutes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TradeRoutePanel.this.updateButtons();
            }
        });
        this.tradeRoutes.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focus);
                TradeRoute tradeRoute = (TradeRoute)value;
                String name = tradeRoute.getName();
                Integer n = (Integer)TradeRoutePanel.this.counts.get(tradeRoute);
                if (n == null || n <= 0) {
                    this.setText(name);
                } else {
                    this.setText(name + "  (" + n + ")");
                }
                return ret;
            }
        });
        JScrollPane tradeRouteView = new JScrollPane(this.tradeRoutes);
        this.newRouteButton = GUI.localizedButton("tradeRoutePanel.newRoute");
        GUI.localizeToolTip((JComponent)this.newRouteButton, "tradeRoutePanel.new.tooltip");
        this.newRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeRoutePanel.this.newRoute();
            }
        });
        this.editRouteButton = GUI.localizedButton("tradeRoutePanel.editRoute");
        GUI.localizeToolTip((JComponent)this.editRouteButton, "tradeRoutePanel.edit.tooltip");
        this.editRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final TradeRoute selected = (TradeRoute)TradeRoutePanel.this.tradeRoutes.getSelectedValue();
                final String name = selected.getName();
                TradeRoutePanel.this.getGUI().showTradeRouteInputPanel(selected, new Runnable(){

                    @Override
                    public void run() {
                        StringTemplate template = null;
                        if (selected.getName() == null) {
                            selected.setName(name);
                        } else {
                            template = selected.verify();
                            if (template == null) {
                                TradeRoutePanel.this.igc().updateTradeRoute(selected);
                                TradeRoutePanel.this.updateList(selected);
                            } else {
                                TradeRoutePanel.this.getGUI().showInformationMessage(template);
                            }
                        }
                    }
                });
            }
        });
        this.deleteRouteButton = GUI.localizedButton("tradeRoutePanel.deleteRoute");
        GUI.localizeToolTip((JComponent)this.deleteRouteButton, "tradeRoutePanel.delete.tooltip");
        this.deleteRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeRoute route = TradeRoutePanel.this.getRoute();
                if (route != null) {
                    for (Unit u : route.getAssignedUnits()) {
                        TradeRoutePanel.this.igc().assignTradeRoute(u, null);
                    }
                    TradeRoutePanel.this.deleteTradeRoute(route);
                    TradeRoutePanel.this.updateList(null);
                }
            }
        });
        this.deassignRouteButton = GUI.localizedButton("tradeRoutePanel.deassignRoute");
        GUI.localizeToolTip((JComponent)this.deassignRouteButton, "tradeRoutePanel.deassign.tooltip");
        this.deassignRouteButton.setActionCommand(DEASSIGN);
        this.deassignRouteButton.addActionListener(this);
        JButton cancelButton = GUI.localizedButton("cancel");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        this.setCancelComponent(cancelButton);
        this.updateButtons();
        this.updateList(unit == null || unit.getTradeRoute() == null ? null : unit.getTradeRoute());
        this.add((Component)GUI.getDefaultHeader(Messages.message("tradeRoutePanel.name")), "span, align center");
        if (this.unit != null && this.unit.getLocation() != null) {
            JLabel unitLabel = new JLabel(unit.getDescription(Unit.UnitLabelType.NATIONAL));
            this.getLibrary();
            unitLabel.setIcon(ImageLibrary.getUnitImageIcon(this.unit, 0.5));
            this.add(unitLabel);
            Location loc = this.unit.getLocation();
            JLabel locLabel = GUI.localizedLabel(loc.getLocationLabelFor(player));
            this.add(locLabel);
        }
        this.add((Component)tradeRouteView, "height 360:400, width 250:");
        this.add((Component)this.newRouteButton, "split 4, flowy, growx");
        this.add((Component)this.editRouteButton, "growx");
        this.add((Component)this.deleteRouteButton, "growx");
        this.add(this.deassignRouteButton);
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)cancelButton, "tag cancel");
        this.getGUI().restoreSavedSize(this, this.getPreferredSize());
    }

    private TradeRoute getRoute() {
        return this.tradeRoutes.getSelectedValue();
    }

    private void newRoute() {
        Player player = this.getMyPlayer();
        final Unit u = this.unit;
        final TradeRoute newRoute = this.igc().getNewTradeRoute(player);
        this.getGUI().showTradeRouteInputPanel(newRoute, new Runnable(){

            @Override
            public void run() {
                StringTemplate template = null;
                if (newRoute.getName() == null) {
                    TradeRoutePanel.this.deleteTradeRoute(newRoute);
                    TradeRoutePanel.this.updateList(null);
                } else {
                    template = newRoute.verify();
                    if (template == null) {
                        TradeRoutePanel.this.igc().updateTradeRoute(newRoute);
                        if (u != null) {
                            TradeRoutePanel.this.igc().assignTradeRoute(u, newRoute);
                        }
                        TradeRoutePanel.this.updateList(newRoute);
                    } else {
                        TradeRoutePanel.this.updateList(null);
                        TradeRoutePanel.this.getGUI().showInformationMessage(template);
                    }
                }
            }
        });
    }

    private void updateButtons() {
        this.newRouteButton.setEnabled(true);
        if (this.tradeRoutes.getSelectedIndex() < 0) {
            this.editRouteButton.setEnabled(false);
            this.deleteRouteButton.setEnabled(false);
            this.deassignRouteButton.setEnabled(false);
        } else {
            this.editRouteButton.setEnabled(true);
            this.deleteRouteButton.setEnabled(true);
            this.deassignRouteButton.setEnabled(this.unit != null && this.unit.getTradeRoute() != null);
        }
    }

    private void updateList(TradeRoute selectRoute) {
        Player player = this.getMyPlayer();
        this.counts.clear();
        for (Unit u : player.getUnits()) {
            TradeRoute tradeRoute = u.getTradeRoute();
            if (tradeRoute == null) continue;
            Integer i = this.counts.get(tradeRoute);
            int value = i == null ? 0 : i;
            this.counts.put(tradeRoute, value + 1);
        }
        ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>(player.getTradeRoutes());
        Collections.sort(routes, tradeRouteComparator);
        this.listModel.clear();
        for (TradeRoute route : routes) {
            this.listModel.addElement(route);
        }
        if (selectRoute != null) {
            this.tradeRoutes.setSelectedValue(selectRoute, true);
        }
    }

    private void deleteTradeRoute(TradeRoute route) {
        List<TradeRoute> routes = this.getMyPlayer().getTradeRoutes();
        routes.remove(route);
        this.igc().setTradeRoutes(routes);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        TradeRoute route = this.getRoute();
        if (DEASSIGN.equals(command)) {
            if (this.unit != null && route == this.unit.getTradeRoute()) {
                this.igc().clearOrders(this.unit);
            }
            this.getGUI().removeFromCanvas(this);
        } else if ("OK".equals(command)) {
            ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>();
            for (int index = 0; index < this.listModel.getSize(); ++index) {
                routes.add(this.listModel.getElementAt(index));
            }
            this.igc().setTradeRoutes(routes);
            if (this.unit != null && route != null) {
                this.igc().assignTradeRoute(this.unit, route);
            }
            super.actionPerformed(event);
        } else if ("CANCEL".equals(command)) {
            this.getGUI().removeTradeRoutePanel(this);
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void removeNotify() {
        this.listModel.clear();
        this.tradeRoutes = null;
        this.counts.clear();
        this.newRouteButton = null;
        this.editRouteButton = null;
        this.deleteRouteButton = null;
        this.deassignRouteButton = null;
        super.removeNotify();
    }
}

