/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.List;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.WorkLocation;

public final class ReportReligiousPanel
extends ReportPanel {
    public ReportReligiousPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportReligionAction");
        this.reportPanel.setLayout(new MigLayout("wrap 5, gap 20 20", "", ""));
        this.reportPanel.add(GUI.localizedLabel("crosses"));
        Player player = this.getMyPlayer();
        Specification spec = this.getSpecification();
        GoodsType crosses = spec.getGoodsType("model.goods.crosses");
        FreeColProgressBar progressBar = new FreeColProgressBar(this.getGUI(), crosses);
        this.reportPanel.add((Component)progressBar, "span");
        List<Colony> colonies = freeColClient.getMySortedColonies();
        for (Colony colony : colonies) {
            WorkLocation wl = colony.getWorkLocationForProducing(crosses);
            if (wl == null || !(wl instanceof Building)) continue;
            Building building = (Building)wl;
            this.reportPanel.add((Component)this.createColonyButton(colony), "split 2, flowy, align center");
            BuildingPanel bp = new BuildingPanel(this.getFreeColClient(), building);
            bp.initialize();
            this.reportPanel.add(bp);
        }
        progressBar.update(0, player.getImmigrationRequired(), player.getImmigration(), player.getTotalImmigrationProduction());
    }
}

