/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class ReportPanel
extends FreeColPanel {
    protected static final Logger logger = Logger.getLogger(ReportPanel.class.getName());
    private static final Comparator<Unit> unitTypeComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit unit1, Unit unit2) {
            int deltaType = unit2.getType().compareTo(unit1.getType());
            if (deltaType == 0) {
                return unit2.getRole() == null ? -1 : unit2.getRole().getId().compareTo(unit1.getRole().getId());
            }
            return deltaType;
        }
    };
    protected final JPanel reportPanel;
    protected final JLabel header;
    protected JScrollPane scrollPane;

    public ReportPanel(FreeColClient freeColClient, String key) {
        super(freeColClient, new MigLayout("wrap 1", "[fill]", "[]30[fill]30[]"));
        this.header = GUI.getDefaultHeader(Messages.getName(key));
        this.add((Component)this.header, "cell 0 0, align center");
        this.reportPanel = new MigPanel("ReportPanelUI");
        this.reportPanel.setOpaque(true);
        this.reportPanel.setBorder(this.createBorder());
        this.scrollPane = new JScrollPane(this.reportPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "cell 0 1, height 100%, width 100%");
        this.add((Component)this.okButton, "cell 0 2, tag ok");
        this.getGUI().restoreSavedSize(this, 850, 600);
    }

    public void initialize() {
        this.reportPanel.removeAll();
        this.reportPanel.doLayout();
    }

    public static Comparator<Unit> getUnitTypeComparator() {
        return unitTypeComparator;
    }

    protected Border createBorder() {
        return new EmptyBorder(20, 20, 20, 20);
    }

    protected JLabel createUnitTypeLabel(AbstractUnit au) {
        UnitType unitType = au.getType(this.getSpecification());
        String roleId = au.getRoleId();
        int count = au.getNumber();
        this.getLibrary();
        ImageIcon unitIcon = ImageLibrary.getUnitImageIcon(unitType, roleId, count == 0, 0.66);
        JLabel unitLabel = new JLabel(unitIcon);
        unitLabel.setText(String.valueOf(count));
        if (count == 0) {
            unitLabel.setForeground(Color.GRAY);
        }
        unitLabel.setToolTipText(au.getDescription());
        return unitLabel;
    }

    protected String getLocationLabelFor(Unit unit) {
        if (unit.getDestination() instanceof Map) {
            return Messages.message("goingToAmerica");
        }
        if (unit.getDestination() instanceof Europe) {
            return Messages.message("goingToEurope");
        }
        return Messages.message(unit.getLocation().getLocationLabelFor(unit.getOwner()));
    }

    protected void setMainComponent(Component main) {
        this.remove(this.scrollPane);
        this.add(main, "cell 0 1, height 100%, width 100%");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            FreeColGameObject object = this.getGame().getFreeColGameObject(command);
            if (object instanceof Colony) {
                this.getGUI().showColonyPanel((Colony)object, null);
            } else if (object instanceof Europe) {
                this.getGUI().showEuropePanel();
            } else if (object instanceof IndianSettlement) {
                this.getGUI().showIndianSettlementPanel((IndianSettlement)object);
            } else if (object instanceof Tile) {
                this.getGUI().setFocus((Tile)object);
            } else {
                this.getGUI().showColopediaPanel(command);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.scrollPane = null;
    }
}

