/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportNavalPanel
extends ReportUnitPanel {
    public ReportNavalPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportNavalAction", false);
    }

    private boolean reportable(UnitType unitType) {
        return unitType.isNaval() && unitType.isAvailableTo(this.getMyPlayer());
    }

    private boolean reportable(Unit unit) {
        return unit.isNaval();
    }

    @Override
    protected void gatherData() {
        for (Unit unit : this.getMyPlayer().getUnits()) {
            if (!this.reportable(unit)) continue;
            this.addUnit(unit, "naval");
        }
    }

    @Override
    protected void addREFUnits() {
        Specification spec = this.getSpecification();
        Nation refNation = this.getMyPlayer().getNation().getREFNation();
        this.reportPanel.add((Component)new JLabel(Messages.getName(refNation)), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.igc().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit au : refUnits) {
                if (!au.getType(spec).isNaval()) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
            }
        }
    }

    @Override
    protected void addOwnUnits() {
        Specification spec = this.getSpecification();
        Player player = this.getMyPlayer();
        this.reportPanel.add((Component)GUI.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!this.reportable(unitType)) continue;
            AbstractUnit au = new AbstractUnit(unitType, "model.role.default", this.getCount("naval", unitType));
            this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
        }
    }
}

