/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitType;

public final class ReportLabourDetailPanel
extends ReportPanel
implements ActionListener {
    private final Map<UnitType, Map<Location, Integer>> data;
    private final TypeCountMap<UnitType> unitCount;
    private final List<Colony> colonies;
    private final UnitType unitType;

    public ReportLabourDetailPanel(FreeColClient freeColClient, UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        super(freeColClient, "report.labour.details");
        this.unitType = unitType;
        this.data = data;
        this.unitCount = unitCount;
        this.colonies = colonies;
    }

    @Override
    public void initialize() {
        JLabel countLabel;
        MigPanel detailPanel = new MigPanel();
        detailPanel.setLayout(new MigLayout("wrap 7", "[]30[][]30[][]30[][]", ""));
        detailPanel.setOpaque(false);
        detailPanel.add((Component)new JLabel(this.getLibrary().getUnitImageIcon(this.unitType)), "spany");
        detailPanel.add(GUI.localizedLabel(this.unitType.getNameKey()));
        detailPanel.add((Component)new JLabel(String.valueOf(this.unitCount.getCount(this.unitType))), "wrap 10");
        boolean canTrain = false;
        Map<Location, Integer> unitLocations = this.data.get(this.unitType);
        for (Colony colony : this.colonies) {
            if (unitLocations.get(colony) == null) continue;
            String colonyName = colony.getName();
            if (colony.canTrain(this.unitType)) {
                canTrain = true;
                colonyName = colonyName + "*";
            }
            JButton colonyButton = GUI.getLinkButton(colonyName, null, colony.getId());
            colonyButton.addActionListener(this);
            detailPanel.add(colonyButton);
            countLabel = new JLabel(unitLocations.get(colony).toString());
            countLabel.setForeground(GUI.LINK_COLOR);
            detailPanel.add(countLabel);
        }
        for (Map.Entry entry : unitLocations.entrySet()) {
            if (entry.getKey() instanceof Colony) continue;
            String locationName = Messages.message(((Location)entry.getKey()).getLocationLabel());
            JButton linkButton = GUI.getLinkButton(locationName, null, ((Location)entry.getKey()).getId());
            linkButton.addActionListener(this);
            detailPanel.add(linkButton);
            countLabel = new JLabel(((Integer)entry.getValue()).toString());
            countLabel.setForeground(GUI.LINK_COLOR);
            detailPanel.add(countLabel);
        }
        if (canTrain) {
            detailPanel.add((Component)GUI.localizedLabel("report.labour.canTrain"), "newline 20, span");
        }
        this.reportPanel.add(detailPanel);
    }
}

