/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportIndianPanel
extends ReportPanel {
    private static final String[] headlines = new String[]{"Settlement", "mission", "report.indian.tension", "report.indian.skillTaught", "report.indian.mostHated", "report.indian.tradeInterests"};

    public ReportIndianPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportIndianAction");
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout(new MigLayout("wrap 6, fillx, insets 0", "[]20px[center]", "[top]"));
        boolean needsSeperator = false;
        for (Player opponent : this.getGame().getLiveNativePlayers(null)) {
            if (!player.hasContacted(opponent)) continue;
            if (needsSeperator) {
                this.reportPanel.add((Component)new JSeparator(0), "newline 20, span, growx, wrap 20");
            }
            this.buildIndianAdvisorPanel(player, opponent);
            needsSeperator = true;
        }
        this.scrollPane.getViewport().setOpaque(false);
        this.reportPanel.setOpaque(true);
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        NationSummary ns = this.igc().getNationSummary(opponent);
        List<IndianSettlement> nativeSettlements = opponent.getIndianSettlements();
        String numSettlements = String.valueOf(nativeSettlements.size()) + " / " + String.valueOf(ns.getNumberOfSettlements());
        ImageLibrary lib = this.getLibrary();
        JLabel villageLabel = new JLabel();
        villageLabel.setIcon(new ImageIcon(ImageLibrary.getSettlementImage(opponent.getNationType().getCapitalType(), 0.66)));
        this.reportPanel.add((Component)villageLabel, "span, split 2");
        JLabel headline = GUI.localizedLabel(opponent.getNationName());
        headline.setFont(GUI.SMALL_HEADER_FONT);
        this.reportPanel.add((Component)headline, "wrap 20");
        JLabel label = GUI.localizedLabel("report.indian.chieftain");
        label.setFont(GUI.DEFAULT_BOLD_FONT);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)GUI.localizedLabel(opponent.getName()), "left, wrap");
        label = GUI.localizedLabel("report.indian.typeOfSettlements");
        label.setFont(GUI.DEFAULT_BOLD_FONT);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)GUI.localizedLabel(Messages.nameKey(opponent.getNationType().getCapitalType().getId())), "left, wrap");
        label = GUI.localizedLabel("report.indian.numberOfSettlements");
        this.reportPanel.add(label);
        label.setFont(GUI.DEFAULT_BOLD_FONT);
        this.reportPanel.add((Component)new JLabel(numSettlements), "left, wrap");
        label = GUI.localizedLabel("report.indian.tribeTension");
        this.reportPanel.add(label);
        label.setFont(GUI.DEFAULT_BOLD_FONT);
        this.reportPanel.add((Component)GUI.localizedLabel(StringTemplate.template("report.indian.tensionStance").add("%tension%", opponent.getTension(player).getKey()).addStringTemplate("%stance%", opponent.getStance(player).getLabel())), "left, wrap 20");
        if (!nativeSettlements.isEmpty()) {
            for (String key : headlines) {
                JLabel head = GUI.localizedLabel(key);
                head.setFont(GUI.DEFAULT_BOLD_FONT);
                this.reportPanel.add(head);
            }
            ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>(nativeSettlements.size());
            for (IndianSettlement settlement : nativeSettlements) {
                if (settlement.isCapital()) {
                    settlements.add(0, settlement);
                    continue;
                }
                settlements.add(settlement);
            }
            for (IndianSettlement settlement : settlements) {
                String skillString;
                Tile tile = settlement.getTile();
                boolean known = tile.isExplored();
                boolean contacted = settlement.hasContacted(player);
                boolean visited = settlement.hasVisited(player);
                boolean scouted = settlement.hasScouted(player);
                String locationName = Messages.message(settlement.getLocationLabelFor(player));
                if (known && settlement.isCapital()) {
                    locationName = locationName + Messages.message("indianSettlement.capital");
                }
                if (settlement.worthScouting(player)) {
                    locationName = locationName + Messages.message("indianSettlement.unscouted");
                }
                JButton settlementButton = GUI.getLinkButton(locationName, null, settlement.getTile().getId());
                settlementButton.addActionListener(this);
                this.reportPanel.add((Component)settlementButton, "newline 15");
                JLabel missionLabel = new JLabel();
                Unit missionary = settlement.getMissionary();
                if (missionary == null) {
                    missionLabel.setText("");
                } else {
                    boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                    Image chip = lib.getMissionChip(missionary.getOwner(), expert);
                    missionLabel.setIcon(new ImageIcon(chip));
                    GUI.localizeToolTip((JComponent)missionLabel, StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", missionary.getOwner().getNationName()).addStringTemplate("%unit%", missionary.getLabel(Unit.UnitLabelType.NATIONAL)));
                }
                this.reportPanel.add(missionLabel);
                String messageId = settlement.getShortAlarmLevelMessageId(player);
                this.reportPanel.add(GUI.localizedLabel(messageId));
                JLabel skillLabel = new JLabel();
                skillLabel.setVerticalTextPosition(1);
                skillLabel.setHorizontalTextPosition(0);
                UnitType skillType = settlement.getLearnableSkill();
                if (visited) {
                    if (skillType == null) {
                        skillString = "indianSettlement.skillNone";
                    } else {
                        skillString = skillType.getNameKey();
                        this.getLibrary();
                        skillLabel.setIcon(ImageLibrary.getUnitImageIcon(skillType, 0.66));
                    }
                } else {
                    skillString = "indianSettlement.skillUnknown";
                }
                skillLabel.setText(Messages.message(skillString));
                this.reportPanel.add(skillLabel);
                Player mostHated = settlement.getMostHated();
                JLabel mostHatedLabel = contacted ? (mostHated == null ? GUI.localizedLabel("indianSettlement.mostHatedNone") : GUI.localizedLabel(mostHated.getNationName())) : GUI.localizedLabel("indianSettlement.mostHatedUnknown");
                this.reportPanel.add(mostHatedLabel);
                GoodsType[] wantedGoods = settlement.getWantedGoods();
                if (visited) {
                    if (wantedGoods[0] == null) {
                        this.reportPanel.add(GUI.localizedLabel("indianSettlement.wantedGoodsNone"));
                        continue;
                    }
                    JLabel goodsLabel = GUI.localizedLabel(wantedGoods[0].getNameKey());
                    this.getLibrary();
                    goodsLabel.setIcon(new ImageIcon(ImageLibrary.getGoodsImage(wantedGoods[0], 0.66)));
                    String split = "flowy, split " + String.valueOf(wantedGoods.length);
                    this.reportPanel.add((Component)goodsLabel, split);
                    for (int i = 1; i < wantedGoods.length; ++i) {
                        if (wantedGoods[i] == null) continue;
                        String sale = player.getLastSaleString(settlement, wantedGoods[i]);
                        goodsLabel = new JLabel(Messages.getName(wantedGoods[i]) + (sale == null ? "" : " " + sale));
                        this.getLibrary();
                        goodsLabel.setIcon(ImageLibrary.getScaledGoodsImageIcon(wantedGoods[i], 0.5));
                        this.reportPanel.add(goodsLabel);
                    }
                    continue;
                }
                this.reportPanel.add(GUI.localizedLabel("indianSettlement.wantedGoodsUnknown"));
            }
        } else {
            this.reportPanel.add(GUI.localizedLabel("report.indian.noKnownSettlements"));
        }
    }
}

