/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;

public final class QuickActionMenu
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(QuickActionMenu.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;
    private final FreeColPanel parentPanel;

    public QuickActionMenu(FreeColClient freeColClient, FreeColPanel freeColPanel) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.parentPanel = freeColPanel;
    }

    private void promptForGoods(AbstractGoods ag) {
        int ret = this.gui.showSelectAmountDialog(ag.getType(), 100, ag.getAmount(), true);
        if (ret > 0) {
            ag.setAmount(ret);
        }
    }

    public void createUnitMenu(UnitLabel unitLabel) {
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        Unit unit = unitLabel.getUnit();
        this.setLabel("Unit");
        ImageIcon unitIcon = ImageLibrary.getUnitImageIcon(unit, 0.66);
        JMenuItem name = new JMenuItem(unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + Messages.message("menuBar.colopedia") + ")", unitIcon);
        name.setActionCommand(UnitLabel.UnitAction.COLOPEDIA.toString());
        name.addActionListener(unitLabel);
        this.add(name);
        this.addSeparator();
        if (this.addCarrierItems(unitLabel)) {
            this.addSeparator();
        }
        if (unit.isInEurope()) {
            if (this.addCommandItems(unitLabel)) {
                this.addSeparator();
            }
            if (this.addBoardItems(unitLabel, unit.getOwner().getEurope())) {
                this.addSeparator();
            }
        } else if (unit.hasTile()) {
            Colony colony = unit.getLocation().getTile().getColony();
            if (colony != null) {
                if (this.addTileItem(unitLabel)) {
                    this.addSeparator();
                }
                if (this.addWorkItems(unitLabel)) {
                    this.addSeparator();
                }
                if (this.addEducationItems(unitLabel)) {
                    this.addSeparator();
                }
                if (unit.isInColony() && colony.canReducePopulation()) {
                    JMenuItem menuItem = GUI.localizedMenuItem("leaveTown");
                    menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_TOWN.toString());
                    menuItem.addActionListener(unitLabel);
                    this.add(menuItem);
                    this.addBoardItems(unitLabel, colony.getTile());
                    this.addSeparator();
                } else {
                    if (this.addCommandItems(unitLabel)) {
                        this.addSeparator();
                    }
                    if (this.addBoardItems(unitLabel, colony.getTile())) {
                        this.addSeparator();
                    }
                }
            } else if (this.addCommandItems(unitLabel)) {
                this.addSeparator();
            }
        }
        if (unit.hasAbility("model.ability.canBeEquipped") && this.addRoleItems(unitLabel)) {
            this.addSeparator();
        }
    }

    private boolean addBoardItems(UnitLabel unitLabel, Location loc) {
        final InGameController igc = this.freeColClient.getInGameController();
        final Unit tempUnit = unitLabel.getUnit();
        if (tempUnit.isCarrier()) {
            return false;
        }
        boolean added = false;
        for (final Unit unit : loc.getUnitList()) {
            if (!unit.isCarrier() || !unit.canCarryUnits() || !unit.canAdd(tempUnit) || tempUnit.getLocation() == unit) continue;
            StringTemplate template = StringTemplate.template("board").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = GUI.localizedMenuItem(template);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    igc.boardShip(tempUnit, unit);
                }
            });
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private boolean addLoadItems(final Goods goods, Location loc) {
        final InGameController igc = this.freeColClient.getInGameController();
        boolean added = false;
        for (final Unit unit : loc.getUnitList()) {
            if (!unit.isCarrier() || !unit.canCarryGoods() || !unit.canAdd(goods)) continue;
            StringTemplate template = StringTemplate.template("loadOnTo").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = GUI.localizedMenuItem(template);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 1) != 0) {
                        QuickActionMenu.this.promptForGoods(goods);
                    }
                    igc.loadCargo(goods, unit);
                }
            });
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private boolean addMarketItems(final AbstractGoods ag, Europe europe) {
        final InGameController igc = this.freeColClient.getInGameController();
        Goods goods = new Goods(europe.getGame(), null, ag.getType(), ag.getAmount());
        boolean added = false;
        for (final Unit unit : europe.getUnitList()) {
            if (!unit.isCarrier() || !unit.canCarryGoods() || !unit.canAdd(goods)) continue;
            StringTemplate template = StringTemplate.template("loadOnTo").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = GUI.localizedMenuItem(template);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 1) != 0) {
                        QuickActionMenu.this.promptForGoods(ag);
                    }
                    igc.buyGoods(ag.getType(), ag.getAmount(), unit);
                }
            });
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private boolean addCarrierItems(UnitLabel unitLabel) {
        JMenuItem menuItem;
        Unit unit = unitLabel.getUnit();
        if (!unit.isCarrier() || !unit.hasCargo()) {
            return false;
        }
        JMenuItem cargo = GUI.localizedMenuItem("cargoOnCarrier");
        this.add(cargo);
        for (Unit passenger : unit.getUnitList()) {
            menuItem = new JMenuItem("    " + passenger.getDescription(Unit.UnitLabelType.NATIONAL));
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            this.add(menuItem);
        }
        for (Goods goods : unit.getGoodsList()) {
            menuItem = new JMenuItem("    " + Messages.message(goods.getLabel(true)));
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            this.add(menuItem);
        }
        return true;
    }

    private List<JMenuItem> descendingList(final Map<JMenuItem, Integer> map) {
        ArrayList<JMenuItem> ret = new ArrayList<JMenuItem>(map.keySet());
        Collections.sort(ret, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem m1, JMenuItem m2) {
                Integer i1 = (Integer)map.get(m1);
                Integer i2 = (Integer)map.get(m2);
                int cmp = i2.compareTo(i1);
                if (cmp == 0) {
                    cmp = m1.getText().compareTo(m2.getText());
                }
                return cmp;
            }
        });
        return ret;
    }

    private JMenuItem makeProductionItem(GoodsType type, WorkLocation wl, int amount, UnitLabel unitLabel, boolean claim) {
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        StringTemplate t = StringTemplate.template(type.getId() + ".workAs").addAmount("%amount%", amount);
        if (claim) {
            t.addStringTemplate("%claim%", wl.getClaimTemplate());
        } else if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            t.addStringTemplate("%claim%", wl.getLocationLabel());
        } else {
            t.addName("%claim%", "");
        }
        JMenuItem menuItem = GUI.localizedMenuItem(t, (Icon)ImageLibrary.getScaledGoodsImageIcon(type, 0.66f));
        menuItem.setActionCommand(UnitLabel.getWorkLabel(wl) + "/" + wl.getId() + "/" + type.getId() + "/" + (claim ? "!" : ""));
        menuItem.addActionListener(unitLabel);
        return menuItem;
    }

    private boolean addWorkItems(UnitLabel unitLabel) {
        final Unit unit = unitLabel.getUnit();
        if (unit.isCarrier()) {
            return false;
        }
        UnitType unitType = unit.getType();
        GoodsType expertGoods = unitType.getExpertProduction();
        Colony colony = unit.getLocation().getColony();
        Specification spec = this.freeColClient.getGame().getSpecification();
        WorkLocation current = unit.getWorkLocation();
        int bonusChange = current != null ? 0 : colony.governmentChange(colony.getUnitCount() + 1);
        int bonus = colony.getProductionBonus();
        HashMap<JMenuItem, Integer> items = new HashMap<JMenuItem, Integer>();
        HashMap<JMenuItem, Integer> extras = new HashMap<JMenuItem, Integer>();
        JMenuItem expertOwned = null;
        JMenuItem expertUnowned = null;
        for (GoodsType type : spec.getGoodsTypeList()) {
            JMenuItem ji;
            int bestOwnedProd = bonus + bonusChange;
            int bestUnownedProd = bonus + bonusChange;
            WorkLocation bestOwned = null;
            WorkLocation bestUnowned = null;
            for (WorkLocation wl : colony.getAllWorkLocations()) {
                int prod = 0;
                switch (wl.getNoAddReason(unit)) {
                    case NONE: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestOwnedProd >= prod) break;
                        bestOwnedProd = prod;
                        bestOwned = wl;
                        break;
                    }
                    case ALREADY_PRESENT: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestOwnedProd >= prod) break;
                        bestOwnedProd = prod;
                        bestOwned = unit.getWorkType() == type ? null : wl;
                        break;
                    }
                    case CLAIM_REQUIRED: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestUnownedProd >= prod) break;
                        bestUnownedProd = prod;
                        bestUnowned = wl;
                        break;
                    }
                }
            }
            if (bestOwned != null && bestOwnedProd > 0) {
                ji = this.makeProductionItem(type, bestOwned, bestOwnedProd, unitLabel, false);
                if (type == expertGoods) {
                    expertOwned = ji;
                } else {
                    items.put(ji, bestOwnedProd);
                }
            }
            if (bestUnowned == null || bestUnownedProd <= bestOwnedProd || bestUnownedProd <= 0) continue;
            ji = this.makeProductionItem(type, bestUnowned, bestUnownedProd, unitLabel, true);
            if (type == expertGoods) {
                expertUnowned = ji;
                continue;
            }
            extras.put(ji, bestUnownedProd);
        }
        JMenu container = GUI.localizedMenu("model.unit.changeWork");
        List<JMenuItem> owned = this.descendingList(items);
        if (expertOwned != null) {
            owned.add(0, expertOwned);
        }
        for (JMenuItem j : owned) {
            container.add(j);
        }
        List<JMenuItem> unowned = this.descendingList(extras);
        if (expertUnowned != null) {
            unowned.add(0, expertUnowned);
        }
        if (!unowned.isEmpty()) {
            if (!owned.isEmpty()) {
                container.addSeparator();
            }
            for (JMenuItem j : unowned) {
                container.add(j);
            }
        }
        if (container.getItemCount() > 0) {
            this.add(container);
        }
        if (current != null && unit.getWorkType() != null) {
            JMenuItem ji = GUI.localizedMenuItem("showProductivity");
            ji.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    QuickActionMenu.this.gui.showWorkProductionPanel(unit);
                }
            });
            this.add(ji);
        }
        return !owned.isEmpty() || !unowned.isEmpty() || current != null;
    }

    private boolean addEducationItems(UnitLabel unitLabel) {
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        boolean separatorNeeded = false;
        Unit unit = unitLabel.getUnit();
        if (unit.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            for (Unit teacher : unit.getColony().getTeachers()) {
                if (!unit.canBeStudent(teacher) || !unit.isInColony()) continue;
                JMenuItem menuItem = null;
                ImageIcon teacherIcon = ImageLibrary.getUnitImageIcon(teacher, 0.5);
                if (teacher.getStudent() != unit) {
                    menuItem = GUI.localizedMenuItem("assignToTeacher", (Icon)teacherIcon);
                    if (teacher.getStudent() != null) {
                        menuItem.setText(menuItem.getText() + " (" + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining() + ")");
                    }
                    menuItem.setActionCommand((Object)((Object)UnitLabel.UnitAction.ASSIGN) + "/" + teacher.getId());
                    menuItem.addActionListener(unitLabel);
                } else {
                    menuItem = GUI.localizedMenuItem(StringTemplate.template("menu.unit.apprentice").addName("%unit%", Messages.getName(teacher.getType())), (Icon)teacherIcon);
                    menuItem.setText(menuItem.getText() + ": " + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining());
                    menuItem.setEnabled(false);
                }
                this.add(menuItem);
                separatorNeeded = true;
            }
        }
        if (unit.getStudent() != null) {
            Unit student = unit.getStudent();
            JMenuItem menuItem = GUI.localizedMenuItem(StringTemplate.template("menuBar.teacher").addName("%unit%", Messages.getName(student.getType())));
            menuItem.setText(menuItem.getText() + ": " + unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
            menuItem.setEnabled(false);
            this.add(menuItem);
            separatorNeeded = true;
        }
        int experience = unit.getExperience();
        GoodsType goods = unit.getExperienceType();
        if (experience > 0 && goods != null) {
            UnitType expertType = this.freeColClient.getGame().getSpecification().getExpertForProducing(goods);
            if (unit.getType().canBeUpgraded(expertType, UnitTypeChange.ChangeType.EXPERIENCE)) {
                int maxExperience = unit.getType().getMaximumExperience();
                double probability = (double)(unit.getType().getUnitTypeChange(expertType).getProbability(UnitTypeChange.ChangeType.EXPERIENCE) * experience) / (double)maxExperience;
                String jobName = Messages.message(goods.getWorkingAsKey());
                MigPanel experiencePanel = new MigPanel();
                experiencePanel.setLayout(new MigLayout("wrap 3"));
                experiencePanel.add((Component)new JLabel(ImageLibrary.getUnitImageIcon(expertType, 0.5)), "spany 2");
                experiencePanel.add(GUI.localizedLabel(StringTemplate.template("menu.unit.experience").addName("%job%", jobName)));
                experiencePanel.add((Component)GUI.localizedLabel(StringTemplate.template("fraction").addAmount("%numerator%", experience).addAmount("%denominator%", maxExperience)), "align right");
                experiencePanel.add(GUI.localizedLabel("menu.unit.upgrade"));
                experiencePanel.add((Component)new JLabel(ModifierFormat.format(probability) + "%"), "align right");
                this.add(experiencePanel);
                separatorNeeded = true;
            }
        }
        return separatorNeeded;
    }

    private boolean addCommandItems(UnitLabel unitLabel) {
        final Unit tempUnit = unitLabel.getUnit();
        boolean isUnitAtSea = tempUnit.isAtSea();
        JMenuItem menuItem = GUI.localizedMenuItem("activateUnit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tempUnit.getState() != Unit.UnitState.ACTIVE) {
                    QuickActionMenu.this.freeColClient.getInGameController().changeState(tempUnit, Unit.UnitState.ACTIVE);
                }
                QuickActionMenu.this.gui.setActiveUnit(tempUnit);
            }
        });
        menuItem.setEnabled(!isUnitAtSea);
        this.add(menuItem);
        if (!(tempUnit.getLocation() instanceof Europe)) {
            menuItem = GUI.localizedMenuItem("fortifyUnit");
            menuItem.setActionCommand(UnitLabel.UnitAction.FORTIFY.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(tempUnit.getMovesLeft() > 0 && tempUnit.getState() != Unit.UnitState.FORTIFIED && tempUnit.getState() != Unit.UnitState.FORTIFYING);
            this.add(menuItem);
        }
        Unit.UnitState unitState = tempUnit.getState();
        menuItem = GUI.localizedMenuItem("sentryUnit");
        menuItem.setActionCommand(UnitLabel.UnitAction.SENTRY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(unitState != Unit.UnitState.SENTRY && !isUnitAtSea);
        this.add(menuItem);
        boolean hasTradeRoute = tempUnit.getTradeRoute() != null;
        menuItem = GUI.localizedMenuItem("clearUnitOrders");
        menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_ORDERS.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled((unitState != Unit.UnitState.ACTIVE || hasTradeRoute) && !isUnitAtSea);
        this.add(menuItem);
        if (tempUnit.isCarrier()) {
            menuItem = GUI.localizedMenuItem("assignTradeRoute");
            menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN_TRADE_ROUTE.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(!hasTradeRoute);
            this.add(menuItem);
        }
        if (tempUnit.canCarryTreasure() && tempUnit.canCashInTreasureTrain()) {
            menuItem = GUI.localizedMenuItem("cashInTreasureTrain.order");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuickActionMenu.this.freeColClient.getInGameController().checkCashInTreasureTrain(tempUnit);
                }
            });
            menuItem.setEnabled(true);
            this.add(menuItem);
        }
        if (tempUnit.getLocation() instanceof Unit) {
            menuItem = GUI.localizedMenuItem("leaveShip");
            menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_SHIP.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(true);
            this.add(menuItem);
        }
        if (tempUnit.isCarrier()) {
            menuItem = GUI.localizedMenuItem("unload");
            menuItem.setActionCommand(UnitLabel.UnitAction.UNLOAD.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(tempUnit.hasCargo() && !isUnitAtSea);
            this.add(menuItem);
        }
        return true;
    }

    private JMenuItem createRoleItem(final UnitLabel unitLabel, Role from, int fromCount, final Role to, final int toCount, int price) {
        String key = "model.role.change." + to.getSuffix();
        if (!Messages.containsKey(key)) {
            key = "model.role.change." + from.getSuffix() + "." + to.getSuffix();
        }
        String text = Messages.message(key);
        if (price > 0) {
            text = text + " (" + Messages.message(StringTemplate.template("goldAmount").addAmount("%amount%", price)) + ")";
        }
        AbstractGoods change = null;
        List<AbstractGoods> need = Role.getGoodsDifference(from, fromCount, to, toCount);
        block0 : switch (need.size()) {
            case 0: {
                break;
            }
            case 1: {
                change = need.get(0);
                break;
            }
            default: {
                for (AbstractGoods ag : need) {
                    if (ag.getAmount() <= 0) continue;
                    change = ag;
                    break block0;
                }
            }
        }
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        ImageIcon icon = change == null ? null : ImageLibrary.getScaledGoodsImageIcon(change.getType(), 0.66f);
        JMenuItem item = new JMenuItem(text, icon);
        final InGameController igc = this.freeColClient.getInGameController();
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igc.equipUnitForRole(unitLabel.getUnit(), to, toCount);
                unitLabel.updateIcon();
                if (QuickActionMenu.this.parentPanel instanceof ColonyPanel) {
                    ((ColonyPanel)QuickActionMenu.this.parentPanel).update();
                }
            }
        });
        return item;
    }

    private boolean addRoleItems(UnitLabel unitLabel) {
        UnitLocation uloc;
        Unit unit = unitLabel.getUnit();
        Role role = unit.getRole();
        int roleCount = unit.getRoleCount();
        boolean separatorNeeded = false;
        UnitLocation unitLocation = uloc = unit.isInEurope() ? unit.getOwner().getEurope() : unit.getSettlement();
        if (uloc == null) {
            return false;
        }
        for (Role r : unit.getAvailableRoles(null)) {
            JMenuItem newItem;
            if (r == role) continue;
            if (r.isDefaultRole()) {
                newItem = this.createRoleItem(unitLabel, role, roleCount, r, 0, 0);
            } else {
                newItem = null;
                for (int count = r.getMaximumCount(); count > 0; --count) {
                    List<AbstractGoods> req = unit.getGoodsDifference(r, count);
                    int price = uloc.priceGoods(req);
                    if (price < 0 || !unit.getOwner().checkGold(price)) continue;
                    newItem = this.createRoleItem(unitLabel, role, roleCount, r, count, price);
                    break;
                }
            }
            if (newItem == null) continue;
            this.add(newItem);
            separatorNeeded = true;
        }
        UnitType newUnitType = unit.getType().getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newUnitType != null) {
            if (separatorNeeded) {
                this.addSeparator();
            }
            ImageLibrary imageLibrary = this.gui.getImageLibrary();
            JMenuItem menuItem = GUI.localizedMenuItem("clearSpeciality", (Icon)ImageLibrary.getUnitImageIcon(newUnitType, 0.3333333333333333));
            menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_SPECIALITY.toString());
            menuItem.addActionListener(unitLabel);
            this.add(menuItem);
            if (unit.getLocation() instanceof Building && !((Building)unit.getLocation()).canAddType(newUnitType)) {
                menuItem.setEnabled(false);
            }
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    public void createTileMenu(ColonyPanel.TilesPanel.ASingleTilePanel singleTilePanel) {
        if (singleTilePanel.getColonyTile() != null && singleTilePanel.getColonyTile().getColony() != null) {
            this.addTileItem(singleTilePanel.getColonyTile().getWorkTile());
        }
    }

    private boolean addTileItem(UnitLabel unitLabel) {
        Unit unit = unitLabel.getUnit();
        if (unit.getWorkTile() != null) {
            Tile tile = unit.getWorkTile().getWorkTile();
            this.addTileItem(tile);
            return true;
        }
        return false;
    }

    private void addTileItem(final Tile tile) {
        if (tile != null) {
            JMenuItem menuItem = new JMenuItem(Messages.getName(tile));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    QuickActionMenu.this.gui.showTilePanel(tile);
                }
            });
            this.add(menuItem);
        }
    }

    private void addPayArrears(final GoodsType goodsType) {
        final InGameController igc = this.freeColClient.getInGameController();
        JMenuItem menuItem = GUI.localizedMenuItem("boycottedGoods.payArrears");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igc.payArrears(goodsType);
                if (QuickActionMenu.this.parentPanel instanceof CargoPanel) {
                    CargoPanel cargoPanel = (CargoPanel)QuickActionMenu.this.parentPanel;
                    cargoPanel.initialize();
                }
                QuickActionMenu.this.parentPanel.revalidate();
            }
        });
        this.add(menuItem);
    }

    public void createGoodsMenu(GoodsLabel goodsLabel) {
        int amount;
        final InGameController igc = this.freeColClient.getInGameController();
        Player player = this.freeColClient.getMyPlayer();
        final Goods goods = goodsLabel.getGoods();
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        this.setLabel(Messages.message("cargo"));
        JMenuItem name = new JMenuItem(Messages.getName(goods) + " (" + Messages.message("menuBar.colopedia") + ")", ImageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.66f));
        name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickActionMenu.this.gui.showColopediaPanel(goods.getType().getId());
            }
        });
        this.add(name);
        int n = amount = player.getMarket() == null ? 0 : player.getMarket().getSalePrice(goods.getType(), goods.getAmount());
        if (amount > 0) {
            amount -= amount * player.getTax() / 100;
        }
        if (amount > 0) {
            JMenuItem price = GUI.localizedMenuItem(StringTemplate.template("quickActionMenu.profit").addAmount("%amount%", amount));
            this.add(price);
        }
        if (goods.getLocation() instanceof Colony) {
            Colony colony = (Colony)goods.getLocation();
            this.addLoadItems(goods, colony.getTile());
        } else if (goods.getLocation() instanceof Europe) {
            Europe europe = (Europe)goods.getLocation();
            this.addLoadItems(goods, europe);
            if (!player.canTrade(goods.getType())) {
                this.addPayArrears(goods.getType());
            }
        } else if (goods.getLocation() instanceof Unit) {
            Unit carrier = (Unit)goods.getLocation();
            if (carrier.getLocation().getColony() != null || carrier.isInEurope() && player.canTrade(goods.getType())) {
                JMenuItem unload = GUI.localizedMenuItem("unload");
                unload.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((e.getModifiers() & 1) != 0) {
                            QuickActionMenu.this.promptForGoods(goods);
                        }
                        igc.unloadCargo(goods, false);
                    }
                });
                this.add(unload);
            } else {
                if (carrier.isInEurope() && !player.canTrade(goods.getType())) {
                    this.addPayArrears(goods.getType());
                }
                JMenuItem dump = GUI.localizedMenuItem("dumpCargo");
                dump.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((e.getModifiers() & 1) != 0) {
                            QuickActionMenu.this.promptForGoods(goods);
                        }
                        igc.unloadCargo(goods, true);
                        if (QuickActionMenu.this.parentPanel instanceof CargoPanel) {
                            ((CargoPanel)QuickActionMenu.this.parentPanel).initialize();
                        }
                        QuickActionMenu.this.parentPanel.revalidate();
                    }
                });
                this.add(dump);
            }
        }
    }

    public void createMarketMenu(MarketLabel marketLabel, Europe europe) {
        Player player = this.freeColClient.getMyPlayer();
        final AbstractGoods ag = marketLabel.getGoods();
        ImageLibrary imageLibrary = this.gui.getImageLibrary();
        this.setLabel(Messages.message("cargo"));
        JMenuItem name = new JMenuItem(Messages.getName(ag) + " (" + Messages.message("menuBar.colopedia") + ")", ImageLibrary.getScaledGoodsImageIcon(ag.getType(), 0.66f));
        name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickActionMenu.this.gui.showColopediaPanel(ag.getType().getId());
            }
        });
        this.add(name);
        this.addMarketItems(ag, europe);
        if (!player.canTrade(ag.getType())) {
            this.addPayArrears(ag.getType());
        }
    }
}

