/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;

public abstract class OptionsDialog
extends FreeColDialog<OptionGroup> {
    private static final Logger logger = Logger.getLogger(OptionsDialog.class.getName());
    private final boolean editable;
    private OptionGroup group;
    private OptionGroupUI ui;
    private final String defaultFileName;
    private final String optionGroupId;
    private JScrollPane scrollPane;
    private MigPanel optionPanel;
    protected MigPanel panel;

    public OptionsDialog(FreeColClient freeColClient, boolean editable, OptionGroup group, String header, String defaultFileName, String optionGroupId) {
        super(freeColClient);
        this.editable = editable;
        this.group = group;
        this.ui = new OptionGroupUI(this.getGUI(), this.group, this.editable);
        this.defaultFileName = defaultFileName;
        this.optionGroupId = optionGroupId;
        this.preparePanel(header, this.ui);
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected OptionGroup getGroup() {
        return this.group;
    }

    protected OptionGroupUI getOptionUI() {
        return this.ui;
    }

    protected String getDefaultFileName() {
        return this.defaultFileName;
    }

    protected String getOptionGroupId() {
        return this.optionGroupId;
    }

    private void preparePanel(String header, OptionGroupUI ui) {
        this.optionPanel = new MigPanel("ReportPanelUI");
        this.optionPanel.setOpaque(true);
        this.optionPanel.add(ui);
        this.optionPanel.setSize(this.optionPanel.getPreferredSize());
        this.scrollPane = new JScrollPane(this.optionPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panel = new MigPanel(new MigLayout("wrap 1, fill"));
        this.panel.add((Component)GUI.getDefaultHeader(header), "center");
    }

    protected void initialize() {
        this.panel.add((Component)this.scrollPane, "height 100%, width 100%");
        this.panel.setPreferredSize(new Dimension(850, 650));
        this.panel.setSize(this.panel.getPreferredSize());
        List c = OptionsDialog.choices();
        c.add(new ChoiceItem<OptionGroup>(Messages.message("ok"), this.group).okOption());
        c.add(new ChoiceItem<OptionGroup>(Messages.message("cancel"), null, this.isEditable()).cancelOption().defaultOption());
        this.initializeDialog(FreeColDialog.DialogType.PLAIN, true, this.panel, null, c);
    }

    private void reset(OptionGroup group) {
        this.group = group;
        this.optionPanel.removeAll();
        this.ui = new OptionGroupUI(this.getGUI(), this.group, this.editable);
        this.optionPanel.add(this.ui);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected boolean load(File file) {
        OptionGroup og = this.getSpecification().loadOptionsFile(this.getOptionGroupId(), file);
        if (og == null) {
            return false;
        }
        this.reset(og);
        return true;
    }

    protected boolean save(File file) {
        OptionGroup og = Specification.saveOptionsFile(this.group, file);
        if (og != null) {
            return true;
        }
        StringTemplate t = StringTemplate.template("failedToSave").addName("%name%", file.getPath());
        this.getGUI().showInformationMessage(t);
        return false;
    }

    protected boolean loadDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return f.exists() ? this.load(f) : false;
    }

    protected boolean saveDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return this.save(f);
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = (OptionGroup)super.getResponse();
        if (value == null) {
            this.getOptionUI().reset();
        } else {
            this.getOptionUI().updateOption();
        }
        return value;
    }
}

