/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class NewPanel
extends FreeColPanel
implements ActionListener,
ItemListener {
    private static final Logger logger = Logger.getLogger(NewPanel.class.getName());
    private final Specification fixedSpecification;
    private Specification specification = null;
    private OptionGroup difficulty = null;
    private final JTextField nameBox;
    private final ButtonGroup buttonGroup;
    private final JLabel advantagesLabel;
    private final JComboBox<NationOptions.Advantages> advantagesBox;
    private final JLabel serverPortLabel;
    private final JTextField serverPortField;
    private final JLabel rulesLabel;
    private final JComboBox<FreeColTcFile> rulesBox;
    private final JCheckBox publicServer;
    private final JLabel difficultyLabel;
    private final JComboBox<OptionGroup> difficultyBox;
    private final JButton difficultyButton;
    private final JLabel joinNameLabel;
    private final JTextField joinNameField;
    private final JLabel joinPortLabel;
    private final JTextField joinPortField;
    private final Component[] joinComponents;
    private final Component[] serverComponents;
    private final Component[] gameComponents;

    public NewPanel(FreeColClient freeColClient) {
        this(freeColClient, (Specification)null);
    }

    public NewPanel(FreeColClient freeColClient, Specification specification) {
        super(freeColClient, new MigLayout("wrap 6", "[15]", ""));
        String selectTC;
        this.fixedSpecification = specification;
        this.buttonGroup = new ButtonGroup();
        JRadioButton single = new JRadioButton(Messages.message("singlePlayerGame"), true);
        JRadioButton join = new JRadioButton(Messages.message("joinMultiPlayerGame"), false);
        JRadioButton start = new JRadioButton(Messages.message("startMultiplayerGame"), false);
        JRadioButton meta = new JRadioButton(Messages.message("getServerList") + " (" + "meta.freecol.org" + ")", false);
        this.buttonGroup.add(single);
        single.setActionCommand(String.valueOf((Object)NewPanelAction.SINGLE));
        single.addActionListener(this);
        this.buttonGroup.add(join);
        join.setActionCommand(String.valueOf((Object)NewPanelAction.JOIN));
        join.addActionListener(this);
        this.buttonGroup.add(start);
        start.setActionCommand(String.valueOf((Object)NewPanelAction.START));
        start.addActionListener(this);
        this.buttonGroup.add(meta);
        meta.setActionCommand(String.valueOf((Object)NewPanelAction.META_SERVER));
        meta.addActionListener(this);
        single.setSelected(true);
        String name = this.getClientOptions().getText("model.option.playerName");
        if (name == null || name.isEmpty()) {
            name = FreeCol.getName();
        }
        this.nameBox = new JTextField(name, 20);
        this.advantagesLabel = GUI.localizedLabel("playerOptions.nationalAdvantages");
        this.advantagesBox = new JComboBox<NationOptions.Advantages>(new NationOptions.Advantages[]{NationOptions.Advantages.SELECTABLE, NationOptions.Advantages.FIXED, NationOptions.Advantages.NONE});
        this.advantagesBox.setRenderer(new FreeColComboBoxRenderer());
        this.serverPortLabel = GUI.localizedLabel("startServerOnPort");
        this.serverPortField = new JTextField(Integer.toString(FreeCol.getServerPort()));
        this.serverPortField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewPanel.this.getSelectedPort(NewPanel.this.serverPortField);
            }
        });
        this.rulesLabel = GUI.localizedLabel("rules");
        this.rulesBox = new JComboBox();
        if (this.fixedSpecification == null) {
            selectTC = FreeCol.getTC();
            for (FreeColTcFile tc : Mods.getRuleSets()) {
                this.rulesBox.addItem(tc);
                if (!selectTC.equals(tc.getId())) continue;
                this.rulesBox.setSelectedItem(tc);
            }
        } else {
            selectTC = this.fixedSpecification.getId();
            for (FreeColTcFile tc : Mods.getRuleSets()) {
                if (!selectTC.equals(tc.getId())) continue;
                this.rulesBox.addItem(tc);
                this.rulesBox.setSelectedItem(tc);
            }
        }
        this.rulesBox.setRenderer(new FreeColComboBoxRenderer("mod."));
        this.rulesBox.addItemListener(this);
        this.publicServer = new JCheckBox(Messages.message("publicServer"));
        this.difficultyLabel = GUI.localizedLabel("difficulty");
        this.difficultyBox = new JComboBox();
        this.difficultyBox.setRenderer(new FreeColComboBoxRenderer());
        this.difficultyBox.addItemListener(this);
        this.difficultyButton = GUI.localizedButton("showDifficulty");
        this.difficultyButton.setActionCommand(String.valueOf((Object)NewPanelAction.SHOW_DIFFICULTY));
        this.difficultyButton.addActionListener(this);
        this.joinNameLabel = GUI.localizedLabel("host");
        this.joinNameField = new JTextField(FreeCol.getServerHost());
        this.joinPortLabel = GUI.localizedLabel("port");
        this.joinPortField = new JTextField(Integer.toString(FreeCol.getServerPort()));
        this.joinPortField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewPanel.this.getSelectedPort(NewPanel.this.joinPortField);
            }
        });
        this.okButton.setActionCommand(String.valueOf((Object)NewPanelAction.OK));
        JButton cancel = GUI.localizedButton("cancel");
        cancel.setActionCommand(String.valueOf((Object)NewPanelAction.CANCEL));
        cancel.addActionListener(this);
        this.setCancelComponent(cancel);
        this.add((Component)GUI.getDefaultHeader(Messages.message("newGamePanel")), "span 6, center");
        this.add((Component)single, "newline, span 3");
        this.add((Component)new JSeparator(1), "spany 7, grow");
        this.add((Component)GUI.localizedLabel("name"), "span, split 2");
        this.add((Component)this.nameBox, "growx");
        this.add((Component)start, "newline, span 3");
        this.add(this.advantagesLabel);
        this.add(this.advantagesBox, "growx");
        this.add((Component)this.serverPortLabel, "newline, skip");
        this.add((Component)this.serverPortField, "width 60:");
        this.add(this.rulesLabel);
        this.add(this.rulesBox, "growx");
        this.add((Component)this.publicServer, "newline, skip, span 2");
        this.add(this.difficultyLabel);
        this.add(this.difficultyBox, "growx");
        this.add((Component)meta, "newline, span 3");
        this.add((Component)this.difficultyButton, "skip 2, growx");
        this.add((Component)join, "newline, span 3");
        this.add((Component)this.joinNameLabel, "newline, skip, split 2");
        this.add((Component)this.joinNameField, "width 80:");
        this.add((Component)this.joinPortLabel, "split 2");
        this.add((Component)this.joinPortField, "width 60:");
        this.add((Component)this.okButton, "newline, span, split 2, tag ok");
        this.add((Component)cancel, "tag cancel");
        this.joinComponents = new Component[]{this.joinNameLabel, this.joinNameField, this.joinPortLabel, this.joinPortField};
        this.serverComponents = new Component[]{this.serverPortLabel, this.serverPortField, this.publicServer};
        this.gameComponents = new Component[]{this.advantagesLabel, this.advantagesBox, this.rulesLabel, this.rulesBox, this.difficultyLabel, this.difficultyBox, this.difficultyButton};
        this.specification = this.getSpecification();
        this.difficulty = null;
        this.updateDifficulty();
        this.enableComponents();
        this.setSize(this.getPreferredSize());
    }

    private void updateSpecification() {
        if (this.specification.getId().equals(this.getSelectedTC().getId())) {
            return;
        }
        this.specification = this.getSpecification();
        if (this.difficulty.isEditable()) {
            this.specification.prepare(null, this.difficulty);
        } else {
            String oldId = this.difficulty.getId();
            this.difficulty = this.specification.getDifficultyOptionGroup(oldId);
        }
        this.updateDifficulty();
    }

    private void updateDifficulty() {
        this.difficultyBox.removeItemListener(this);
        this.difficultyBox.removeAllItems();
        for (OptionGroup og : this.specification.getDifficultyLevels()) {
            this.difficultyBox.addItem(og);
        }
        if (this.difficulty == null) {
            this.difficulty = this.specification.getDifficultyOptionGroup(FreeCol.getDifficulty());
            if (this.difficulty == null) {
                int index = this.difficultyBox.getItemCount() / 2;
                this.difficulty = this.difficultyBox.getItemAt(index);
            }
        }
        this.difficultyBox.setSelectedItem(this.difficulty);
        this.updateShowButton();
        this.difficultyBox.addItemListener(this);
    }

    private void updateShowButton() {
        if (this.difficulty == null) {
            this.difficultyButton.setEnabled(false);
        } else {
            this.difficultyButton.setEnabled(true);
            String text = this.difficulty.isEditable() ? "editDifficulty" : "showDifficulty";
            this.difficultyButton.setText(Messages.message(text));
        }
    }

    private String getSelectedName() {
        return this.nameBox.getText();
    }

    private NationOptions.Advantages getSelectedAdvantages() {
        return (NationOptions.Advantages)this.advantagesBox.getSelectedItem();
    }

    private FreeColTcFile getSelectedTC() {
        return (FreeColTcFile)this.rulesBox.getSelectedItem();
    }

    private OptionGroup getSelectedDifficulty() {
        return (OptionGroup)this.difficultyBox.getSelectedItem();
    }

    private int getSelectedPort(JTextField field) {
        int port;
        try {
            port = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            port = -1;
        }
        if (0 < port && port < 65536) {
            return port;
        }
        field.setForeground(Color.red);
        return -1;
    }

    private void enableComponents() {
        NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.buttonGroup.getSelection().getActionCommand());
        switch (action) {
            case SINGLE: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, true);
                this.rulesBox.setEnabled(true);
                break;
            }
            case JOIN: {
                this.enableComponents(this.joinComponents, true);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
                this.rulesBox.setEnabled(false);
                break;
            }
            case START: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, true);
                this.enableComponents(this.gameComponents, true);
                this.rulesBox.setEnabled(true);
                break;
            }
            case META_SERVER: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
                this.rulesBox.setEnabled(false);
                break;
            }
        }
    }

    private void enableComponents(Component[] components, boolean enable) {
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }

    @Override
    public Specification getSpecification() {
        if (this.fixedSpecification != null) {
            return this.fixedSpecification;
        }
        return FreeCol.loadSpecification(this.getSelectedTC(), null, null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block16: {
            ConnectController cc = this.getFreeColClient().getConnectController();
            GUI gui = this.getGUI();
            String command = event.getActionCommand();
            switch (Enum.valueOf(NewPanelAction.class, command)) {
                case OK: {
                    FreeCol.setName(this.getSelectedName());
                    FreeCol.setAdvantages(this.getSelectedAdvantages());
                    FreeCol.setTC(this.getSelectedTC().getId());
                    NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.buttonGroup.getSelection().getActionCommand());
                    switch (action) {
                        case SINGLE: {
                            this.specification.prepare(this.getSelectedAdvantages(), this.difficulty);
                            if (cc.startSinglePlayerGame(this.specification, false)) {
                                return;
                            }
                            break block16;
                        }
                        case JOIN: {
                            int joinPort = this.getSelectedPort(this.joinPortField);
                            if (joinPort < 0) break;
                            if (cc.joinMultiplayerGame(this.joinNameField.getText(), joinPort)) {
                                return;
                            }
                            break block16;
                        }
                        case START: {
                            int serverPort = this.getSelectedPort(this.serverPortField);
                            if (serverPort < 0) break;
                            this.specification.prepare(this.getSelectedAdvantages(), this.difficulty);
                            if (cc.startMultiplayerGame(this.specification, this.publicServer.isSelected(), serverPort)) {
                                return;
                            }
                            break block16;
                        }
                        case META_SERVER: {
                            List<ServerInfo> servers = cc.getServerList();
                            if (servers != null) {
                                gui.showServerListPanel(servers);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case CANCEL: {
                    gui.removeFromCanvas(this);
                    gui.showMainPanel(null);
                    break;
                }
                case SHOW_DIFFICULTY: {
                    this.difficulty = gui.showDifficultyDialog(this.specification, this.difficulty);
                    this.updateDifficulty();
                    break;
                }
                case SINGLE: 
                case JOIN: 
                case START: 
                case META_SERVER: {
                    this.enableComponents();
                    break;
                }
                default: {
                    super.actionPerformed(event);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.rulesBox) {
            this.updateSpecification();
        } else if (e.getSource() == this.difficultyBox) {
            this.difficulty = this.getSelectedDifficulty();
            this.updateShowButton();
        }
    }

    private static enum NewPanelAction {
        OK,
        CANCEL,
        SINGLE,
        JOIN,
        START,
        META_SERVER,
        SHOW_DIFFICULTY;

    }
}

