/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.text.DecimalFormat;
import javax.swing.JLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Turn;

public class ModifierFormat {
    private static final DecimalFormat modifierFormat = new DecimalFormat("0.00");

    public static final String getUnknownValue() {
        return Messages.message("model.modifier.unknown");
    }

    public static final String format(double value) {
        return value == (double)1.4E-45f ? ModifierFormat.getUnknownValue() : modifierFormat.format(value);
    }

    public static final String[] getModifierStrings(Modifier modifier) {
        return ModifierFormat.getModifierStrings(modifier.getValue(), modifier.getType());
    }

    public static final String[] getModifierStrings(float value, Modifier.ModifierType type) {
        String[] stringArray;
        String bonus = modifierFormat.format(value);
        if (value == Float.MIN_VALUE) {
            return new String[]{" ", bonus, null};
        }
        if (value < 0.0f) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-";
            stringArray2[1] = bonus.substring(1);
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "+";
            stringArray3[1] = bonus;
            stringArray = stringArray3;
            stringArray3[2] = null;
        }
        String[] result = stringArray;
        switch (type) {
            case MULTIPLICATIVE: {
                result[0] = "\u00d7";
                break;
            }
            case PERCENTAGE: {
                result[2] = "%";
                break;
            }
        }
        return result;
    }

    private static String getSourceName(FreeColObject source) {
        if (source == null) {
            return ModifierFormat.getUnknownValue();
        }
        String result = null;
        if (result == null && source instanceof Nameable && (result = ((Nameable)((Object)source)).getName()) != null && result.isEmpty()) {
            result = null;
        }
        if (result == null && source instanceof Named && (result = Messages.getName((Named)((Object)source))) != null && result.isEmpty()) {
            result = null;
        }
        if (result == null) {
            result = Messages.getName(source.getId());
        }
        return result;
    }

    public static JLabel[] getModifierLabels(Modifier modifier, FreeColGameObjectType fcgot, Turn turn) {
        String sourceName = ModifierFormat.getSourceName(modifier.getSource());
        if (fcgot != null) {
            for (Scope scope : modifier.getScopes()) {
                if (!scope.appliesTo(fcgot)) continue;
                sourceName = sourceName + " (" + Messages.getName(fcgot) + ")";
            }
        }
        float value = modifier.getValue(turn);
        String[] bonus = ModifierFormat.getModifierStrings(value, modifier.getType());
        JLabel[] result = new JLabel[]{new JLabel(sourceName), new JLabel(bonus[0] + bonus[1]), bonus[2] == null ? null : new JLabel(bonus[2])};
        return result;
    }

    public static String getFeatureAsString(Feature feature) {
        String label = Messages.getName(feature) + ":";
        if (feature.hasScope()) {
            for (Scope scope : feature.getScopes()) {
                String key = null;
                if (scope.getType() != null) {
                    key = scope.getType();
                } else if (scope.getAbilityId() != null) {
                    key = scope.getAbilityId();
                } else if (scope.getMethodName() != null) {
                    key = "model.scope." + scope.getMethodName();
                }
                if (key == null) continue;
                label = label + (scope.isMatchNegated() ? " !" : " ") + Messages.getName(key) + ",";
            }
        }
        return label.substring(0, label.length() - 1);
    }

    public static String getModifierAsString(Modifier modifier) {
        String result = "";
        for (String string : ModifierFormat.getModifierStrings(modifier)) {
            if (string == null) continue;
            result = result + string;
        }
        return result;
    }
}

