/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Graphics;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;

public final class MarketLabel
extends AbstractGoodsLabel
implements Draggable {
    private static final Logger logger = Logger.getLogger(MarketLabel.class.getName());
    private final Market market;

    public MarketLabel(GoodsType type, Market market, GUI gui) {
        super(new AbstractGoods(type, 100), gui);
        if (market == null) {
            throw new IllegalArgumentException("Null market");
        }
        this.market = market;
    }

    public Market getMarket() {
        return this.market;
    }

    public void setAmount(int amount) {
        this.getGoods().setAmount(amount);
    }

    @Override
    public void setDefaultAmount() {
        this.setAmount(100);
    }

    @Override
    public boolean isOnCarrier() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        Player player = this.market.getOwner();
        GoodsType type = this.getType();
        String toolTipText = Messages.getName(type);
        if (player == null || player.canTrade(type)) {
            this.setEnabled(true);
        } else {
            toolTipText = Messages.message(type.getLabel());
            this.setEnabled(false);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            toolTipText = toolTipText + " " + this.market.getAmountInMarket(type);
        }
        this.setToolTipText(toolTipText);
        super.setText(this.market.getPaidForSale(type) + "/" + this.market.getCostToBuy(type));
        super.paintComponent(g);
    }
}

