/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.OptionGroup;

public final class MapGeneratorOptionsDialog
extends OptionsDialog {
    private static final Logger logger = Logger.getLogger(MapGeneratorOptionsDialog.class.getName());

    public MapGeneratorOptionsDialog(FreeColClient freeColClient, boolean editable) {
        super(freeColClient, editable, freeColClient.getGame().getMapGeneratorOptions(), Messages.message(MapGeneratorOptions.getXMLElementTagName()), "map_generator_options.xml", MapGeneratorOptions.getXMLElementTagName());
        if (this.isEditable()) {
            this.loadDefaultOptions();
            File mapDirectory = FreeColDirectories.getMapsDirectory();
            if (mapDirectory.isDirectory()) {
                File[] files = mapDirectory.listFiles(FreeCol.freeColSaveFileFilter);
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getName().compareTo(f2.getName());
                    }
                });
                JPanel mapPanel = new JPanel();
                for (final File file : files) {
                    JButton mapButton = this.makeMapButton(file);
                    if (mapButton == null) continue;
                    mapButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MapGeneratorOptionsDialog.this.updateFile(file);
                        }
                    });
                    mapPanel.add(mapButton);
                }
                JScrollPane scrollPane = new JScrollPane(mapPanel, 21, 30);
                scrollPane.getVerticalScrollBar().setUnitIncrement(16);
                scrollPane.getViewport().setOpaque(false);
                scrollPane.setMinimumSize(new Dimension(400, 110));
                this.panel.add(scrollPane);
            }
        }
        this.initialize();
    }

    private void updateFile(File file) {
        OptionGroup mgo = this.getGroup();
        OptionGroupUI mgoUI = this.getOptionUI();
        GUI gui = this.freeColClient.getGUI();
        FileOptionUI foui = (FileOptionUI)mgoUI.getOptionUI("model.option.importFile");
        if (foui == null) {
            foui = (FileOptionUI)OptionUI.getOptionUI(gui, mgo.getOption("model.option.importFile"), true);
        }
        foui.setValue(file);
        BooleanOptionUI terrainUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importTerrain");
        if (terrainUI == null) {
            terrainUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, mgo.getOption("model.option.importTerrain"), true);
        }
        terrainUI.setValue(true);
        BooleanOptionUI bonusesUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importBonuses");
        if (bonusesUI == null) {
            bonusesUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, mgo.getOption("model.option.importBonuses"), true);
        }
        bonusesUI.setValue(false);
        BooleanOptionUI rumourUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importRumours");
        if (rumourUI == null) {
            rumourUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, mgo.getOption("model.option.importRumours"), true);
        }
        rumourUI.setValue(false);
        BooleanOptionUI settlementsUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importSettlements");
        if (settlementsUI == null) {
            settlementsUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, mgo.getOption("model.option.importSettlements"), true);
        }
        settlementsUI.setValue(false);
    }

    private JButton makeMapButton(File file) {
        String mapName = file.getName().substring(0, file.getName().lastIndexOf(46));
        JButton mapButton = GUI.localizedButton("freecol.map." + mapName);
        try {
            FreeColSavegameFile savegame = new FreeColSavegameFile(file);
            BufferedImage thumbnail = ImageIO.read(savegame.getInputStream("thumbnail.png"));
            mapButton.setIcon(new ImageIcon(thumbnail));
            try {
                Properties properties = new Properties();
                properties.load(savegame.getInputStream("savegame.properties"));
                mapButton.setToolTipText(properties.getProperty("map.width") + "\u00d7" + properties.getProperty("map.height"));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to load savegame.", e);
                return null;
            }
            mapButton.setHorizontalTextPosition(0);
            mapButton.setVerticalTextPosition(3);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to read thumbnail.", e);
        }
        return mapButton;
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = super.getResponse();
        if (value != null && this.isEditable()) {
            this.saveDefaultOptions();
        }
        return value;
    }
}

