/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.resources.ResourceManager;

public final class MainPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MainPanel.class.getName());

    public MainPanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout("wrap 1, insets n n 20 n", "[center]"));
        boolean canContinue = FreeColDirectories.getLastSaveGameFile() != null;
        ActionManager am = this.getFreeColClient().getActionManager();
        JButton newButton = new JButton(am.getFreeColAction("newAction"));
        JButton openButton = new JButton(am.getFreeColAction("openAction"));
        JButton mapEditorButton = new JButton(am.getFreeColAction("mapEditorAction"));
        JButton optionsButton = new JButton(am.getFreeColAction("preferencesAction"));
        JButton quitButton = new JButton(am.getFreeColAction("quitAction"));
        this.setCancelComponent(quitButton);
        this.okButton.setAction(am.getFreeColAction(canContinue ? "continueAction" : "newAction"));
        Image tempImage = ResourceManager.getImage("TitleImage");
        if (tempImage != null) {
            JLabel logoLabel = new JLabel(new ImageIcon(tempImage));
            logoLabel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 0, 2), new BevelBorder(1)));
            this.add(logoLabel);
        }
        this.add((Component)this.okButton, "newline 20, width 70%");
        if (canContinue) {
            this.add((Component)newButton, "width 70%");
        }
        this.add((Component)openButton, "width 70%");
        this.add((Component)mapEditorButton, "width 70%");
        this.add((Component)optionsButton, "width 70%");
        this.add((Component)quitButton, "width 70%");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.getGUI().removeFromCanvas(this);
    }
}

