/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.common.i18n.Messages;

public final class LoadingSavegameDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(LoadingSavegameDialog.class.getName());
    private final JRadioButton singlePlayer;
    private final JRadioButton privateMultiplayer;
    private final JRadioButton publicMultiplayer;
    private final JTextField serverNameField;
    private final JSpinner portField;

    public LoadingSavegameDialog(FreeColClient freeColClient) {
        super(freeColClient);
        JPanel panel = new JPanel();
        panel.setBorder(GUI.blankBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        JLabel header = GUI.localizedLabel("LoadingSavegame.title", 0);
        header.setFont(GUI.MEDIUM_HEADER_FONT);
        header.setBorder(GUI.blankBorder(20, 0, 0, 0));
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(GUI.localizedLabel("LoadingSavegame.serverName"));
        this.serverNameField = new JTextField();
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(GUI.localizedLabel("LoadingSavegame.port"));
        this.portField = new JSpinner(new SpinnerNumberModel(FreeCol.getServerPort(), 1, 65536, 1));
        ButtonGroup bg = new ButtonGroup();
        String str = Messages.message("LoadingSavegame.singlePlayer");
        this.singlePlayer = new JRadioButton(str);
        bg.add(this.singlePlayer);
        str = Messages.message("LoadingSavegame.privateMultiplayer");
        this.privateMultiplayer = new JRadioButton(str);
        bg.add(this.privateMultiplayer);
        str = Messages.message("LoadingSavegame.publicMultiplayer");
        this.publicMultiplayer = new JRadioButton(str);
        bg.add(this.publicMultiplayer);
        panel.add(header);
        panel.add(p1);
        panel.add(this.serverNameField);
        panel.add(p2);
        panel.add(this.portField);
        panel.add(this.singlePlayer);
        panel.add(this.privateMultiplayer);
        panel.add(this.publicMultiplayer);
        panel.setSize(panel.getPreferredSize());
        this.initializeConfirmDialog(true, panel, null, "ok", "cancel");
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer.isSelected();
    }

    public boolean isPublic() {
        return this.publicMultiplayer.isSelected();
    }

    public int getPort() {
        return (Integer)this.portField.getValue();
    }

    public String getServerName() {
        return this.serverNameField.getName();
    }

    public void reset(boolean publicServer, boolean singlePlayer) {
        this.singlePlayer.setSelected(false);
        this.privateMultiplayer.setSelected(false);
        this.publicMultiplayer.setSelected(false);
        if (singlePlayer) {
            this.singlePlayer.setSelected(true);
        } else if (publicServer) {
            this.publicMultiplayer.setSelected(true);
        } else {
            this.privateMultiplayer.setSelected(true);
        }
        this.serverNameField.setText("");
    }
}

