/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class InfoPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int PANEL_WIDTH = 256;
    public static final int PANEL_HEIGHT = 128;
    private final Player player;
    private InfoPanelMode mode = InfoPanelMode.NONE;
    private final EndTurnPanel endTurnPanel;
    private final JPanel mapEditorPanel;
    private final TileInfoPanel tileInfoPanel;
    private final UnitInfoPanel unitInfoPanel;
    private final Image skin;

    public InfoPanel(FreeColClient freeColClient) {
        this(freeColClient, true);
    }

    public InfoPanel(FreeColClient freeColClient, boolean useSkin) {
        super(freeColClient);
        this.player = freeColClient.getMyPlayer();
        this.endTurnPanel = new EndTurnPanel(this.getGUI());
        this.mapEditorPanel = new JPanel(null);
        this.mapEditorPanel.setSize(130, 100);
        this.mapEditorPanel.setOpaque(false);
        this.tileInfoPanel = new TileInfoPanel();
        this.unitInfoPanel = new UnitInfoPanel();
        this.skin = useSkin ? ResourceManager.getImage("InfoPanel.skin") : null;
        this.setLayout(null);
        int internalPanelTop = 0;
        int internalPanelHeight = 128;
        if (this.skin != null) {
            this.setBorder(null);
            this.setSize(this.skin.getWidth(null), this.skin.getHeight(null));
            this.setOpaque(false);
            internalPanelTop = 75;
            internalPanelHeight = 128;
        } else {
            this.setSize(256, 128);
        }
        this.add(this.endTurnPanel, internalPanelTop, internalPanelHeight);
        this.add(this.mapEditorPanel, internalPanelTop, internalPanelHeight);
        this.add(this.tileInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.unitInfoPanel, internalPanelTop, internalPanelHeight);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Unit activeUnit = InfoPanel.this.getGUI().getActiveUnit();
                if (activeUnit != null && activeUnit.hasTile()) {
                    InfoPanel.this.getGUI().setFocus(activeUnit.getTile());
                }
            }
        });
    }

    private void add(JPanel panel, int internalTop, int internalHeight) {
        panel.setVisible(false);
        panel.setLocation((this.getWidth() - panel.getWidth()) / 2, internalTop + (internalHeight - panel.getHeight()) / 2);
        this.add(panel);
    }

    private InfoPanelMode getMode() {
        Player player;
        return this.getFreeColClient().isMapEditor() ? InfoPanelMode.MAP : (this.getGUI().getViewMode() == 1 ? InfoPanelMode.TILE : (this.unitInfoPanel.hasUnit() ? InfoPanelMode.UNIT : ((player = this.getFreeColClient().getMyPlayer()) != null && !player.hasNextActiveUnit() ? InfoPanelMode.END : InfoPanelMode.NONE)));
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        JPanel p;
        JPanel jPanel = p = mapTransform == null ? null : mapTransform.getDescriptionPanel();
        if (p != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.mapEditorPanel.getHeight() - d.height) / 2, this.mapEditorPanel.getWidth(), d.height);
            this.mapEditorPanel.removeAll();
            this.mapEditorPanel.add((Component)p, "Center");
            this.mapEditorPanel.validate();
            this.mapEditorPanel.revalidate();
        }
        this.update();
    }

    public void update(Tile tile) {
        if (this.tileInfoPanel.getTile() != tile) {
            this.tileInfoPanel.update(tile);
        }
        this.update();
    }

    public void update(Unit unit) {
        this.unitInfoPanel.update(unit);
        this.update();
    }

    public void update() {
        InfoPanelMode newMode = this.getMode();
        if (this.mode != newMode) {
            this.mode = newMode;
            switch (this.mode) {
                case END: {
                    this.endTurnPanel.setVisible(true);
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    break;
                }
                case MAP: {
                    this.mapEditorPanel.setVisible(true);
                    this.endTurnPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    break;
                }
                case TILE: {
                    this.tileInfoPanel.setVisible(true);
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    break;
                }
                case UNIT: {
                    this.unitInfoPanel.setVisible(true);
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    break;
                }
                default: {
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.skin != null) {
            graphics.drawImage(this.skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    private static enum InfoPanelMode {
        NONE,
        END,
        MAP,
        TILE,
        UNIT;

    }

    public class UnitInfoPanel
    extends JPanel
    implements PropertyChangeListener {
        private Unit unit;

        public UnitInfoPanel() {
            super(new MigLayout("wrap 6, fill, gap 0 0", "", ""));
            this.setSize(226, 100);
            this.setOpaque(false);
        }

        public boolean hasUnit() {
            return this.unit != null;
        }

        public void update(Unit unit) {
            if (this.unit != unit) {
                if (this.unit != null) {
                    this.unit.removePropertyChangeListener(this);
                }
                if (unit != null) {
                    unit.addPropertyChangeListener(this);
                }
                this.unit = unit;
                this.update();
            }
        }

        public void update() {
            this.removeAll();
            ImageLibrary lib = InfoPanel.this.getLibrary();
            if (this.unit != null) {
                this.add((Component)new JLabel(lib.getUnitImageIcon(this.unit)), "spany, gapafter 5px");
                String name = this.unit.getDescription(Unit.UnitLabelType.FULL);
                int index = name.indexOf(" (");
                if (index < 0) {
                    this.add((Component)new JLabel(name), "span");
                } else {
                    this.add((Component)new JLabel(name.substring(0, index)), "span");
                    this.add((Component)new JLabel(name.substring(index + 1)), "span");
                }
                String text = this.unit.isInEurope() ? Messages.getName(this.unit.getOwner().getEurope()) : Messages.message("moves") + " " + this.unit.getMovesAsString();
                this.add((Component)new JLabel(text), "span");
                if (this.unit.isCarrier()) {
                    JLabel label;
                    ImageIcon icon;
                    for (Goods goods : this.unit.getGoodsList()) {
                        icon = ImageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.66f);
                        label = new JLabel(icon);
                        text = Messages.message(goods.getLabel(true));
                        label.setToolTipText(text);
                        this.add(label);
                    }
                    for (Unit carriedUnit : this.unit.getUnitList()) {
                        icon = ImageLibrary.getUnitImageIcon(carriedUnit, 0.5);
                        label = new JLabel(icon);
                        text = carriedUnit.getDescription(Unit.UnitLabelType.NATIONAL);
                        label.setToolTipText(text);
                        this.add(label);
                    }
                }
            }
            this.revalidate();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.update();
        }
    }

    public class TileInfoPanel
    extends MigPanel {
        private Tile tile;
        private final Font font;

        public TileInfoPanel() {
            super(new MigLayout("fill, wrap 5, gap 2 2"));
            this.font = new JLabel().getFont().deriveFont(9.0f);
            this.setSize(226, 128);
            this.setOpaque(false);
        }

        public void update(Tile tile) {
            this.tile = tile;
            this.removeAll();
            if (tile != null) {
                Image terrain = InfoPanel.this.getLibrary().getTerrainImage(tile.getType(), tile.getX(), tile.getY());
                int width = terrain.getWidth(null);
                int height = terrain.getHeight(null);
                int compoundHeight = InfoPanel.this.getLibrary().getCompoundTerrainImageHeight(tile.getType());
                BufferedImage image = new BufferedImage(width, compoundHeight, 2);
                Graphics2D g = image.createGraphics();
                g.translate(0, compoundHeight - height);
                InfoPanel.this.getGUI().getMapViewer().displayTerrain(g, tile);
                if (tile.isExplored()) {
                    StringTemplate items = StringTemplate.label(", ");
                    items.add(tile.getNameKey());
                    for (TileImprovement tileImprovement : tile.getCompletedTileImprovements()) {
                        items.add(tileImprovement.getType().getDescriptionKey());
                    }
                    this.add((Component)GUI.localizedLabel(items), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                    if (tile.getOwner() != null) {
                        JLabel ownerLabel = GUI.localizedLabel(tile.getOwner().getNationName());
                        ownerLabel.setFont(this.font);
                        this.add((Component)ownerLabel, "span 4");
                    }
                    int defenceBonus = (int)tile.getType().applyModifiers(100.0f, InfoPanel.this.getGame().getTurn(), "model.modifier.defence") - 100;
                    JLabel defenceLabel = GUI.localizedLabel(StringTemplate.template("infoPanel.defenseBonus").addAmount("%bonus%", defenceBonus));
                    defenceLabel.setFont(this.font);
                    this.add((Component)defenceLabel, "span 4");
                    JLabel moveLabel = GUI.localizedLabel(StringTemplate.template("infoPanel.movementCost").addAmount("%cost%", tile.getType().getBasicMoveCost() / 3));
                    moveLabel.setFont(this.font);
                    this.add((Component)moveLabel, "span 4");
                    for (AbstractGoods goods : tile.getType().getPossibleProduction(true)) {
                        String string = String.valueOf(tile.getPotentialProduction(goods.getType(), null));
                        InfoPanel.this.getLibrary();
                        JLabel goodsLabel = new JLabel(string, ImageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.5), 4);
                        goodsLabel.setToolTipText(Messages.getName(goods.getType()));
                        goodsLabel.setFont(this.font);
                        this.add(goodsLabel);
                    }
                } else {
                    this.add((Component)GUI.localizedLabel("unexplored"), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                }
                this.revalidate();
            }
        }

        public Tile getTile() {
            return this.tile;
        }
    }

    public class EndTurnPanel
    extends MigPanel {
        public EndTurnPanel(GUI gui) {
            super(new MigLayout("wrap 1, center", "[center]", ""));
            String labelString = Messages.message("infoPanel.endTurnPanel.text");
            int width = this.getFontMetrics(this.getFont()).stringWidth(labelString);
            if (width > 150) {
                int index = Messages.getBreakingPoint(labelString);
                if (index > 0) {
                    this.add(new JLabel(labelString.substring(0, index)));
                    this.add(new JLabel(labelString.substring(index + 1)));
                } else {
                    this.add(new JLabel(labelString));
                }
            } else {
                this.add(new JLabel(labelString));
            }
            this.add(new JButton(InfoPanel.this.getFreeColClient().getActionManager().getFreeColAction("endTurnAction")));
            this.setOpaque(false);
            this.setSize(this.getPreferredSize());
        }
    }
}

