/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class IndianSettlementPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(IndianSettlementPanel.class.getName());

    public IndianSettlementPanel(FreeColClient freeColClient, IndianSettlement settlement) {
        super(freeColClient, new MigLayout("wrap 2, gapx 20", "", ""));
        String sale;
        JLabel settlementLabel = new JLabel(this.getGUI().getImageIcon(settlement, false));
        Player indian = settlement.getOwner();
        Player player = this.getMyPlayer();
        boolean contacted = settlement.hasContacted(player);
        boolean visited = settlement.hasVisited(player);
        String text = Messages.message(settlement.getLocationLabelFor(player)) + ", " + Messages.message(StringTemplate.template(settlement.isCapital() ? "indianCapital" : "indianSettlement").addStringTemplate("%nation%", indian.getNationName()));
        String messageId = settlement.getShortAlarmLevelMessageId(player);
        text = text + " (" + Messages.message(messageId);
        if (settlement.worthScouting(player)) {
            text = text + "," + Messages.message("indianSettlement.unscouted");
        }
        text = text + ")";
        settlementLabel.setText(text);
        this.add(settlementLabel);
        Unit missionary = settlement.getMissionary();
        if (missionary != null) {
            String missionaryName = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", missionary.getOwner().getNationName()).addStringTemplate("%unit%", missionary.getLabel(Unit.UnitLabelType.NATIONAL)));
            this.add(new JLabel(missionaryName, this.getGUI().getImageIcon(missionary, true), 0));
        }
        this.add((Component)GUI.localizedLabel("indianSettlement.learnableSkill"), "newline");
        UnitType skillType = settlement.getLearnableSkill();
        if (visited) {
            if (skillType == null) {
                this.add(GUI.localizedLabel("indianSettlement.skillNone"));
            } else {
                this.add(new JLabel(Messages.getName(skillType), this.getGUI().getImageIcon(skillType, true), 0));
            }
        } else {
            this.add(GUI.localizedLabel("indianSettlement.skillUnknown"));
        }
        this.add((Component)GUI.localizedLabel("indianSettlement.mostHated"), "newline");
        Player mostHated = settlement.getMostHated();
        if (contacted) {
            if (mostHated == null) {
                this.add(GUI.localizedLabel("indianSettlement.mostHatedNone"));
            } else {
                this.add(GUI.localizedLabel(mostHated.getNationName(), (Icon)this.getGUI().getImageIcon(mostHated, true), 0));
            }
        } else {
            this.add(GUI.localizedLabel("indianSettlement.mostHatedUnknown"));
        }
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        int n = 0;
        for (GoodsType wantedGood : wantedGoods) {
            if (wantedGood == null) continue;
            ++n;
        }
        this.add((Component)GUI.localizedLabel("indianSettlement.highlyWanted"), "newline");
        if (visited) {
            if (wantedGoods[0] == null) {
                this.add(GUI.localizedLabel("indianSettlement.wantedGoodsNone"));
            } else {
                sale = player.getLastSaleString(settlement, wantedGoods[0]);
                this.add(new JLabel(Messages.getName(wantedGoods[0]) + (sale == null ? "" : " " + sale), this.getGUI().getImageIcon(wantedGoods[0], false), 0));
                --n;
            }
        } else {
            this.add(GUI.localizedLabel("indianSettlement.wantedGoodsUnknown"));
        }
        this.add((Component)GUI.localizedLabel("indianSettlement.otherWanted"), "newline");
        if (visited) {
            if (n == 0) {
                this.add(GUI.localizedLabel("indianSettlement.wantedGoodsNone"));
            } else {
                sale = player.getLastSaleString(settlement, wantedGoods[1]);
                this.add((Component)new JLabel(Messages.getName(wantedGoods[1]) + (sale == null ? "" : " " + sale), this.getGUI().getImageIcon(wantedGoods[1], false), 0), "split " + Integer.toString(n));
                for (int i = 2; i < wantedGoods.length; ++i) {
                    if (wantedGoods[i] == null) continue;
                    sale = player.getLastSaleString(settlement, wantedGoods[i]);
                    this.add(new JLabel(Messages.getName(wantedGoods[i]) + (sale == null ? "" : " " + sale), this.getGUI().getImageIcon(wantedGoods[i], false), 0));
                }
            }
        } else {
            this.add(GUI.localizedLabel("indianSettlement.wantedGoodsUnknown"));
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
    }
}

