/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.resources.ResourceManager;

public class FatherDetailPanel
extends ColopediaGameObjectTypePanel<FoundingFather> {
    public FatherDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.FATHERS.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (Object fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put((FoundingFather.FoundingFatherType)((Object)fatherType), new ArrayList());
        }
        for (FoundingFather foundingFather : this.getSpecification().getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        for (Object fatherType : FoundingFather.FoundingFatherType.values()) {
            String id = FoundingFather.getTypeKey(fatherType);
            String typeName = Messages.message(id);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, typeName, null));
            parent.add(node);
            for (FoundingFather father : (List)fathersByType.get(fatherType)) {
                ImageIcon icon = new ImageIcon(ResourceManager.getImage("model.goods.bells.image", this.getScale()));
                node.add(this.buildItem(father, icon));
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        block3: {
            try {
                FoundingFather father = this.getSpecification().getFoundingFather(id);
                this.buildDetail(father, panel);
            }
            catch (IllegalArgumentException e) {
                panel.setLayout(new MigLayout("wrap 1, align center", "align center"));
                JLabel header = GUI.localizedLabel(Messages.nameKey(id));
                header.setFont(GUI.SMALL_HEADER_FONT);
                panel.add((Component)header, "align center, wrap 20");
                if (this.getId().equals(id)) {
                    panel.add(GUI.getDefaultTextArea(Messages.message("colopedia.foundingFather.description"), 40));
                }
                Image image = ResourceManager.getImage(id + ".image");
                if (image == null) break block3;
                header.setText(Messages.message(id));
                panel.add(new JLabel(new ImageIcon(image)));
            }
        }
    }

    public void buildDetail(FoundingFather father, JPanel panel) {
        panel.setLayout(new MigLayout("wrap 2, fillx, gapx 20", "", ""));
        String name = Messages.getName(father);
        String type = Messages.message(father.getTypeKey());
        JLabel header = new JLabel(name + " (" + type + ")");
        header.setFont(GUI.SMALL_HEADER_FONT);
        this.getLibrary();
        Image image = ImageLibrary.getFoundingFatherImage(father);
        JLabel label = new JLabel(new ImageIcon(image));
        StringBuilder text = new StringBuilder();
        text.append(Messages.getDescription(father));
        text.append("\n\n[");
        text.append(Messages.message(father.getId() + ".birthAndDeath"));
        text.append("] ");
        text.append(Messages.message(father.getId() + ".text"));
        Turn turn = this.getMyPlayer().getElectionTurns().get(name);
        if (turn != null) {
            text.append("\n\n");
            text.append(Messages.message("report.continentalCongress.elected"));
            text.append(" ");
            text.append(Messages.message(turn.getLabel()));
        }
        JTextArea description = GUI.getDefaultTextArea(text.toString(), 20);
        panel.add((Component)header, "span, align center, wrap 40");
        panel.add((Component)label, "top");
        panel.add((Component)description, "top, growx");
        Dimension hSize = header.getPreferredSize();
        Dimension lSize = label.getPreferredSize();
        Dimension dSize = description.getPreferredSize();
        Dimension size = new Dimension();
        size.setSize(lSize.getWidth() + dSize.getWidth() + 20.0, hSize.getHeight() + lSize.getHeight() + 10.0);
        panel.setPreferredSize(size);
    }
}

