/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColChoiceDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.UnitType;

public final class EmigrationDialog
extends FreeColChoiceDialog<Integer> {
    public EmigrationDialog(FreeColClient freeColClient, Europe europe, boolean foy) {
        super(freeColClient);
        ImageLibrary lib = freeColClient.getGUI().getImageLibrary();
        ArrayList<UnitType> recruitables = new ArrayList<UnitType>(europe.getRecruitables());
        String hdr = Messages.message("chooseImmigrant");
        JTextArea header = GUI.getDefaultTextArea(hdr);
        if (foy) {
            header.insert(Messages.message("lostCityRumour.fountainOfYouth") + "\n\n", 0);
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "[fill]", ""));
        panel.add((Component)header, "wrap 20");
        panel.setSize(panel.getPreferredSize());
        List c = EmigrationDialog.choices();
        int i = Europe.MigrationType.getDefaultSlot();
        UnitType u0 = (UnitType)recruitables.remove(0);
        int n = i++;
        c.add(new ChoiceItem<Integer>(Messages.getName(u0), n).defaultOption().setIcon(ImageLibrary.getUnitImageIcon(u0, 0.66)));
        for (UnitType ut : recruitables) {
            int n2 = i++;
            c.add(new ChoiceItem<Integer>(Messages.getName(ut), n2).setIcon(ImageLibrary.getUnitImageIcon(ut, 0.66)));
        }
        this.initializeChoiceDialog(false, panel, lib.getImageIcon(europe, true), null, c);
    }
}

