/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Unit;

public final class DragListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(DragListener.class.getName());
    private final FreeColPanel parentPanel;
    private final FreeColClient freeColClient;

    public DragListener(FreeColClient freeColClient, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.parentPanel = parentPanel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            if (!this.parentPanel.isEditable()) {
                logger.warning("Button3 disabled on non-editable panel: " + this.parentPanel);
            } else {
                int elements;
                QuickActionMenu menu = null;
                if (comp instanceof UnitLabel) {
                    menu = new QuickActionMenu(this.freeColClient, this.parentPanel);
                    menu.createUnitMenu((UnitLabel)comp);
                } else if (comp instanceof GoodsLabel) {
                    menu = new QuickActionMenu(this.freeColClient, this.parentPanel);
                    menu.createGoodsMenu((GoodsLabel)comp);
                } else if (comp instanceof MarketLabel && this.parentPanel instanceof EuropePanel) {
                    Europe europe = this.freeColClient.getMyPlayer().getEurope();
                    menu = new QuickActionMenu(this.freeColClient, this.parentPanel);
                    menu.createMarketMenu((MarketLabel)comp, europe);
                } else if (comp instanceof ColonyPanel.TilesPanel.ASingleTilePanel) {
                    menu = new QuickActionMenu(this.freeColClient, this.parentPanel);
                    menu.createTileMenu((ColonyPanel.TilesPanel.ASingleTilePanel)comp);
                } else if (comp.getParent() instanceof ColonyPanel.TilesPanel.ASingleTilePanel) {
                    menu = new QuickActionMenu(this.freeColClient, this.parentPanel);
                    menu.createTileMenu((ColonyPanel.TilesPanel.ASingleTilePanel)comp.getParent());
                }
                if (menu != null && (elements = menu.getSubElements().length) > 0) {
                    boolean small;
                    int lastIndex = menu.getComponentCount() - 1;
                    if (menu.getComponent(lastIndex) instanceof JPopupMenu.Separator) {
                        menu.remove(lastIndex);
                    }
                    GUI gui = this.freeColClient.getGUI();
                    boolean windows = System.getProperty("os.name").startsWith("Windows");
                    boolean bl = small = Toolkit.getDefaultToolkit().getScreenSize().getHeight() < 768.0;
                    if (gui.isWindowed() && windows) {
                        menu.show(gui.getCanvas(), menu.getLocation().x, 0);
                    } else if (!gui.isWindowed() && small) {
                        menu.show(gui.getCanvas(), menu.getLocation().x, 0);
                    } else {
                        menu.show(comp, e.getX(), e.getY());
                    }
                }
            }
        } else {
            Unit u;
            JLabel label;
            if (comp instanceof AbstractGoodsLabel) {
                label = (AbstractGoodsLabel)comp;
                if (e.isShiftDown()) {
                    ((AbstractGoodsLabel)label).setPartialChosen(true);
                } else {
                    ((AbstractGoodsLabel)label).setPartialChosen(false);
                    ((AbstractGoodsLabel)label).setDefaultAmount();
                }
            } else if (comp instanceof UnitLabel && (u = ((UnitLabel)(label = (UnitLabel)comp)).getUnit()).isCarrier() && !u.isAtSea() && this.parentPanel instanceof PortPanel) {
                ((PortPanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)label);
            }
            TransferHandler handler = comp.getTransferHandler();
            if (handler != null) {
                handler.exportAsDrag(comp, e, 1);
            }
        }
    }
}

