/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class CornerMapControls
extends MapControls {
    private static final Logger logger = Logger.getLogger(CornerMapControls.class.getName());
    private final JLabel compassRose = new JLabel(ResourceManager.getImageIcon("compass.image"));
    private final MiniMapPanel miniMapPanel;
    private final Image miniMapSkin;

    public CornerMapControls(final FreeColClient freeColClient) {
        super(freeColClient, true);
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Unit unit = freeColClient.getGUI().getActiveUnit();
                if (unit == null) {
                    return;
                }
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                freeColClient.getInGameController().moveUnit(unit, Map.Direction.angleToDirection(theta));
            }
        });
        this.miniMapSkin = ResourceManager.getImage("MiniMap.skin");
        this.miniMapPanel = new MiniMapPanel();
        this.miniMapPanel.setFocusable(false);
        this.miniMapPanel.setLayout(null);
        this.miniMap.setSize(220, 128);
        this.miniMapPanel.add(this.miniMapToggleBorders);
        this.miniMapPanel.add(this.miniMapToggleFogOfWarButton);
        this.miniMapPanel.add(this.miniMapZoomInButton);
        this.miniMapPanel.add(this.miniMapZoomOutButton);
        this.miniMapPanel.add(this.miniMap);
        if (this.miniMapSkin != null) {
            this.miniMapPanel.setBorder(null);
            this.miniMapPanel.setSize(this.miniMapSkin.getWidth(null), this.miniMapSkin.getHeight(null));
            this.miniMapPanel.setOpaque(false);
            this.miniMap.setLocation(38, 75);
            this.miniMapToggleBorders.setLocation(4, 114);
            this.miniMapToggleFogOfWarButton.setLocation(4, 144);
            this.miniMapZoomInButton.setLocation(4, 174);
            this.miniMapZoomOutButton.setLocation(264, 174);
        } else {
            int width = this.miniMapZoomOutButton.getWidth() + this.miniMapZoomInButton.getWidth() + 16;
            this.miniMapPanel.setOpaque(true);
            this.miniMap.setBorder(new BevelBorder(0));
            this.miniMap.setLocation(width / 2, 4);
            this.miniMapZoomInButton.setLocation(4, 132 - this.miniMapZoomInButton.getHeight());
            this.miniMapZoomOutButton.setLocation(this.miniMapZoomInButton.getWidth() + 220 + 12, 132 - this.miniMapZoomOutButton.getHeight());
        }
    }

    private void addToCanvas(Canvas canvas, Component component) {
        try {
            canvas.add(component, CONTROLS_LAYER);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Component add: " + component.getSize() + " at " + component.getLocation() + " in " + canvas.getSize(), e);
        }
    }

    @Override
    public void addToComponent(Canvas canvas) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        boolean rose = this.freeColClient.getClientOptions().getBoolean("model.option.displayCompassRose");
        int cw = canvas.getWidth();
        int ch = canvas.getHeight();
        this.infoPanel.setLocation(cw - this.infoPanel.getWidth(), ch - this.infoPanel.getHeight());
        this.miniMapPanel.setLocation(0, ch - this.miniMapPanel.getHeight());
        if (rose) {
            this.compassRose.setLocation(cw - this.compassRose.getWidth() - 20, 20);
        }
        if (!this.unitButtons.isEmpty()) {
            int SPACE = 5;
            int width = -5;
            int height = 0;
            for (UnitButton ub : this.unitButtons) {
                height = Math.max(height, ub.getHeight());
                width += 5 + ub.getWidth();
            }
            int x = this.miniMapPanel.getWidth() + 1 + (this.infoPanel.getX() - this.miniMapPanel.getWidth() - width) / 2;
            int y = ch - height - 5;
            for (UnitButton ub : this.unitButtons) {
                ub.setLocation(x, y);
                x += 5 + ub.getWidth();
            }
        }
        this.addToCanvas(canvas, this.infoPanel);
        this.addToCanvas(canvas, this.miniMapPanel);
        if (rose) {
            this.addToCanvas(canvas, this.compassRose);
        }
        if (!this.freeColClient.isMapEditor()) {
            for (UnitButton button : this.unitButtons) {
                this.addToCanvas(canvas, button);
                button.refreshAction();
            }
        }
    }

    @Override
    public boolean isShowing() {
        return this.infoPanel.getParent() != null;
    }

    @Override
    public void removeFromComponent(Canvas canvas) {
        canvas.removeFromCanvas(this.infoPanel);
        canvas.removeFromCanvas(this.miniMapPanel);
        canvas.removeFromCanvas(this.compassRose);
        for (UnitButton button : this.unitButtons) {
            canvas.removeFromCanvas(button);
        }
    }

    @Override
    public void repaint() {
        this.miniMapPanel.repaint();
    }

    public class MiniMapPanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics graphics) {
            if (CornerMapControls.this.miniMapSkin != null) {
                graphics.drawImage(CornerMapControls.this.miniMapSkin, 0, 0, null);
            }
            super.paintComponent(graphics);
        }
    }
}

