/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.RebelToolTip;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

public final class ColonyPanel
extends PortPanel
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    private static final int EXIT = 0;
    private static final int BUILDQUEUE = 1;
    private static final int UNLOAD = 2;
    private static final int WAREHOUSE = 4;
    private static final int FILL = 5;
    private static final int COLONY_UNITS = 6;
    private static final int SETGOODS = 7;
    private static final int OCCUPATION = 8;
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    private JButton unloadButton = GUI.localizedButton("unload");
    private JButton fillButton = GUI.localizedButton("fill");
    private JButton warehouseButton = GUI.localizedButton("colonyPanel.warehouse");
    private JButton buildQueueButton = GUI.localizedButton("colonyPanel.buildQueue");
    private JButton colonyUnitsButton = GUI.localizedButton("colonyPanel.colonyUnits");
    private JButton setGoodsButton = null;
    private JButton traceWorkButton = null;
    private Colony colony = null;
    private MouseListener releaseListener = null;
    private final JComboBox<Colony> nameBox = new JComboBox();
    private JPanel netProductionPanel = null;
    private JScrollPane buildingsScroll = null;
    private BuildingsPanel buildingsPanel = null;
    private JScrollPane cargoScroll = null;
    private ConstructionPanel constructionPanel = null;
    private JScrollPane inPortScroll = null;
    private JScrollPane outsideColonyScroll = null;
    private OutsideColonyPanel outsideColonyPanel = null;
    private PopulationPanel populationPanel = null;
    private JScrollPane tilesScroll = null;
    private TilesPanel tilesPanel = null;
    private JScrollPane warehouseScroll = null;
    private WarehousePanel warehousePanel = null;

    public ColonyPanel(FreeColClient freeColClient, Colony colony) {
        super(freeColClient, new MigLayout("fill, wrap 2, insets 2", "[390!][fill]", "[][]0[]0[][growprio 200,shrinkprio 10][growprio 150,shrinkprio 50]"));
        this.editable = colony.getOwner().getId().equals(this.getMyPlayer().getId());
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && this.editable) {
            this.setGoodsButton = GUI.localizedButton("colonyPanel.setGoods");
            this.traceWorkButton = GUI.localizedButton("colonyPanel.traceWork");
        }
        ComponentInputMap closeIM = new ComponentInputMap(this.okButton);
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, closeIM);
        this.okButton.setText(Messages.message("close"));
        ComponentInputMap unloadIM = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadIM);
        this.unloadButton.setActionCommand(String.valueOf(2));
        ComponentInputMap fillIM = new ComponentInputMap(this.fillButton);
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillIM);
        this.fillButton.setActionCommand(String.valueOf(5));
        ComponentInputMap warehouseIM = new ComponentInputMap(this.warehouseButton);
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, false), "pressed");
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.warehouseButton, 2, warehouseIM);
        this.warehouseButton.setActionCommand(String.valueOf(4));
        ComponentInputMap buildQueueIM = new ComponentInputMap(this.buildQueueButton);
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, false), "pressed");
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.buildQueueButton, 2, buildQueueIM);
        this.buildQueueButton.setActionCommand(String.valueOf(1));
        ComponentInputMap colonyUnitsIM = new ComponentInputMap(this.colonyUnitsButton);
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, false), "pressed");
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.colonyUnitsButton, 2, colonyUnitsIM);
        this.colonyUnitsButton.setActionCommand(String.valueOf(6));
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setActionCommand(String.valueOf(7));
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.setActionCommand(String.valueOf(8));
        }
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this);
        this.pressListener = new DragListener(freeColClient, this);
        this.releaseListener = new DropListener();
        this.selectedUnitLabel = null;
        this.nameBox.setFont(GUI.SMALL_HEADER_FONT);
        if (this.editable) {
            for (Colony c : freeColClient.getMySortedColonies()) {
                this.nameBox.addItem(c);
            }
        } else {
            this.nameBox.addItem(colony);
        }
        this.nameBox.setSelectedItem(colony);
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        this.netProductionPanel = new JPanel();
        this.netProductionPanel.setOpaque(false);
        this.buildingsPanel = new BuildingsPanel();
        this.buildingsScroll = new JScrollPane(this.buildingsPanel, 20, 30);
        this.buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.buildingsScroll.getViewport().setOpaque(false);
        this.buildingsPanel.setOpaque(false);
        this.buildingsScroll.setBorder(GUI.ETCHED_BORDER);
        this.cargoPanel = new ColonyCargoPanel(freeColClient);
        this.cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        this.cargoScroll.setBorder(GUI.ETCHED_BORDER);
        this.constructionPanel = new ConstructionPanel(freeColClient, colony, true);
        this.inPortPanel = new ColonyInPortPanel();
        this.inPortPanel.setBorder(GUI.localizedBorder("inPort"));
        this.inPortScroll = new JScrollPane(this.inPortPanel);
        this.inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.inPortScroll.setBorder(GUI.ETCHED_BORDER);
        this.outsideColonyPanel = new OutsideColonyPanel();
        this.outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 20, 31);
        this.outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.outsideColonyScroll.setBorder(GUI.ETCHED_BORDER);
        this.populationPanel = new PopulationPanel();
        this.tilesPanel = new TilesPanel();
        this.tilesScroll = new JScrollPane(this.tilesPanel, 20, 30);
        this.tilesScroll.setBorder(GUI.BEVEL_BORDER);
        this.warehousePanel = new WarehousePanel();
        this.warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        this.warehouseScroll.setBorder(GUI.ETCHED_BORDER);
        ComponentInputMap nameIM = new ComponentInputMap(this.nameBox);
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        SwingUtilities.replaceUIInputMap(this.nameBox, 2, nameIM);
        this.initialize(colony);
        this.getGUI().restoreSavedSize(this, 850, 600);
    }

    private synchronized void setColony(Colony colony) {
        this.colony = colony;
    }

    private void initialize(Colony colony) {
        this.cleanup();
        this.setColony(colony);
        this.addPropertyChangeListeners();
        this.addMouseListeners();
        this.setTransferHandlers(this.isEditable());
        this.unloadButton.addActionListener(this);
        this.fillButton.addActionListener(this);
        this.warehouseButton.addActionListener(this);
        this.buildQueueButton.addActionListener(this);
        this.colonyUnitsButton.addActionListener(this);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.addActionListener(this);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.addActionListener(this);
        }
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.buildQueueButton.setEnabled(this.isEditable());
        this.colonyUnitsButton.setEnabled(this.isEditable());
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setEnabled(this.isEditable());
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.setEnabled(this.isEditable());
        }
        final GUI gui = this.getGUI();
        this.nameBox.setEnabled(this.isEditable());
        this.nameBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Colony newColony = (Colony)ColonyPanel.this.nameBox.getSelectedItem();
                ColonyPanel.this.closeColonyPanel();
                gui.showColonyPanel(newColony, null);
            }
        });
        this.updateNetProductionPanel();
        this.buildingsPanel.initialize();
        this.cargoPanel.initialize();
        this.constructionPanel.initialize();
        this.inPortPanel.initialize();
        this.outsideColonyPanel.initialize();
        this.populationPanel.initialize();
        this.tilesPanel.initialize();
        this.warehousePanel.initialize();
        this.add(this.nameBox, "height 48:, grow");
        this.add((Component)this.netProductionPanel, "growx");
        this.add((Component)this.tilesScroll, "width 390!, height 200!, top");
        this.add((Component)this.buildingsScroll, "span 1 3, grow");
        this.add((Component)this.populationPanel, "grow");
        this.add((Component)this.constructionPanel, "grow, top");
        this.add((Component)this.inPortScroll, "span, split 3, grow, sg, height 60:121:");
        this.add((Component)this.cargoScroll, "grow, sg, height 60:121:");
        this.add((Component)this.outsideColonyScroll, "grow, sg, height 60:121:");
        this.add((Component)this.warehouseScroll, "span, height 40:60:, growx");
        int buttonFields = 6;
        if (this.setGoodsButton != null) {
            ++buttonFields;
        }
        if (this.traceWorkButton != null) {
            ++buttonFields;
        }
        this.add((Component)this.unloadButton, "span, split " + Integer.toString(buttonFields) + ", align center");
        this.add(this.fillButton);
        this.add(this.warehouseButton);
        this.add(this.buildQueueButton);
        this.add(this.colonyUnitsButton);
        if (this.setGoodsButton != null) {
            this.add(this.setGoodsButton);
        }
        if (this.traceWorkButton != null) {
            this.add(this.traceWorkButton);
        }
        this.add((Component)this.okButton, "tag ok");
        this.update();
    }

    private void cleanup() {
        this.unloadButton.removeActionListener(this);
        this.fillButton.removeActionListener(this);
        this.warehouseButton.removeActionListener(this);
        this.buildQueueButton.removeActionListener(this);
        this.colonyUnitsButton.removeActionListener(this);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.removeActionListener(this);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.removeActionListener(this);
        }
        this.removePropertyChangeListeners();
        if (this.getSelectedUnit() != null) {
            this.getSelectedUnit().removePropertyChangeListener(this);
        }
        this.removeMouseListeners();
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        this.setTransferHandlers(false);
        this.buildingsPanel.cleanup();
        this.cargoPanel.cleanup();
        this.constructionPanel.cleanup();
        this.inPortPanel.cleanup();
        this.outsideColonyPanel.cleanup();
        this.populationPanel.cleanup();
        this.tilesPanel.cleanup();
        this.warehousePanel.cleanup();
        this.removeAll();
    }

    private void addMouseListeners() {
        if (this.isEditable()) {
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        }
    }

    private void removeMouseListeners() {
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
    }

    private void setTransferHandlers(boolean enable) {
        DefaultTransferHandler dth = enable ? this.defaultTransferHandler : null;
        this.cargoPanel.setTransferHandler(dth);
        this.inPortPanel.setTransferHandler(dth);
        this.outsideColonyPanel.setTransferHandler(dth);
        this.warehousePanel.setTransferHandler(dth);
    }

    private void addPropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.addPropertyChangeListener(this);
            colony.getGoodsContainer().addPropertyChangeListener(this);
            colony.getTile().addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.removePropertyChangeListener(this);
            colony.getGoodsContainer().removePropertyChangeListener(this);
            colony.getTile().removePropertyChangeListener(this);
        }
    }

    private void updateProduction() {
        Colony colony = this.getColony();
        if (colony == null) {
            return;
        }
        for (WorkLocation wl : colony.getCurrentWorkLocations()) {
            boolean change = false;
            boolean check = wl.getProductionType() == null;
            for (Unit u : wl.getUnitList()) {
                if (!check && wl.produces(u.getWorkType())) continue;
                GoodsType workType = colony.getWorkTypeFor(u, wl);
                if (workType != null && workType != u.getWorkType()) {
                    this.igc().changeWorkType(u, workType);
                }
                change = true;
            }
            if (!change) continue;
            wl.updateProductionType();
        }
        this.updateTilesPanel();
        this.updateBuildingsPanel();
        this.updateNetProductionPanel();
        this.updateConstructionPanel();
    }

    public void update() {
        this.buildingsPanel.update();
        this.constructionPanel.update();
        this.inPortPanel.update();
        this.updateNetProductionPanel();
        this.outsideColonyPanel.update();
        this.populationPanel.update();
        this.tilesPanel.update();
        this.warehousePanel.update();
    }

    private void updateCarrierButtons() {
        Unit unit;
        Colony colony = this.getColony();
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (this.isEditable() && this.selectedUnitLabel != null && (unit = this.selectedUnitLabel.getUnit()) != null && unit.isCarrier() && unit.hasCargo()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getCompactGoodsList()) {
                if (colony.getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                break;
            }
        }
    }

    private void generateColonyUnitsMenu() {
        int lastIndex;
        int elements;
        final FreeColClient freeColClient = this.getFreeColClient();
        Colony colony = this.getColony();
        JPopupMenu colonyUnitsMenu = new JPopupMenu(Messages.message("colonyPanel.colonyUnits"));
        ImageIcon unitIcon = null;
        final QuickActionMenu unitMenu = new QuickActionMenu(freeColClient, this);
        Tile colonyTile = colony.getTile();
        int unitNumber = 0;
        JMenuItem subMenu = null;
        for (final Unit unit : colony.getUnitList()) {
            String nominative;
            Building workingInBuilding = unit.getWorkBuilding();
            ColonyTile workingOnLand = unit.getWorkTile();
            GoodsType goodsType = unit.getWorkType();
            Unit student = unit.getStudent();
            this.getLibrary();
            unitIcon = ImageLibrary.getUnitImageIcon(unit, 0.5);
            StringBuilder sb = new StringBuilder(64);
            if (student != null) {
                sb.append(unit.getDescription()).append(" ").append(Messages.message("producing.name")).append(" ").append(Messages.message(unit.getType().getSkillTaught().getNameKey())).append(" ").append(unit.getTurnsOfTraining()).append("/").append(unit.getNeededTurnsOfTraining());
            } else if (workingOnLand != null && goodsType != null) {
                int producing = workingOnLand.getProductionOf(unit, goodsType);
                nominative = Messages.message(StringTemplate.template(goodsType.getNameKey()).addAmount("%amount%", producing));
                sb.append(unit.getDescription()).append(" ").append(Messages.message("producing.name")).append(" ").append(producing).append(" ").append(nominative);
            } else if (workingInBuilding != null && goodsType != null) {
                int producing = workingInBuilding.getProductionOf(unit, goodsType);
                nominative = Messages.message(StringTemplate.template(goodsType.getNameKey()).addAmount("%amount%", producing));
                sb.append(unit.getDescription()).append(" ").append(Messages.message("producing.name")).append(" ").append(producing).append(" ").append(nominative);
            } else {
                sb.append(unit.getDescription()).append(" ").append(Messages.message("producing.name")).append(" ").append(Messages.message("nothing"));
            }
            String menuTitle = sb.toString();
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    unitMenu.createUnitMenu(new UnitLabel(freeColClient, unit));
                    unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                }
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        for (final Unit unit : colonyTile.getUnitList()) {
            String menuTitle;
            if (unit.isCarrier()) {
                this.getLibrary();
                unitIcon = ImageLibrary.getUnitImageIcon(unit, 0.5);
                menuTitle = unit.getDescription() + " " + Messages.message("inPort.name");
                subMenu = new JMenuItem(menuTitle, unitIcon);
                subMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        unitMenu.createUnitMenu(new UnitLabel(freeColClient, unit));
                        unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                    }
                });
                ++unitNumber;
                colonyUnitsMenu.add(subMenu);
                if (unit.getUnitList() == null) continue;
                for (final Unit innerUnit : unit.getUnitList()) {
                    this.getLibrary();
                    unitIcon = ImageLibrary.getUnitImageIcon(innerUnit, 0.5);
                    menuTitle = innerUnit.getDescription() + " " + Messages.message("cargoOnCarrier") + " " + unit.getDescription();
                    subMenu = new JMenuItem(menuTitle, unitIcon);
                    subMenu.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            unitMenu.createUnitMenu(new UnitLabel(freeColClient, innerUnit));
                            unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                        }
                    });
                    ++unitNumber;
                    colonyUnitsMenu.add(subMenu);
                }
                continue;
            }
            if (unit.isOnCarrier()) continue;
            this.getLibrary();
            unitIcon = ImageLibrary.getUnitImageIcon(unit, 0.5);
            menuTitle = unit.getDescription() + " " + Messages.message("outsideOfColony.name");
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    unitMenu.createUnitMenu(new UnitLabel(freeColClient, unit));
                    unitMenu.show(ColonyPanel.this.getGUI().getCanvas(), 0, 0);
                }
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        if (colonyUnitsMenu != null && (elements = colonyUnitsMenu.getSubElements().length) > 0 && colonyUnitsMenu.getComponent(lastIndex = colonyUnitsMenu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            colonyUnitsMenu.remove(lastIndex);
        }
        colonyUnitsMenu.show(this.getGUI().getCanvas(), 0, 0);
    }

    private boolean tryWork(Unit unit, WorkLocation wl) {
        GoodsType workType = this.colony.getWorkTypeFor(unit, wl);
        this.igc().work(unit, wl);
        if (unit.getLocation() != wl) {
            return false;
        }
        if (workType != null && workType != unit.getWorkType()) {
            this.igc().changeWorkType(unit, workType);
        }
        return true;
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    public final TilesPanel getTilesPanel() {
        return this.tilesPanel;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            this.inPortPanel.removePropertyChangeListeners();
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
                this.selectedUnitLabel.getUnit().removePropertyChangeListener(this);
            }
            super.setSelectedUnitLabel(unitLabel);
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
                unitLabel.getUnit().addPropertyChangeListener(this);
            }
            this.inPortPanel.addPropertyChangeListeners();
        }
        this.updateCarrierButtons();
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    @Override
    public boolean setSelectedUnit(Unit unit) {
        return unit.isCarrier() ? this.inPortPanel.setSelectedUnit(unit) : super.setSelectedUnit(unit);
    }

    public void updateBuildingsPanel() {
        this.buildingsPanel.update();
    }

    public void updateConstructionPanel() {
        this.constructionPanel.update();
    }

    public void updateInPortPanel() {
        this.inPortPanel.update();
    }

    public void updateNetProductionPanel() {
        Colony colony = this.getColony();
        Specification spec = colony.getSpecification();
        colony.invalidateCache();
        this.netProductionPanel.removeAll();
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            int amount = colony.getAdjustedNetProductionOf(goodsType);
            if (amount == 0) continue;
            this.netProductionPanel.add(new ProductionLabel(this.getFreeColClient(), goodsType, amount));
        }
        this.netProductionPanel.revalidate();
    }

    public void updateOutsideColonyPanel() {
        this.outsideColonyPanel.update();
    }

    public void updatePopulationPanel() {
        this.populationPanel.update();
    }

    public void updateTilesPanel() {
        this.tilesPanel.update();
    }

    public void updateWarehousePanel() {
        this.warehousePanel.update();
    }

    public void closeColonyPanel() {
        BuildableType buildable;
        Colony colony = this.getColony();
        boolean abandon = false;
        if (colony.getUnitCount() == 0 && this.getMyPlayer().owns(colony)) {
            if (!this.getGUI().confirm(true, null, StringTemplate.key("abandonColony.text"), this, "abandonColony.yes", "abandonColony.no")) {
                return;
            }
            abandon = true;
        }
        if (!abandon && (buildable = colony.getCurrentlyBuilding()) != null && buildable.getRequiredPopulation() > colony.getUnitCount() && !this.getGUI().confirm(true, null, StringTemplate.template("colonyPanel.reducePopulation").addName("%colony%", colony.getName()).addAmount("%number%", buildable.getRequiredPopulation()).add("%buildable%", buildable.getNameKey()), this, "ok", "cancel")) {
            return;
        }
        this.cleanup();
        this.getGUI().removeFromCanvas(this);
        this.getGUI().getMapViewer().restartBlinking();
        this.getGUI().updateMapControls();
        if (abandon) {
            this.igc().abandonColony(colony);
        }
        if (this.getFreeColClient().currentPlayerIsMyPlayer()) {
            this.igc().nextModelMessage();
            Unit activeUnit = this.getGUI().getActiveUnit();
            if (activeUnit == null || !activeUnit.hasTile() || !(activeUnit.getLocation() instanceof Tile) && !activeUnit.isOnCarrier()) {
                this.igc().nextActiveUnit();
            }
        }
    }

    @Override
    public List<Unit> getUnitList() {
        return FreeColObject.getSortedCopy(this.colony.getTile().getUnitList());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Colony colony = this.getColony();
        String command = event.getActionCommand();
        Unit unit = this.getSelectedUnit();
        if ("OK".equals(command)) {
            this.closeColonyPanel();
        } else {
            int cmd;
            try {
                cmd = Integer.parseInt(command);
            }
            catch (NumberFormatException nfe) {
                logger.warning("Invalid action number: " + command);
                return;
            }
            switch (cmd) {
                case 2: {
                    if (unit == null || !unit.isCarrier()) break;
                    for (Goods goods : unit.getGoodsContainer().getGoods()) {
                        this.igc().unloadCargo(goods, false);
                    }
                    for (Unit u : unit.getUnitList()) {
                        this.igc().leaveShip(u);
                    }
                    this.cargoPanel.update();
                    this.updateOutsideColonyPanel();
                    this.unloadButton.setEnabled(false);
                    this.fillButton.setEnabled(false);
                    break;
                }
                case 4: {
                    if (!this.getGUI().showWarehouseDialog(colony)) break;
                    this.updateWarehousePanel();
                    break;
                }
                case 1: {
                    this.getGUI().showBuildQueuePanel(colony);
                    this.updateConstructionPanel();
                    break;
                }
                case 5: {
                    if (unit == null || !unit.isCarrier()) break;
                    for (Goods goods : unit.getGoodsContainer().getGoods()) {
                        int space = 100 - goods.getAmount();
                        int count = colony.getGoodsCount(goods.getType());
                        if (space <= 0 || count <= 0) continue;
                        Goods newGoods = new Goods(goods.getGame(), colony, goods.getType(), Math.min(space, count));
                        this.igc().loadCargo(newGoods, unit);
                    }
                    break;
                }
                case 6: {
                    this.generateColonyUnitsMenu();
                    break;
                }
                case 7: {
                    DebugUtils.setColonyGoods(this.getFreeColClient(), colony);
                    this.updateWarehousePanel();
                    this.updateProduction();
                    break;
                }
                case 8: {
                    colony.setOccupationTrace(!colony.getOccupationTrace());
                    break;
                }
                default: {
                    super.actionPerformed(event);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Colony colony = this.getColony();
        if (!this.isShowing() || colony == null) {
            return;
        }
        String property = event.getPropertyName();
        logger.finest(colony.getName() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        if (property == null) {
            logger.warning("Null property change");
        } else if ("CARGO_CHANGE".equals(property)) {
            this.cargoPanel.update();
            this.updateInPortPanel();
        } else if (Colony.ColonyChangeEvent.POPULATION_CHANGE.toString().equals(property)) {
            this.updatePopulationPanel();
            this.updateNetProductionPanel();
        } else if (Colony.ColonyChangeEvent.BONUS_CHANGE.toString().equals(property)) {
            ModelMessage msg;
            if (colony.getUnitCount() > 0 && (msg = colony.checkForGovMgtChangeMessage()) != null) {
                this.getGUI().showInformationMessage((FreeColObject)colony, msg);
            }
            this.updatePopulationPanel();
        } else if (Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString().equals(property)) {
            this.updateProduction();
        } else if (Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString().equals(property)) {
            FreeColGameObject object = (FreeColGameObject)event.getSource();
            UnitType oldType = (UnitType)event.getOldValue();
            UnitType newType = (UnitType)event.getNewValue();
            this.getGUI().showInformationMessage((FreeColObject)object, StringTemplate.template("model.colony.unitChange").addName("%colony%", colony.getName()).add("%oldType%", oldType.getNameKey()).add("%newType%", newType.getNameKey()));
            this.updateTilesPanel();
        } else if (property.startsWith("model.goods.")) {
            this.updateWarehousePanel();
            this.updateProduction();
        } else if ("TILE_UNIT_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
            this.updateInPortPanel();
            this.updatePopulationPanel();
            this.updateWarehousePanel();
        } else {
            logger.warning("Unknown property change event: " + event.getPropertyName());
        }
    }

    @Override
    public void removeNotify() {
        if (this.colony == null) {
            return;
        }
        this.colony.setOccupationTrace(false);
        this.colony = null;
        super.removeNotify();
        this.unloadButton = null;
        this.fillButton = null;
        this.warehouseButton = null;
        this.buildQueueButton = null;
        this.colonyUnitsButton = null;
        this.setGoodsButton = null;
        this.traceWorkButton = null;
        this.netProductionPanel = null;
        this.buildingsPanel = null;
        this.buildingsScroll = null;
        this.cargoScroll = null;
        this.constructionPanel = null;
        this.inPortScroll = null;
        this.outsideColonyPanel = null;
        this.outsideColonyScroll = null;
        this.populationPanel = null;
        this.tilesPanel = null;
        this.tilesScroll = null;
        this.warehousePanel = null;
        this.warehouseScroll = null;
        this.releaseListener = null;
    }

    public final class TilesPanel
    extends JPanel {
        private final Tile[][] tiles = new Tile[3][3];

        public TilesPanel() {
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            Tile tile = colony.getTile();
            this.tiles[0][0] = tile.getNeighbourOrNull(Map.Direction.N);
            this.tiles[0][1] = tile.getNeighbourOrNull(Map.Direction.NE);
            this.tiles[0][2] = tile.getNeighbourOrNull(Map.Direction.E);
            this.tiles[1][0] = tile.getNeighbourOrNull(Map.Direction.NW);
            this.tiles[1][1] = tile;
            this.tiles[1][2] = tile.getNeighbourOrNull(Map.Direction.SE);
            this.tiles[2][0] = tile.getNeighbourOrNull(Map.Direction.W);
            this.tiles[2][1] = tile.getNeighbourOrNull(Map.Direction.SW);
            this.tiles[2][2] = tile.getNeighbourOrNull(Map.Direction.S);
            int layer = 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (this.tiles[x][y] == null) continue;
                    ColonyTile colonyTile = colony.getColonyTile(this.tiles[x][y]);
                    ASingleTilePanel aSTP = new ASingleTilePanel(colonyTile, x, y);
                    aSTP.initialize();
                    this.add((Component)aSTP, (Object)layer++);
                }
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).update();
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Colony colony = ColonyPanel.this.getColony();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (colony == null) {
                return;
            }
            Tile tile = colony.getTile();
            TileType tileType = tile.getType();
            Image image = ColonyPanel.this.getLibrary().getTerrainImage(tileType, tile.getX(), tile.getY());
            int tileWidth = image.getWidth(null) / 2;
            int tileHeight = image.getHeight(null) / 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (this.tiles[x][y] == null) continue;
                    int xx = (2 - x + y) * tileWidth;
                    int yy = (x + y) * tileHeight;
                    g.translate(xx, yy);
                    ColonyPanel.this.getGUI().displayColonyTile((Graphics2D)g, this.tiles[x][y], colony);
                    g.translate(-xx, -yy);
                }
            }
        }

        public final class ASingleTilePanel
        extends JPanel
        implements DropTarget,
        PropertyChangeListener {
            private final ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.colonyTile = colonyTile;
                this.setLayout(new FlowLayout(1, 0, 0));
                this.setOpaque(false);
                Tile tile = colonyTile.getTile();
                TileType tileType = tile.getType();
                Image image = ColonyPanel.this.getLibrary().getTerrainImage(tileType, tile.getX(), tile.getY());
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                this.setSize(width, height);
                this.setLocation((2 - x + y) * width / 2, (x + y) * height / 2);
            }

            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    this.cleanup();
                    this.addMouseListener(ColonyPanel.this.pressListener);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addPropertyChangeListeners();
                }
            }

            public void cleanup() {
                this.removeMouseListener(ColonyPanel.this.pressListener);
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.setTransferHandler(null);
                this.removePropertyChangeListeners();
                this.removeAll();
            }

            protected void addPropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.addPropertyChangeListener(this);
                }
            }

            protected void removePropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.removePropertyChangeListener(this);
                }
            }

            public void update() {
                this.removeAll();
                UnitLabel label = null;
                for (Unit unit : this.colonyTile.getUnitList()) {
                    label = new UnitLabel(ColonyPanel.this.getFreeColClient(), unit);
                    if (ColonyPanel.this.isEditable()) {
                        label.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        label.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    super.add(label);
                }
                this.updateDescriptionLabel(label, true);
                if (this.colonyTile.isColonyCenterTile()) {
                    this.setLayout(new GridLayout(2, 1));
                    ProductionInfo info = ColonyPanel.this.colony.getProductionInfo(this.colonyTile);
                    if (info != null) {
                        for (AbstractGoods ag : info.getProduction()) {
                            ProductionLabel productionLabel = new ProductionLabel(ColonyPanel.this.getFreeColClient(), ag);
                            productionLabel.addMouseListener(ColonyPanel.this.pressListener);
                            this.add(productionLabel);
                        }
                    }
                }
            }

            public ColonyTile getColonyTile() {
                return this.colonyTile;
            }

            private void updateDescriptionLabel(UnitLabel unitLabel, boolean toAdd) {
                String tileMsg = Messages.message(this.colonyTile.getLabel());
                if (unitLabel == null) {
                    this.setToolTipText(tileMsg);
                } else {
                    String unitMsg = unitLabel.getUnit().getDescription(Unit.UnitLabelType.NATIONAL);
                    if (toAdd) {
                        unitMsg = tileMsg + " [" + unitMsg + "]";
                    }
                    unitLabel.setDescriptionLabel(unitMsg);
                }
            }

            private boolean tryWork(Unit unit) {
                WorkLocation best;
                UnitLocation.NoAddReason reason;
                Colony colony = ColonyPanel.this.getColony();
                Tile tile = this.colonyTile.getWorkTile();
                Player player = unit.getOwner();
                if (tile.getOwningSettlement() != colony) {
                    Player.NoClaimReason claim = player.canClaimForSettlementReason(tile);
                    switch (claim) {
                        case NONE: 
                        case NATIVES: {
                            if (ColonyPanel.this.igc().claimTile(tile, colony) && tile.getOwningSettlement() == colony) {
                                logger.info("Colony " + colony.getName() + " claims tile " + tile + " with unit " + unit.getId());
                                break;
                            }
                            logger.warning("Colony " + colony.getName() + " did not claim " + tile + " with unit " + unit.getId());
                            return false;
                        }
                        default: {
                            ColonyPanel.this.getGUI().showInformationMessage((FreeColObject)tile, "noClaimReason." + claim.toString().toLowerCase(Locale.US));
                            return false;
                        }
                    }
                    if (tile.getOwningSettlement() != colony) {
                        throw new IllegalStateException("Claim failed");
                    }
                }
                if ((reason = this.colonyTile.getNoAddReason(unit)) != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationMessage((FreeColObject)this.colonyTile, "noAddReason." + reason.toString().toLowerCase(Locale.US));
                    return false;
                }
                if (!ColonyPanel.this.tryWork(unit, this.colonyTile)) {
                    return false;
                }
                GoodsType workType = unit.getWorkType();
                if (workType != null && ColonyPanel.this.getClientOptions().getBoolean("model.option.guiShowNotBestTile") && (best = colony.getWorkLocationFor(unit, workType)) != null && this.colonyTile != best && this.colonyTile.getPotentialProduction(workType, unit.getType()) < best.getPotentialProduction(workType, unit.getType())) {
                    StringTemplate template = StringTemplate.template("colonyPanel.notBestTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).add("%goods%", workType.getNameKey()).addStringTemplate("%tile%", best.getLabel());
                    ColonyPanel.this.getGUI().showInformationMessage((FreeColObject)best, template);
                }
                return true;
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public boolean accepts(Goods goods) {
                return false;
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        UnitLabel label = (UnitLabel)comp;
                        if (!this.tryWork(label.getUnit())) {
                            return null;
                        }
                        label.setSmall(false);
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleTilePanel.");
                        return null;
                    }
                }
                this.update();
                return comp;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                logger.finest(this.colonyTile.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
                ColonyPanel.this.updateProduction();
            }

            @Override
            public boolean contains(int px, int py) {
                int dy;
                int w = this.getWidth();
                int h = this.getHeight();
                int dx = Math.abs(w / 2 - px);
                return dx + w * (dy = Math.abs(h / 2 - py)) / h <= w / 2;
            }
        }
    }

    public final class BuildingsPanel
    extends JPanel {
        public BuildingsPanel() {
            this.setLayout(new MigLayout("fill, wrap 4, insets 0, gap 0:10:10:push"));
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            List<Building> buildings = colony.getBuildings();
            Collections.sort(buildings);
            for (Building building : buildings) {
                ASingleBuildingPanel aSBP = new ASingleBuildingPanel(building);
                aSBP.initialize();
                this.add(aSBP);
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).update();
            }
            this.repaint();
        }

        @Override
        public String getUIClassID() {
            return "BuildingsPanelUI";
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }

        public final class ASingleBuildingPanel
        extends BuildingPanel
        implements DropTarget {
            private final MouseAdapter buildQueueListener;

            public ASingleBuildingPanel(Building building) {
                super(ColonyPanel.this.getFreeColClient(), building);
                this.buildQueueListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ColonyPanel.this.getGUI().showBuildQueuePanel(ColonyPanel.this.getColony());
                    }
                };
                this.setOpaque(false);
            }

            @Override
            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    super.initialize();
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    this.addMouseListener(this.buildQueueListener);
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
            }

            @Override
            public void cleanup() {
                super.cleanup();
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.removeMouseListener(this.buildQueueListener);
                this.setTransferHandler(null);
                this.removeAll();
            }

            @Override
            public void update() {
                super.update();
                if (ColonyPanel.this.isEditable()) {
                    for (UnitLabel unitLabel : this.getUnitLabels()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                }
            }

            private boolean tryWork(Unit unit) {
                Building building = this.getBuilding();
                UnitLocation.NoAddReason reason = building.getNoAddReason(unit);
                if (reason != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationMessage((FreeColObject)building, "noAddReason." + reason.toString().toLowerCase(Locale.US));
                    return false;
                }
                return ColonyPanel.this.tryWork(unit, building);
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public boolean accepts(Goods goods) {
                return false;
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        if (!this.tryWork(((UnitLabel)comp).getUnit())) {
                            return null;
                        }
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleBuildingPanel.");
                        return null;
                    }
                    this.update();
                }
                return null;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                super.propertyChange(event);
                ColonyPanel.this.updateProduction();
            }
        }
    }

    public final class WarehousePanel
    extends JPanel
    implements DropTarget,
    PropertyChangeListener {
        public WarehousePanel() {
            this.setLayout(new MigLayout("fill, gap push, insets 0"));
        }

        public void initialize() {
            this.cleanup();
            this.addPropertyChangeListeners();
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
            this.removeAll();
        }

        protected void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().addPropertyChangeListener(this);
            }
        }

        protected void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().removePropertyChangeListener(this);
            }
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.removeAll();
            ClientOptions options = ColonyPanel.this.getClientOptions();
            int threshold = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? 1 : options.getInteger("model.option.guiMinNumberToDisplayGoods");
            Game game = colony.getGame();
            Specification spec = colony.getSpecification();
            for (GoodsType goodsType : spec.getGoodsTypeList()) {
                int count;
                if (!goodsType.isStorable() || (count = colony.getGoodsCount(goodsType)) < threshold) continue;
                Goods goods = new Goods(game, colony, goodsType, count);
                GoodsLabel goodsLabel = new GoodsLabel(goods, ColonyPanel.this.getGUI());
                if (ColonyPanel.this.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, false);
            }
            ColonyPanel.this.updateProduction();
            this.revalidate();
            this.repaint();
        }

        @Override
        public boolean accepts(Unit unit) {
            return false;
        }

        @Override
        public boolean accepts(Goods goods) {
            return true;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                comp.getParent().remove(comp);
                return comp;
            }
            return this.add(comp);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null && event != null) {
                logger.finest(colony.getName() + "-warehouse change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            }
            this.update();
        }

        @Override
        public String getUIClassID() {
            return "WarehousePanelUI";
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }
    }

    public final class ColonyInPortPanel
    extends InPortPanel {
        public ColonyInPortPanel() {
            super(ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setLayout(new MigLayout("wrap 3, fill, insets 0"));
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        protected void addPropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.addPropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.removePropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Unit unit) {
            return unit.isCarrier();
        }

        @Override
        public void selectLabel() {
            this.removePropertyChangeListeners();
            super.selectLabel();
            this.addPropertyChangeListeners();
        }
    }

    public final class OutsideColonyPanel
    extends UnitPanel
    implements DropTarget {
        public OutsideColonyPanel() {
            super(ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setLayout(new MigLayout("wrap 3, fill, insets 0"));
            this.setBorder(GUI.localizedBorder("outsideColony"));
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.removeAll();
        }

        @Override
        protected void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().addPropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().removePropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Unit unit) {
            return !unit.isCarrier();
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.igc().putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!(unit.getLocation() instanceof Tile) && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    this.initialize();
                    return comp;
                }
                logger.warning("Invalid component: " + comp);
                return null;
            }
            ((UnitLabel)comp).setSmall(false);
            return this.add(comp);
        }

        @Override
        public String getUIClassID() {
            return "OutsideColonyPanelUI";
        }
    }

    public final class PopulationPanel
    extends JPanel {
        private final JLabel rebelShield;
        private final JLabel rebelLabel;
        private final JLabel bonusLabel;
        private final JLabel royalistLabel;
        private final JLabel royalistShield;
        private final JLabel rebelMemberLabel;
        private final JLabel popLabel;
        private final JLabel royalistMemberLabel;

        public PopulationPanel() {
            super(new MigLayout("wrap 5, fill, insets 0", "[][]:push[center]:push[right][]"));
            this.rebelShield = new JLabel();
            this.rebelLabel = new JLabel();
            this.bonusLabel = new JLabel();
            this.royalistLabel = new JLabel();
            this.royalistShield = new JLabel();
            this.rebelMemberLabel = new JLabel();
            this.popLabel = new JLabel();
            this.royalistMemberLabel = new JLabel();
            this.setOpaque(false);
            this.setToolTipText(" ");
        }

        public void initialize() {
            this.cleanup();
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            int uc = colony.getUnitCount();
            int solPercent = colony.getSoL();
            int rebels = Colony.calculateRebels(uc, solPercent);
            Nation nation = colony.getOwner().getNation();
            int grow = colony.getPreferredSizeChange();
            int bonus = colony.getProductionBonus();
            this.removeAll();
            ColonyPanel.this.getLibrary();
            this.rebelShield.setIcon(new ImageIcon(ImageLibrary.getCoatOfArmsImage(nation, 0.5)));
            this.add((Component)this.rebelShield, "bottom");
            StringTemplate t = StringTemplate.template("colonyPanel.rebelLabel").addAmount("%number%", rebels);
            this.rebelLabel.setText(Messages.message(t));
            this.add((Component)this.rebelLabel, "split 2, flowy");
            this.rebelMemberLabel.setText(solPercent + "%");
            this.add(this.rebelMemberLabel);
            t = StringTemplate.template("colonyPanel.populationLabel").addAmount("%number%", uc);
            this.popLabel.setText(Messages.message(t));
            this.add((Component)this.popLabel, "split 2, flowy");
            t = StringTemplate.template("colonyPanel.bonusLabel").addAmount("%number%", bonus).add("%extra%", grow == 0 ? "" : "(" + grow + ")");
            this.bonusLabel.setText(Messages.message(t));
            this.add(this.bonusLabel);
            t = StringTemplate.template("colonyPanel.royalistLabel").addAmount("%number%", uc - rebels);
            this.royalistLabel.setText(Messages.message(t));
            this.add((Component)this.royalistLabel, "split 2, flowy");
            this.royalistMemberLabel.setText(colony.getTory() + "%");
            this.add(this.royalistMemberLabel);
            Nation other = colony.getOwner().isREF() ? nation.getRebelNation() : nation.getREFNation();
            try {
                ColonyPanel.this.getLibrary();
                this.royalistShield.setIcon(new ImageIcon(ImageLibrary.getCoatOfArmsImage(other, 0.5)));
                this.add((Component)this.royalistShield, "bottom");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Shield: " + nation + "/" + other, e);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public JToolTip createToolTip() {
            return new RebelToolTip(ColonyPanel.this.getFreeColClient(), ColonyPanel.this.getColony());
        }

        @Override
        public String getUIClassID() {
            return "PopulationPanelUI";
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(FreeColClient freeColClient) {
            super(freeColClient, true);
        }

        @Override
        public void update() {
            super.update();
            ColonyPanel.this.updateCarrierButtons();
            ColonyPanel.this.updatePopulationPanel();
        }
    }
}

