/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;

public class BuildQueuePanel
extends FreeColPanel
implements ItemListener {
    private static final Logger logger = Logger.getLogger(BuildQueuePanel.class.getName());
    private static final DataFlavor BUILD_LIST_FLAVOR = new DataFlavor(List.class, "BuildListFlavor");
    private static final String BUY = "buy";
    private static final int UNABLE_TO_BUILD = -1;
    private static boolean defaultCompact = false;
    private static boolean defaultShowAll = false;
    private final Colony colony;
    private final FeatureContainer featureContainer;
    private final BuildQueueTransferHandler buildQueueHandler = new BuildQueueTransferHandler();
    private final JList<UnitType> unitList;
    private final ConstructionPanel constructionPanel;
    private final JList<BuildableType> buildQueueList;
    private final JList<BuildingType> buildingList;
    private final JButton buyBuildable;
    private final JCheckBox compactBox;
    private final JCheckBox showAllBox;
    private final Map<BuildableType, String> lockReasons = new HashMap<BuildableType, String>();
    private final Set<BuildableType> unbuildableTypes = new HashSet<BuildableType>();

    public BuildQueuePanel(FreeColClient freeColClient, Colony colony) {
        super(freeColClient, new MigLayout("wrap 3", "[260:][390:, fill][260:]", "[][][300:400:][]"));
        this.colony = colony;
        this.featureContainer = new FeatureContainer();
        DefaultListModel<BuildableType> current = new DefaultListModel<BuildableType>();
        for (BuildableType type : this.colony.getBuildQueue()) {
            current.addElement(type);
            this.featureContainer.addFeatures(type);
        }
        BuildQueueMouseAdapter adapter = new BuildQueueMouseAdapter(true);
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JList btl;
                JList bql = BuildQueuePanel.this.buildQueueList;
                DefaultListModel model = (DefaultListModel)bql.getModel();
                JList jList = e.getSource() == BuildQueuePanel.this.unitList ? BuildQueuePanel.this.unitList : (btl = e.getSource() == BuildQueuePanel.this.buildingList ? BuildQueuePanel.this.buildingList : null);
                if (btl != null) {
                    for (BuildableType bt : btl.getSelectedValuesList()) {
                        model.addElement(bt);
                    }
                }
                BuildQueuePanel.this.updateAllLists();
            }
        };
        JLabel header = GUI.localizedLabel("colonyPanel.buildQueue");
        header.setFont(GUI.BIG_HEADER_FONT);
        DefaultListModel units = new DefaultListModel();
        this.unitList = new JList(units);
        this.unitList.setTransferHandler(this.buildQueueHandler);
        this.unitList.setSelectionMode(2);
        this.unitList.setDragEnabled(true);
        this.unitList.addMouseListener(adapter);
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.unitList.getActionMap().put("add", addAction);
        this.constructionPanel = new ConstructionPanel(freeColClient, this.colony, false);
        this.constructionPanel.setDefaultLabel(StringTemplate.template("colonyPanel.currentlyBuilding").add("%buildable%", "nothing"));
        this.buildQueueList = new JList(current);
        this.buildQueueList.setTransferHandler(this.buildQueueHandler);
        this.buildQueueList.setSelectionMode(0);
        this.buildQueueList.setDragEnabled(true);
        this.buildQueueList.addMouseListener(new BuildQueueMouseAdapter(false));
        this.buildQueueList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.buildQueueList.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JList bql = BuildQueuePanel.this.buildQueueList;
                for (BuildableType bt : bql.getSelectedValuesList()) {
                    BuildQueuePanel.this.removeBuildable(bt);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        });
        DefaultListModel buildings = new DefaultListModel();
        this.buildingList = new JList(buildings);
        this.buildingList.setTransferHandler(this.buildQueueHandler);
        this.buildingList.setSelectionMode(2);
        this.buildingList.setDragEnabled(true);
        this.buildingList.addMouseListener(adapter);
        this.buildingList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.buildingList.getActionMap().put("add", addAction);
        this.buyBuildable = GUI.localizedButton("colonyPanel.buyBuilding");
        this.buyBuildable.setActionCommand(BUY);
        this.buyBuildable.addActionListener(this);
        this.compactBox = new JCheckBox(Messages.message("colonyPanel.compactView"));
        this.compactBox.addItemListener(this);
        this.compactBox.setSelected(defaultCompact);
        this.showAllBox = new JCheckBox(Messages.message("colonyPanel.showAll"));
        this.showAllBox.addItemListener(this);
        this.showAllBox.setSelected(defaultShowAll);
        this.updateDetailView();
        this.updateAllLists();
        this.add((Component)header, "span 3, align center, wrap 40");
        this.add((Component)GUI.localizedLabel("colonyPanel.units"), "align center");
        this.add((Component)GUI.localizedLabel("colonyPanel.buildQueue"), "align center");
        this.add((Component)GUI.localizedLabel("colonyPanel.buildings"), "align center");
        this.add((Component)new JScrollPane(this.unitList), "grow");
        this.add((Component)this.constructionPanel, "split 2, flowy");
        this.add((Component)new JScrollPane(this.buildQueueList), "grow");
        this.add((Component)new JScrollPane(this.buildingList), "grow, wrap 20");
        this.add((Component)this.buyBuildable, "span, split 4");
        this.add(this.compactBox);
        this.add(this.showAllBox);
        this.add((Component)this.okButton, "tag ok");
        this.setSize(this.getPreferredSize());
    }

    public Colony getColony() {
        return this.colony;
    }

    private JList<? extends BuildableType> convertJComp(JComponent comp) {
        return comp == this.unitList ? this.unitList : (comp == this.buildQueueList ? this.buildQueueList : (comp == this.buildingList ? this.buildingList : null));
    }

    private void removeBuildable(Object type) {
        DefaultListModel model = (DefaultListModel)this.buildQueueList.getModel();
        model.removeElement(type);
    }

    private void updateUnitList() {
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        DefaultListModel units = (DefaultListModel)this.unitList.getModel();
        units.clear();
        block0: for (UnitType unitType : spec.getBuildableUnitTypes()) {
            StringTemplate tmpl;
            ArrayList<String> lockReason = new ArrayList<String>();
            if (this.unbuildableTypes.contains(unitType)) continue;
            if (unitType.getRequiredPopulation() > this.colony.getUnitCount()) {
                tmpl = StringTemplate.template("colonyPanel.populationTooSmall").addAmount("%number%", unitType.getRequiredPopulation());
                lockReason.add(Messages.message(tmpl));
            }
            if (unitType.getLimits() != null) {
                for (Limit limit : unitType.getLimits()) {
                    if (limit.evaluate(this.colony)) continue;
                    lockReason.add(Messages.getDescription(limit));
                }
            }
            if (!this.colony.hasAbility("model.ability.build", unitType, turn) && !this.featureContainer.hasAbility("model.ability.build", unitType, null)) {
                boolean builderFound = false;
                for (Ability ability : spec.getAbilities("model.ability.build")) {
                    FreeColObject source = ability.getSource();
                    if (!ability.appliesTo(unitType) || !ability.getValue() || source == null || this.unbuildableTypes.contains(source)) continue;
                    builderFound = true;
                    if (!(source instanceof Named)) break;
                    lockReason.add(Messages.getName((Named)((Object)source)));
                    break;
                }
                if (!builderFound) {
                    this.unbuildableTypes.add(unitType);
                    continue;
                }
            }
            for (Map.Entry entry : unitType.getRequiredAbilities().entrySet()) {
                if (this.colony.hasAbility((String)entry.getKey()) == ((Boolean)entry.getValue()).booleanValue() || this.featureContainer.hasAbility((String)entry.getKey(), null, null) == ((Boolean)entry.getValue()).booleanValue()) continue;
                List<FreeColGameObjectType> sources = spec.getTypesProviding((String)entry.getKey(), (Boolean)entry.getValue());
                if (sources.isEmpty()) {
                    this.unbuildableTypes.add(unitType);
                    continue block0;
                }
                lockReason.add(Messages.getName(sources.get(0)));
            }
            if (lockReason.isEmpty()) {
                this.lockReasons.put(unitType, null);
            } else {
                tmpl = StringTemplate.template("colonyPanel.requires").addName("%string%", StringUtils.join("/", lockReason));
                this.lockReasons.put(unitType, Messages.message(tmpl));
            }
            if (!lockReason.isEmpty() && !this.showAllBox.isSelected()) continue;
            units.addElement(unitType);
        }
    }

    private void updateBuildingList() {
        Specification spec = this.getSpecification();
        DefaultListModel buildings = (DefaultListModel)this.buildingList.getModel();
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        buildings.clear();
        block0: for (BuildingType buildingType : spec.getBuildingTypeList()) {
            StringTemplate tmpl;
            ArrayList<String> lockReason = new ArrayList<String>();
            Building colonyBuilding = this.colony.getBuilding(buildingType);
            if (current.contains(buildingType) || this.hasBuildingType(buildingType) || this.unbuildableTypes.contains(buildingType) || !buildingType.needsGoodsToBuild()) continue;
            if (this.unbuildableTypes.contains(buildingType.getUpgradesFrom())) {
                this.unbuildableTypes.add(buildingType);
                continue;
            }
            if (buildingType.hasAbility("model.ability.coastalOnly") && !this.colony.getTile().isCoastland()) {
                tmpl = StringTemplate.template("colonyPanel.coastalOnly");
                lockReason.add(Messages.message(tmpl));
            }
            if (buildingType.getRequiredPopulation() > this.colony.getUnitCount()) {
                tmpl = StringTemplate.template("colonyPanel.populationTooSmall").addAmount("%number%", buildingType.getRequiredPopulation());
                lockReason.add(Messages.message(tmpl));
            }
            for (Map.Entry<String, Boolean> entry : buildingType.getRequiredAbilities().entrySet()) {
                if (this.colony.hasAbility(entry.getKey()) == entry.getValue().booleanValue() || this.featureContainer.hasAbility(entry.getKey(), null, null) == entry.getValue().booleanValue()) continue;
                List<FreeColGameObjectType> sources = this.getSpecification().getTypesProviding(entry.getKey(), entry.getValue());
                if (sources.isEmpty()) {
                    this.unbuildableTypes.add(buildingType);
                    continue block0;
                }
                lockReason.add(Messages.getName(sources.get(0)));
            }
            if (buildingType.getLimits() != null) {
                for (Limit limit : buildingType.getLimits()) {
                    if (limit.evaluate(this.colony)) continue;
                    lockReason.add(Messages.getDescription(limit));
                }
            }
            if (!(buildingType.getUpgradesFrom() == null || current.contains(buildingType.getUpgradesFrom()) || colonyBuilding != null && colonyBuilding.getType() == buildingType.getUpgradesFrom())) {
                lockReason.add(Messages.getName(buildingType.getUpgradesFrom()));
            }
            if (lockReason.isEmpty()) {
                this.lockReasons.put(buildingType, null);
            } else {
                tmpl = StringTemplate.template("colonyPanel.requires").addName("%string%", StringUtils.join("/", lockReason));
                this.lockReasons.put(buildingType, Messages.message(tmpl));
            }
            if (!lockReason.isEmpty() && !this.showAllBox.isSelected()) continue;
            buildings.addElement(buildingType);
        }
    }

    private void updateAllLists() {
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        this.featureContainer.clear();
        Enumeration e = current.elements();
        while (e.hasMoreElements()) {
            BuildableType type = (BuildableType)e.nextElement();
            if (this.getMinimumIndex(type) >= 0) {
                this.featureContainer.addFeatures(type);
                continue;
            }
            current.removeElement(type);
        }
        this.updateBuildingList();
        this.updateUnitList();
        boolean pay = this.getSpecification().getBoolean("model.option.payForBuilding");
        if (current.getSize() == 0 || !pay) {
            this.buyBuildable.setEnabled(false);
        } else {
            this.buyBuildable.setEnabled(this.colony.canPayToFinishBuilding((BuildableType)current.getElementAt(0)));
        }
        if (current.getSize() > 0) {
            this.constructionPanel.update((BuildableType)current.getElementAt(0));
        }
    }

    private boolean hasBuildingType(BuildingType buildingType) {
        if (this.colony.getBuilding(buildingType) == null) {
            return false;
        }
        if (this.colony.getBuilding(buildingType).getType() == buildingType) {
            return true;
        }
        if (buildingType.getUpgradesTo() != null) {
            return this.hasBuildingType(buildingType.getUpgradesTo());
        }
        return false;
    }

    private List<BuildableType> getBuildableTypes(JList<? extends BuildableType> list) {
        ArrayList<BuildableType> result = new ArrayList<BuildableType>();
        if (list == null) {
            return result;
        }
        ListModel<? extends BuildableType> model = list.getModel();
        for (int index = 0; index < model.getSize(); ++index) {
            result.add(model.getElementAt(index));
        }
        return result;
    }

    private List<BuildableType> getBuildableTypes(Object[] objects) {
        ArrayList<BuildableType> result = new ArrayList<BuildableType>();
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof BuildableType)) continue;
                result.add((BuildableType)object);
            }
        }
        return result;
    }

    private int getMinimumIndex(BuildableType buildableType) {
        block6: {
            BuildingType buildingType;
            ListModel<BuildableType> buildQueue;
            block5: {
                buildQueue = this.buildQueueList.getModel();
                if (!(buildableType instanceof UnitType)) break block5;
                if (this.colony.canBuild(buildableType)) {
                    return 0;
                }
                for (int index = 0; index < buildQueue.getSize(); ++index) {
                    if (!buildQueue.getElementAt(index).hasAbility("model.ability.build", buildableType)) continue;
                    return index + 1;
                }
                break block6;
            }
            if (!(buildableType instanceof BuildingType)) break block6;
            BuildingType upgradesFrom = ((BuildingType)buildableType).getUpgradesFrom();
            if (upgradesFrom == null) {
                return 0;
            }
            Building building = this.colony.getBuilding((BuildingType)buildableType);
            BuildingType buildingType2 = buildingType = building == null ? null : building.getType();
            if (buildingType == upgradesFrom) {
                return 0;
            }
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                if (!upgradesFrom.equals(buildQueue.getElementAt(index))) continue;
                return index + 1;
            }
        }
        return -1;
    }

    private int getMaximumIndex(BuildableType buildableType) {
        ListModel<BuildableType> buildQueue = this.buildQueueList.getModel();
        int buildQueueLastPos = buildQueue.getSize();
        boolean canBuild = false;
        if (this.colony.canBuild(buildableType)) {
            canBuild = true;
        }
        if (buildableType instanceof UnitType) {
            if (canBuild) {
                return buildQueueLastPos;
            }
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                BuildableType toBuild = buildQueue.getElementAt(index);
                if (toBuild == buildableType || !toBuild.hasAbility("model.ability.build", buildableType)) continue;
                return buildQueueLastPos;
            }
            return -1;
        }
        if (buildableType instanceof BuildingType) {
            BuildingType upgradesFrom = ((BuildingType)buildableType).getUpgradesFrom();
            BuildingType upgradesTo = ((BuildingType)buildableType).getUpgradesTo();
            if (!canBuild && upgradesFrom == null) {
                return -1;
            }
            if (canBuild && upgradesTo == null) {
                return buildQueueLastPos;
            }
            boolean foundUpgradesFrom = canBuild;
            for (int index = 0; index < buildQueue.getSize(); ++index) {
                BuildableType toBuild = buildQueue.getElementAt(index);
                if (toBuild == buildableType) continue;
                if (!canBuild && !foundUpgradesFrom && upgradesFrom.equals(toBuild)) {
                    foundUpgradesFrom = true;
                    if (upgradesTo == null) {
                        return buildQueueLastPos;
                    }
                }
                if (foundUpgradesFrom && upgradesTo != null && upgradesTo.equals(toBuild)) {
                    return index;
                }
                if (!buildableType.hasAbility("model.ability.build", toBuild)) continue;
                return index;
            }
            return buildQueueLastPos;
        }
        return -1;
    }

    private void updateDetailView() {
        ListCellRenderer cellRenderer = this.compactBox.isSelected() ? new FreeColComboBoxRenderer() : new DefaultBuildQueueCellRenderer();
        this.buildQueueList.setCellRenderer(cellRenderer);
        this.buildingList.setCellRenderer(cellRenderer);
        this.unitList.setCellRenderer(cellRenderer);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String FAIL = "FAIL";
        if (this.colony.getOwner() == this.getMyPlayer()) {
            String command = event.getActionCommand();
            List<BuildableType> buildables = this.getBuildableTypes(this.buildQueueList);
            while (!buildables.isEmpty() && this.lockReasons.get(buildables.get(0)) != null) {
                this.getGUI().showInformationMessage((FreeColObject)buildables.get(0), StringTemplate.template("colonyPanel.unbuildable").addName("%colony%", this.colony.getName()).add("%object%", buildables.get(0).getNameKey()));
                command = "FAIL";
                this.removeBuildable(buildables.remove(0));
            }
            this.igc().setBuildQueue(this.colony, buildables);
            if ("FAIL".equals(command)) {
                this.updateAllLists();
                return;
            }
            if (!"OK".equals(command)) {
                if (BUY.equals(command)) {
                    this.igc().payForBuilding(this.colony);
                } else {
                    super.actionPerformed(event);
                }
            }
        }
        this.getGUI().removeFromCanvas(this);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.compactBox) {
            this.updateDetailView();
            defaultCompact = this.compactBox.isSelected();
        } else if (event.getSource() == this.showAllBox) {
            this.updateAllLists();
            defaultShowAll = this.showAllBox.isSelected();
        }
    }

    private class DefaultBuildQueueCellRenderer
    implements ListCellRenderer<BuildableType> {
        private final JPanel itemPanel = new JPanel();
        private final JPanel selectedPanel = new JPanel();
        private final JLabel imageLabel = new JLabel(new ImageIcon());
        private final JLabel nameLabel = new JLabel();
        private final JLabel lockLabel = new JLabel(new ImageIcon(ResourceManager.getImage("lock.image", 0.5)));
        private final Dimension buildingDimension = new Dimension(-1, 48);

        public DefaultBuildQueueCellRenderer() {
            this.itemPanel.setOpaque(false);
            this.itemPanel.setLayout(new MigLayout());
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.setLayout(new MigLayout());
            this.selectedPanel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.selectedPanel));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends BuildableType> list, BuildableType value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = isSelected ? this.selectedPanel : this.itemPanel;
            panel.removeAll();
            ((ImageIcon)this.imageLabel.getIcon()).setImage(ResourceManager.getImage(value.getId() + ".image", this.buildingDimension));
            this.nameLabel.setText(Messages.getName(value));
            panel.setToolTipText((String)BuildQueuePanel.this.lockReasons.get(value));
            panel.add((Component)this.imageLabel, "span 1 2");
            if (BuildQueuePanel.this.lockReasons.get(value) == null) {
                panel.add((Component)this.nameLabel, "wrap");
            } else {
                panel.add((Component)this.nameLabel, "split 2");
                panel.add((Component)this.lockLabel, "wrap");
            }
            List<AbstractGoods> required = value.getRequiredGoods();
            int size = required.size();
            for (int i = 0; i < size; ++i) {
                AbstractGoods goods = required.get(i);
                String id = goods.getType().getId() + ".image";
                ImageIcon icon = new ImageIcon(ResourceManager.getImage(id, 0.66));
                JLabel goodsLabel = new JLabel(Integer.toString(goods.getAmount()), icon, 0);
                if (i == 0 && size > 1) {
                    panel.add((Component)goodsLabel, "split " + size);
                    continue;
                }
                panel.add(goodsLabel);
            }
            return panel;
        }
    }

    private class BuildQueueMouseAdapter
    extends MouseAdapter {
        private boolean add = true;
        private boolean enabled = false;

        public BuildQueueMouseAdapter(boolean add) {
            this.add = add;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JList jlist;
            if (!this.enabled && e.getClickCount() == 1 && !e.isConsumed()) {
                this.enabled = true;
            }
            if (!this.enabled) {
                return;
            }
            Object source = e.getSource();
            JList jList = jlist = source instanceof JComponent ? BuildQueuePanel.this.convertJComp((JComponent)source) : null;
            if (jlist == null) {
                return;
            }
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                int index = jlist.locationToIndex(e.getPoint());
                BuildableType bt = (BuildableType)jlist.getModel().getElementAt(index);
                BuildQueuePanel.this.getGUI().showColopediaPanel(bt.getId());
            } else if (e.getClickCount() > 1 && !e.isConsumed()) {
                JList bql = BuildQueuePanel.this.buildQueueList;
                DefaultListModel model = (DefaultListModel)bql.getModel();
                if (jlist.getSelectedIndex() < 0) {
                    jlist.setSelectedIndex(jlist.locationToIndex(e.getPoint()));
                }
                for (BuildableType bt : jlist.getSelectedValuesList()) {
                    if (this.add) {
                        model.addElement(bt);
                        continue;
                    }
                    model.removeElement(bt);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        }
    }

    private class BuildQueueTransferHandler
    extends TransferHandler {
        private JList<? extends BuildableType> source = null;
        private int numberOfItems = 0;

        private BuildQueueTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable data) {
            Object transferData;
            if (!this.canImport(comp, data.getTransferDataFlavors())) {
                return false;
            }
            JList target = BuildQueuePanel.this.convertJComp(comp);
            if (target == null) {
                logger.warning("Build queue import failed to: " + comp);
                return false;
            }
            try {
                transferData = data.getTransferData(BUILD_LIST_FLAVOR);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "BuildQueue import", e);
                return false;
            }
            if (!(transferData instanceof List)) {
                return false;
            }
            JList bql = BuildQueuePanel.this.buildQueueList;
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            for (Object object : (List)transferData) {
                if (!(object instanceof BuildableType) || object instanceof UnitType && target == BuildQueuePanel.this.buildingList || object instanceof BuildingType && target == BuildQueuePanel.this.unitList || BuildQueuePanel.this.getMinimumIndex((BuildableType)object) < 0) {
                    return false;
                }
                queue.add((BuildableType)object);
            }
            boolean isOrderingQueue = false;
            if (this.source == bql) {
                if (target != bql) {
                    DefaultListModel sourceModel = (DefaultListModel)this.source.getModel();
                    for (Object e : queue) {
                        sourceModel.removeElement(e);
                    }
                    return true;
                }
                isOrderingQueue = true;
            } else if (target != bql && target.getParent() != bql) {
                return false;
            }
            DefaultListModel targetModel = (DefaultListModel)bql.getModel();
            int preferredIndex = target.getSelectedIndex();
            int n = targetModel.size();
            int prevPos = -1;
            if (isOrderingQueue) {
                for (int i = 0; i < targetModel.getSize(); ++i) {
                    if (targetModel.getElementAt(i) != queue.get(0)) continue;
                    prevPos = i;
                    break;
                }
                if (preferredIndex != -1 && prevPos == preferredIndex) {
                    return false;
                }
                int maximumIndex = BuildQueuePanel.this.getMaximumIndex((BuildableType)queue.get(0));
                if (preferredIndex > maximumIndex) {
                    return false;
                }
                this.numberOfItems = queue.size();
                for (BuildableType bt : queue) {
                    targetModel.removeElement(bt);
                }
            }
            if (preferredIndex < 0 || preferredIndex > n) {
                preferredIndex = n;
            }
            for (int index = 0; index < queue.size(); ++index) {
                int maximumIndex;
                BuildableType toBuild = (BuildableType)queue.get(index);
                int minimumIndex = BuildQueuePanel.this.getMinimumIndex(toBuild);
                if (minimumIndex < targetModel.size() && minimumIndex != (maximumIndex = BuildQueuePanel.this.getMaximumIndex(toBuild))) {
                    if (minimumIndex < preferredIndex + index) {
                        minimumIndex = preferredIndex + index;
                    }
                    if (minimumIndex > targetModel.size()) {
                        minimumIndex = targetModel.size();
                    }
                    if (minimumIndex > maximumIndex) {
                        minimumIndex = maximumIndex;
                    }
                }
                targetModel.add(minimumIndex, toBuild);
            }
            if (isOrderingQueue) {
                BuildQueuePanel.this.buildQueueList.setSelectedIndex(preferredIndex);
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            this.numberOfItems = 0;
            BuildQueuePanel.this.updateAllLists();
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            if (flavors == null) {
                return false;
            }
            for (DataFlavor flavor : flavors) {
                if (!flavor.equals(BUILD_LIST_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            this.source = BuildQueuePanel.this.convertJComp(comp);
            if (this.source == null) {
                return null;
            }
            return new BuildablesTransferable(this.source.getSelectedValuesList());
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return comp == BuildQueuePanel.this.unitList ? 1 : 2;
        }

        public class BuildablesTransferable
        implements Transferable {
            private final List<? extends BuildableType> buildables;
            private final DataFlavor[] supportedFlavors = new DataFlavor[]{BuildQueuePanel.access$000()};

            public BuildablesTransferable(List<? extends BuildableType> buildables) {
                this.buildables = buildables;
            }

            public List<? extends BuildableType> getBuildables() {
                return this.buildables;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return this.buildables;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.supportedFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                for (DataFlavor myFlavor : this.supportedFlavors) {
                    if (!myFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

