/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import javax.swing.JLabel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;

public class AbstractGoodsLabel
extends JLabel {
    private final AbstractGoods goods;
    private boolean partialChosen;
    private final GUI gui;

    public AbstractGoodsLabel(AbstractGoods goods, GUI gui) {
        gui.getImageLibrary();
        super(ImageLibrary.getGoodsImageIcon(goods.getType()));
        this.partialChosen = false;
        this.goods = goods;
        this.setToolTipText(Messages.getName(goods));
        this.gui = gui;
    }

    protected GUI getGUI() {
        return this.gui;
    }

    public boolean isPartialChosen() {
        return this.partialChosen;
    }

    public void setPartialChosen(boolean partialChosen) {
        this.partialChosen = partialChosen;
    }

    public AbstractGoods getGoods() {
        return this.goods;
    }

    public GoodsType getType() {
        return this.goods.getType();
    }

    public int getAmount() {
        return this.goods.getAmount();
    }

    public void setDefaultAmount() {
    }
}

