/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.resources.ResourceManager;

public final class AboutPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(AboutPanel.class.getName());
    public static final String SITE_URL = "http://www.freecol.org";
    public static final String PROJECT_URL = "http://sourceforge.net/projects/freecol/";

    public AboutPanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout("wrap"));
        Image tempImage = ResourceManager.getImage("TitleImage");
        if (tempImage != null) {
            JLabel logoLabel = new JLabel(new ImageIcon(tempImage));
            logoLabel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new BevelBorder(1)));
            this.add((Component)logoLabel, "center");
        }
        this.add((Component)GUI.localizedLabel("aboutPanel.version"), "newline 20");
        this.add((Component)new JLabel(FreeCol.getRevision()), "newline");
        this.add((Component)GUI.localizedLabel("aboutPanel.officialSite"), "newline 10");
        JButton site = GUI.getLinkButton(SITE_URL, null, SITE_URL);
        site.addActionListener(this);
        this.add((Component)site, "newline");
        this.add((Component)GUI.localizedLabel("aboutPanel.sfProject"), "newline 10");
        JButton project = GUI.getLinkButton(PROJECT_URL, null, PROJECT_URL);
        project.addActionListener(this);
        this.add((Component)project, "newline");
        this.add((Component)GUI.getDefaultTextArea(Messages.message("aboutPanel.legalDisclaimer")), "newline 20, width 300px");
        this.add((Component)GUI.localizedLabel("aboutPanel.copyright"), "newline 10");
        this.add((Component)this.okButton, "newline 20, tag ok");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String url = event.getActionCommand();
        if (SITE_URL.equals(url) || PROJECT_URL.equals(url)) {
            String os = System.getProperty("os.name");
            String[] cmd = null;
            if (os == null) {
                return;
            }
            cmd = os.toLowerCase().contains("mac") ? new String[]{"open", "-a", "Safari", url} : (os.toLowerCase().contains("windows") ? new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url} : (os.toLowerCase().contains("linux") ? new String[]{"xdg-open", url} : new String[]{"firefox", url}));
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException x) {}
        } else {
            super.actionPerformed(event);
        }
    }
}

