/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.Option;

public final class ListOptionUI<T>
extends OptionUI<ListOption<T>>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(ListOptionUI.class.getName());
    private final JPanel panel;
    private final JList<AbstractOption<T>> list;
    private final DefaultListModel<AbstractOption<T>> model;
    private final JButton editButton = GUI.localizedButton("list.edit");
    private final JButton addButton = GUI.localizedButton("list.add");
    private final JButton removeButton = GUI.localizedButton("list.remove");
    private final JButton upButton = GUI.localizedButton("list.up");
    private final JButton downButton = GUI.localizedButton("list.down");

    public ListOptionUI(final GUI gui, final ListOption<T> option, boolean editable) {
        super(gui, option, editable);
        AbstractOption o;
        this.panel = new JPanel();
        this.panel.setBorder(GUI.localizedBorder(super.getJLabel().getText(), GUI.BORDER_COLOR));
        this.panel.setLayout(new MigLayout("wrap 2, fill", "[fill, grow]20[fill]"));
        this.model = new DefaultListModel();
        Iterator iterator = option.getValue().iterator();
        while (iterator.hasNext()) {
            AbstractOption o2 = (AbstractOption)iterator.next();
            try {
                Object c = o2.clone();
                this.model.addElement((AbstractOption<T>)c);
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.WARNING, "Can not clone " + o2.getId(), e);
            }
        }
        this.list = new JList<AbstractOption<T>>(this.model);
        AbstractOption abstractOption = o = option.getValue().isEmpty() ? option.getTemplate() : (AbstractOption)option.getValue().get(0);
        if (o != null) {
            this.setCellRenderer(gui, o, editable);
            this.list.setSelectedIndex(0);
        }
        this.list.setVisibleRowCount(4);
        JScrollPane pane = new JScrollPane(this.list);
        this.panel.add((Component)pane, "grow, spany 5");
        for (JButton button : new JButton[]{this.editButton, this.addButton, this.removeButton, this.upButton, this.downButton}) {
            button.setEnabled(editable);
            this.panel.add(button);
        }
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractOption oldValue = (AbstractOption)ListOptionUI.this.list.getSelectedValue();
                if (oldValue == null) {
                    oldValue = option.getTemplate();
                }
                try {
                    Object newValue;
                    Object object = newValue = oldValue == null ? null : oldValue.clone();
                    if (gui.showEditOptionDialog((Option)newValue) && option.canAdd(newValue)) {
                        ListOptionUI.this.model.addElement(newValue);
                        ListOptionUI.this.list.setSelectedValue(newValue, true);
                        ListOptionUI.this.list.repaint();
                    }
                }
                catch (CloneNotSupportedException e) {
                    logger.log(Level.WARNING, "Can not clone: " + oldValue, e);
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = ListOptionUI.this.list.getSelectedValue();
                if (object != null && gui.showEditOptionDialog((Option)object)) {
                    ListOptionUI.this.list.repaint();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListOptionUI.this.model.removeElementAt(ListOptionUI.this.list.getSelectedIndex());
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == 0) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                AbstractOption temp = (AbstractOption)ListOptionUI.this.model.getElementAt(index);
                ListOptionUI.this.model.setElementAt(ListOptionUI.this.model.getElementAt(index - 1), index);
                ListOptionUI.this.model.setElementAt(temp, index - 1);
                ListOptionUI.this.list.setSelectedIndex(index - 1);
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == ListOptionUI.this.model.getSize() - 1) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                AbstractOption temp = (AbstractOption)ListOptionUI.this.model.getElementAt(index);
                ListOptionUI.this.model.setElementAt(ListOptionUI.this.model.getElementAt(index + 1), index);
                ListOptionUI.this.model.setElementAt(temp, index + 1);
                ListOptionUI.this.list.setSelectedIndex(index + 1);
            }
        });
        this.list.addListSelectionListener(this);
        this.initialize();
    }

    private void setCellRenderer(GUI gui, AbstractOption<T> o, boolean editable) {
        OptionUI ui = OptionUI.getOptionUI(gui, o, editable);
        if (ui != null && ui.getListCellRenderer() != null) {
            this.list.setCellRenderer(ui.getListCellRenderer());
        }
    }

    private List<AbstractOption<T>> getValue() {
        ArrayList<AbstractOption<T>> result = new ArrayList<AbstractOption<T>>();
        Enumeration<AbstractOption<T>> e = this.model.elements();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    @Override
    public final JLabel getJLabel() {
        return null;
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((ListOption)this.getOption()).setValue(this.getValue());
    }

    @Override
    public void reset() {
        this.model.clear();
        Iterator iterator = ((ListOption)this.getOption()).getValue().iterator();
        while (iterator.hasNext()) {
            AbstractOption o = (AbstractOption)iterator.next();
            this.model.addElement(o);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean enabled = this.isEditable() && this.list.getSelectedValue() != null;
            this.editButton.setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }
}

