/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.option.AudioMixerOption;

public final class AudioMixerOptionUI
extends OptionUI<AudioMixerOption> {
    private final JPanel panel = new JPanel();
    private final JComboBox<AudioMixerOption.MixerWrapper> cbox;
    private final JButton button1;
    private final JButton button2;
    private final JLabel currentMixerLabel;
    private final ActionListener aHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AudioMixerOptionUI.this.button1) {
                AudioMixerOptionUI.this.gui.playSound("sound.event.buildingComplete");
            } else if (e.getSource() == AudioMixerOptionUI.this.button2) {
                AudioMixerOptionUI.this.gui.playSound("sound.intro.general");
            } else if (e.getSource() == AudioMixerOptionUI.this.cbox) {
                AudioMixerOption.MixerWrapper value = (AudioMixerOption.MixerWrapper)AudioMixerOptionUI.this.cbox.getSelectedItem();
                if (((AudioMixerOption)AudioMixerOptionUI.this.getOption()).getValue() != value) {
                    ((AudioMixerOption)AudioMixerOptionUI.this.getOption()).setValue(value);
                    AudioMixerOptionUI.this.updateMixerLabel();
                }
            }
        }
    };

    public AudioMixerOptionUI(GUI gui, AudioMixerOption option, boolean editable) {
        super(gui, option, editable);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(15);
        this.panel.setLayout(layout);
        this.cbox = new JComboBox();
        this.panel.add(this.cbox, "West");
        this.currentMixerLabel = new JLabel();
        this.panel.add((Component)this.currentMixerLabel, "East");
        this.updateMixerLabel();
        this.button1 = GUI.localizedButton("Test");
        this.panel.add(this.button1);
        this.button1.addActionListener(this.aHandler);
        this.button2 = GUI.localizedButton("Music");
        this.panel.add(this.button2);
        this.button2.addActionListener(this.aHandler);
        this.cbox.add(super.getJLabel());
        this.cbox.setModel(new DefaultComboBoxModel<AudioMixerOption.MixerWrapper>(((AudioMixerOption)this.getOption()).getChoices().toArray(new AudioMixerOption.MixerWrapper[0])));
        this.reset();
        this.cbox.setEnabled(editable);
        this.cbox.addActionListener(this.aHandler);
        this.initialize();
    }

    private void updateMixerLabel() {
        Mixer mixer;
        SoundPlayer soundPlayer = this.gui.getSoundPlayer();
        String text = soundPlayer == null ? Messages.message("nothing") : ((mixer = soundPlayer.getMixer()) == null ? Messages.message("none") : mixer.getMixerInfo().getName());
        this.currentMixerLabel.setText(Messages.message("Current") + ":  " + text);
    }

    @Override
    public final JLabel getJLabel() {
        return null;
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((AudioMixerOption)this.getOption()).setValue((AudioMixerOption.MixerWrapper)this.cbox.getSelectedItem());
    }

    @Override
    public void reset() {
        this.cbox.setSelectedItem(((AudioMixerOption)this.getOption()).getValue());
    }
}

