/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FullScreenFrame;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.menu.InGameMenuBar;

public class FreeColMenuTest
implements ActionListener,
ItemListener {
    JTextArea output;
    JScrollPane scrollPane;
    final String newline = "\n";

    public JMenuBar createMenuBar() {
        InGameMenuBar menuBar = null;
        FreeColClient client = new FreeColClient(null, null, true, null, true, null, null, null);
        menuBar = new InGameMenuBar(client);
        client.updateActions();
        ((FreeColMenuBar)menuBar).update();
        return menuBar;
    }

    public Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        this.output = new JTextArea(5, 30);
        this.output.setEditable(false);
        this.scrollPane = new JScrollPane(this.output);
        contentPane.add((Component)this.scrollPane, "Center");
        return contentPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Action event detected.\n    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")";
        this.output.append(s + "\n");
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Item event detected.\n    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")" + "\n" + "    New state: " + (e.getStateChange() == 1 ? "selected" : "unselected");
        this.output.append(s + "\n");
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(46);
        return classString.substring(dotIndex + 1);
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = FreeColMenuTest.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        FreeColClient client = new FreeColClient(null, null, true, null, true, null, null, null);
        FullScreenFrame frame = new FullScreenFrame(client, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        frame.setDefaultCloseOperation(0);
        FreeColMenuTest demo = new FreeColMenuTest();
        frame.setJMenuBar(demo.createMenuBar());
        frame.setContentPane(demo.createContentPane());
        frame.setPreferredSize(new Dimension(450, 260));
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeColMenuTest.createAndShowGUI();
            }
        });
    }
}

