/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceManager;

public class DebugMenu
extends JMenu {
    private static final Logger logger = Logger.getLogger(DebugMenu.class.getName());
    private static final String ERROR_MESSAGE = "This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred.";
    private final FreeColClient freeColClient;

    public DebugMenu(FreeColClient freeColClient) {
        super(Messages.message("menuBar.debug"));
        this.freeColClient = freeColClient;
        this.buildDebugMenu();
    }

    private void buildDebugMenu() {
        final Game game = this.freeColClient.getGame();
        final GUI gui = this.freeColClient.getGUI();
        boolean hasServer = this.freeColClient.getFreeColServer() != null;
        final Player player = this.freeColClient.getMyPlayer();
        this.setOpaque(false);
        this.setMnemonic(68);
        this.add(this);
        JCheckBoxMenuItem sc = GUI.localizedCheckBoxMenuItem("menuBar.debug.showCoordinates", FreeColDebugger.debugDisplayCoordinates());
        sc.setOpaque(false);
        sc.setMnemonic(83);
        this.add(sc);
        sc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean val = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                FreeColDebugger.setDebugDisplayCoordinates(val);
                gui.refresh();
            }
        });
        sc.setEnabled(true);
        final JCheckBoxMenuItem reveal = GUI.localizedCheckBoxMenuItem("menuBar.debug.revealEntireMap", false);
        reveal.setOpaque(false);
        reveal.setMnemonic(82);
        this.add(reveal);
        reveal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.revealMap(DebugMenu.this.freeColClient, true);
                reveal.setEnabled(false);
            }
        });
        reveal.setEnabled(hasServer);
        final JCheckBoxMenuItem hide = GUI.localizedCheckBoxMenuItem("menuBar.debug.hideEntireMap", false);
        hide.setOpaque(false);
        this.add(hide);
        hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.revealMap(DebugMenu.this.freeColClient, false);
                hide.setEnabled(false);
            }
        });
        hide.setEnabled(hasServer);
        JCheckBoxMenuItem searchTrace = GUI.localizedCheckBoxMenuItem("menuBar.debug.searchTrace", game.getMap().getSearchTrace());
        searchTrace.setOpaque(false);
        this.add(searchTrace);
        searchTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean val = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                game.getMap().setSearchTrace(val);
            }
        });
        JMenu cvpMenu = GUI.localizedMenu("menuBar.debug.showColonyValue");
        cvpMenu.setOpaque(false);
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem cv1 = new JRadioButtonMenuItem("Do not display", FreeColDebugger.debugDisplayColonyValuePlayer() == null);
        cv1.setOpaque(false);
        cv1.setMnemonic(67);
        cvpMenu.add(cv1);
        bg.add(cv1);
        cv1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FreeColDebugger.setDebugDisplayColonyValuePlayer(null);
                gui.refresh();
            }
        });
        this.add(cvpMenu);
        cvpMenu.addSeparator();
        for (Player p : game.getLiveEuropeanPlayers(null)) {
            JRadioButtonMenuItem cv2 = GUI.localizedRadioButtonMenuItem(p.getNationName(), FreeColDebugger.debugDisplayColonyValuePlayer() == p);
            cv2.setOpaque(false);
            cvpMenu.add(cv2);
            bg.add(cv2);
            final Player fp = p;
            cv2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FreeColDebugger.setDebugDisplayColonyValuePlayer(fp);
                    gui.refresh();
                }
            });
        }
        this.addSeparator();
        JMenuItem skipTurns = GUI.localizedMenuItem("menuBar.debug.skipTurns");
        skipTurns.setOpaque(false);
        skipTurns.setMnemonic(84);
        this.add(skipTurns);
        skipTurns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.skipTurns(DebugMenu.this.freeColClient);
            }
        });
        DebugUtils.addSkipChangeListener(this.freeColClient, this, skipTurns);
        skipTurns.setEnabled(hasServer);
        final JMenuItem addBuilding = GUI.localizedMenuItem("menuBar.debug.addBuilding");
        addBuilding.setOpaque(false);
        addBuilding.setMnemonic(66);
        this.add(addBuilding);
        addBuilding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.addBuildings(DebugMenu.this.freeColClient, addBuilding.getText());
            }
        });
        addBuilding.setEnabled(hasServer);
        final JMenuItem addFather = GUI.localizedMenuItem("menuBar.debug.addFoundingFather");
        addFather.setOpaque(false);
        addFather.setMnemonic(70);
        this.add(addFather);
        addFather.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.addFathers(DebugMenu.this.freeColClient, addFather.getText());
            }
        });
        addFather.setEnabled(hasServer);
        final JMenuItem runMonarch = GUI.localizedMenuItem("menuBar.debug.runMonarch");
        runMonarch.setOpaque(false);
        runMonarch.setMnemonic(77);
        this.add(runMonarch);
        runMonarch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.setMonarchAction(DebugMenu.this.freeColClient, runMonarch.getText());
            }
        });
        runMonarch.setEnabled(hasServer);
        JMenuItem addGold = GUI.localizedMenuItem("menuBar.debug.addGold");
        addGold.setOpaque(false);
        addGold.setMnemonic(71);
        this.add(addGold);
        addGold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.addGold(DebugMenu.this.freeColClient);
            }
        });
        addGold.setEnabled(hasServer);
        JMenuItem addCrosses = GUI.localizedMenuItem("menuBar.debug.addImmigration");
        addCrosses.setOpaque(false);
        addCrosses.setMnemonic(73);
        this.add(addCrosses);
        addCrosses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.addImmigration(DebugMenu.this.freeColClient);
            }
        });
        addCrosses.setEnabled(hasServer);
        JMenuItem giveBells = GUI.localizedMenuItem("menuBar.debug.addLiberty");
        giveBells.setOpaque(false);
        giveBells.setMnemonic(76);
        this.add(giveBells);
        giveBells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.addLiberty(DebugMenu.this.freeColClient);
            }
        });
        giveBells.setEnabled(hasServer);
        JMenuItem rng = GUI.localizedMenuItem("menuBar.debug.stepRandomNumberGenerator");
        rng.setOpaque(false);
        rng.setMnemonic(88);
        this.add(rng);
        rng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.stepRNG(DebugMenu.this.freeColClient);
            }
        });
        rng.setEnabled(hasServer);
        JMenuItem du = GUI.localizedMenuItem("menuBar.debug.displayUnits");
        du.setOpaque(false);
        this.add(du);
        du.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.displayUnits(DebugMenu.this.freeColClient);
            }
        });
        du.setEnabled(true);
        this.addSeparator();
        JMenu panelMenu = GUI.localizedMenu("menuBar.debug.displayPanels");
        panelMenu.setOpaque(false);
        JMenuItem monarchDialog = GUI.localizedMenuItem("menuBar.debug.displayMonarchPanel");
        monarchDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.showMonarchDialog(Monarch.MonarchAction.RAISE_TAX_WAR, null, player.getMonarchKey());
            }
        });
        panelMenu.add(monarchDialog);
        JMenuItem errorMessage = GUI.localizedMenuItem("menuBar.debug.displayErrorMessage");
        errorMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.showErrorMessage(DebugMenu.ERROR_MESSAGE);
            }
        });
        panelMenu.add(errorMessage);
        this.add(panelMenu);
        JMenuItem europeStatus = GUI.localizedMenuItem("menuBar.debug.displayEuropeStatus");
        europeStatus.setOpaque(false);
        europeStatus.setMnemonic(69);
        this.add(europeStatus);
        europeStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.displayEurope(DebugMenu.this.freeColClient);
            }
        });
        europeStatus.setEnabled(hasServer);
        JCheckBoxMenuItem dam = new JCheckBoxMenuItem("Display AI-missions", FreeColDebugger.debugShowMission());
        final JCheckBoxMenuItem dami = new JCheckBoxMenuItem("Additional AI-mission info", FreeColDebugger.debugShowMissionInfo());
        dam.setOpaque(false);
        dam.setMnemonic(65);
        this.add(dam);
        dam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean val = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                FreeColDebugger.setDebugShowMission(val);
                dami.setEnabled(val);
                gui.refresh();
            }
        });
        dam.setEnabled(true);
        JMenuItem useAI = GUI.localizedMenuItem("menuBar.debug.useAI");
        useAI.setOpaque(false);
        useAI.setMnemonic(65);
        useAI.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(useAI);
        useAI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.useAI(DebugMenu.this.freeColClient);
            }
        });
        useAI.setEnabled(hasServer);
        dami.setOpaque(false);
        dami.setMnemonic(73);
        this.add(dami);
        dami.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean val = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                FreeColDebugger.setDebugShowMissionInfo(val);
                dami.setEnabled(val);
                gui.refresh();
            }
        });
        dami.setEnabled(FreeColDebugger.debugShowMissionInfo());
        this.addSeparator();
        JMenuItem compareMaps = GUI.localizedMenuItem("menuBar.debug.compareMaps");
        compareMaps.setOpaque(false);
        compareMaps.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(compareMaps);
        compareMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugUtils.checkDesyncAction(DebugMenu.this.freeColClient);
            }
        });
        compareMaps.setEnabled(hasServer);
        JMenuItem showResourceKeys = GUI.localizedMenuItem("menuBar.debug.showResourceKeys");
        showResourceKeys.setOpaque(false);
        this.add(showResourceKeys);
        showResourceKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<String, Resource> resources = ResourceManager.getResources();
                ArrayList<String> keys = new ArrayList<String>(resources.keySet());
                Collections.sort(keys);
                StringBuilder builder = new StringBuilder();
                for (String key : keys) {
                    builder.append(key);
                    Resource resource = resources.get(key);
                    if (resource instanceof ImageResource) {
                        ImageResource ir = (ImageResource)resource;
                        builder.append(" (");
                        builder.append(ir.getCount());
                        builder.append(")");
                    }
                    builder.append("\n");
                }
                gui.showInformationMessage(builder.toString());
            }
        });
        showResourceKeys.setEnabled(true);
        JMenuItem statistics = GUI.localizedMenuItem("statistics");
        statistics.setOpaque(false);
        this.add(statistics);
        statistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.showStatisticsPanel();
            }
        });
        statistics.setEnabled(true);
        JMenuItem gc = GUI.localizedMenuItem("menuBar.debug.memoryManager.gc");
        gc.setOpaque(false);
        this.add(gc);
        gc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        gc.setEnabled(true);
        this.addSeparator();
    }
}

