/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;

public abstract class SelectableAction
extends MapboardAction {
    public static final String id = "selectableAction";
    private final String optionId;
    protected boolean selected = false;

    protected SelectableAction(FreeColClient freeColClient, String id, String optionId) {
        super(freeColClient, id);
        this.optionId = optionId;
        this.setSelected(this.shouldBeSelected());
    }

    @Override
    public void update() {
        super.update();
        Game game = this.getFreeColClient().getGame();
        Player player = this.getFreeColClient().getMyPlayer();
        if (game != null && player != null && !player.getNewModelMessages().isEmpty()) {
            this.enabled = false;
        }
        this.setSelected(this.shouldBeSelected());
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final void setSelected(boolean b) {
        this.selected = b;
    }

    protected boolean shouldBeSelected() {
        if (this.freeColClient.getClientOptions() == null) {
            return false;
        }
        return this.freeColClient.getClientOptions().getBoolean(this.optionId);
    }

    protected void updateOption(boolean value) {
        this.freeColClient.getClientOptions().setBoolean(this.optionId, value);
    }
}

