/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public class LoadAction
extends MapboardAction {
    public static final String id = "loadAction";

    public LoadAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    protected boolean shouldBeEnabled() {
        Unit carrier = this.getGUI().getActiveUnit();
        return super.shouldBeEnabled() && carrier != null && carrier.isCarrier() && carrier.hasSpaceLeft();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Unit unit = this.getGUI().getActiveUnit();
        if (unit == null) {
            return;
        }
        Colony colony = unit.getColony();
        if (colony == null) {
            return;
        }
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        while (goodsIterator.hasNext()) {
            Goods goods = goodsIterator.next();
            if (goods.getAmount() >= 100 || colony.getGoodsCount(goods.getType()) <= 0) continue;
            int amount = Math.min(colony.getGoodsCount(goods.getType()), 100 - goods.getAmount());
            Goods newGoods = new Goods(goods.getGame(), colony, goods.getType(), amount);
            this.igc().loadCargo(newGoods, unit);
        }
    }
}

