/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.resources.ResourceManager;

public abstract class FreeColAction
extends AbstractAction
implements Option<FreeColAction> {
    private static final Logger logger = Logger.getLogger(FreeColAction.class.getName());
    public static final String ACTION_ID = "ACTION_ID";
    public static final String BUTTON_IMAGE = "BUTTON_IMAGE";
    public static final String BUTTON_ROLLOVER_IMAGE = "BUTTON_ROLLOVER_IMAGE";
    public static final String BUTTON_PRESSED_IMAGE = "BUTTON_PRESSED_IMAGE";
    public static final String BUTTON_DISABLED_IMAGE = "BUTTON_DISABLED_IMAGE";
    protected final FreeColClient freeColClient;
    private int orderButtonImageCount = 0;
    private static final String ACCELERATOR_TAG = "accelerator";

    protected FreeColAction(FreeColClient freeColClient, String id) {
        super(Messages.getName(id));
        String acceleratorKey;
        String accelerator;
        this.freeColClient = freeColClient;
        this.putValue(ACTION_ID, id);
        String shortDescription = Messages.getDescription(id);
        if (!shortDescription.equals(Messages.descriptionKey(id))) {
            this.putValue("ShortDescription", shortDescription);
        }
        if (!(accelerator = Messages.message(acceleratorKey = id + ".accelerator")).equals(acceleratorKey)) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected Game getGame() {
        return this.freeColClient.getGame();
    }

    protected GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    protected InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    protected ConnectController getConnectController() {
        return this.freeColClient.getConnectController();
    }

    protected ActionManager getActionManager() {
        return this.freeColClient.getActionManager();
    }

    protected ClientOptions getClientOptions() {
        return this.freeColClient.getClientOptions();
    }

    @Override
    public FreeColAction clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("FreeColAction can not be cloned.");
    }

    public Integer getMnemonic() {
        return (Integer)this.getValue("MnemonicKey");
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic);
    }

    public boolean hasOrderButtons() {
        return this.orderButtonImageCount == 4;
    }

    protected void addImageIcons(String key) {
        Image normal = ResourceManager.getImage("orderButton.normal." + key);
        Image highlighted = ResourceManager.getImage("orderButton.highlighted." + key);
        Image pressed = ResourceManager.getImage("orderButton.pressed." + key);
        Image disabled = ResourceManager.getImage("orderButton.disabled." + key);
        this.orderButtonImageCount = (normal == null ? 0 : 1) + (highlighted == null ? 0 : 1) + (pressed == null ? 0 : 1) + (disabled == null ? 0 : 1);
        if (this.hasOrderButtons()) {
            this.putValue(BUTTON_IMAGE, new ImageIcon(normal));
            this.putValue(BUTTON_ROLLOVER_IMAGE, new ImageIcon(highlighted));
            this.putValue(BUTTON_PRESSED_IMAGE, new ImageIcon(pressed));
            this.putValue(BUTTON_DISABLED_IMAGE, new ImageIcon(disabled));
        } else {
            logger.warning("Missing " + (4 - this.orderButtonImageCount) + " orderButton images for " + this.getId());
        }
    }

    public void update() {
        boolean b = this.shouldBeEnabled();
        if (this.isEnabled() != b) {
            this.setEnabled(b);
        }
    }

    protected boolean shouldBeEnabled() {
        return !this.getGUI().isClientOptionsDialogShowing();
    }

    public final void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public final KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public final String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public final String getId() {
        return (String)this.getValue(ACTION_ID);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public static String getKeyStrokeText(KeyStroke keyStroke) {
        return keyStroke == null ? "" : keyStroke.toString();
    }

    @Override
    public FreeColAction getValue() {
        return this;
    }

    @Override
    public void setValue(FreeColAction value) {
        logger.warning("Calling unsupported method setValue.");
    }

    public MenuKeyListener getMenuKeyListener() {
        return new InnerMenuKeyListener();
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(FreeColAction.getXMLElementTagName());
        xw.writeAttribute("id", this.getId());
        xw.writeAttribute(ACCELERATOR_TAG, FreeColAction.getKeyStrokeText(this.getAccelerator()));
        xw.writeEndElement();
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        String acc = xr.getAttribute(ACCELERATOR_TAG, "");
        this.putValue("AcceleratorKey", acc == null || acc.isEmpty() ? null : KeyStroke.getKeyStroke(acc));
        xr.closeTag(FreeColAction.getXMLElementTagName());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static String getXMLElementTagName() {
        return "action";
    }

    public class InnerMenuKeyListener
    implements MenuKeyListener {
        final int mnemonic;

        public InnerMenuKeyListener() {
            this.mnemonic = (Integer)FreeColAction.this.getValue("MnemonicKey");
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            if (e.getKeyCode() == this.mnemonic) {
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), (String)FreeColAction.this.getValue("Name"), e.getModifiers());
                FreeColAction.this.actionPerformed(ae);
                e.consume();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }
}

