/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class ChangeAction
extends UnitAction {
    public static final String id = "changeAction";

    public ChangeAction(FreeColClient freeColClient) {
        super(freeColClient, id);
        this.update();
    }

    @Override
    public final void update() {
        super.update();
        Unit unit = this.getGUI().getActiveUnit();
        if (unit != null && unit.hasTile()) {
            if (unit.getColony() != null) {
                this.putValue("Name", Messages.message("changeAction.enterColony.name"));
            } else if (unit.isOnCarrier()) {
                this.putValue("Name", Messages.message("changeAction.selectCarrier.name"));
            } else {
                this.putValue("Name", Messages.message("changeAction.nextUnitOnTile.name"));
            }
        }
    }

    @Override
    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.getGUI().getActiveUnit().hasTile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Unit unit = this.getGUI().getActiveUnit();
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.getGUI().showColonyPanel(tile.getColony(), unit);
        } else if (unit.isOnCarrier()) {
            this.getGUI().setActiveUnit(unit.getCarrier());
        } else {
            Unit u;
            Iterator<Unit> unitIterator = tile.getUnitIterator();
            boolean activeUnitFound = false;
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    activeUnitFound = true;
                    continue;
                }
                if (!activeUnitFound || u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getGUI().setActiveUnit(u);
                return;
            }
            unitIterator = tile.getUnitIterator();
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    return;
                }
                if (u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getGUI().setActiveUnit(u);
                return;
            }
        }
    }
}

