/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNIT_LINES_IN_FIRST_MENU = 9;
    public static final int UNIT_LINES_IN_OTHER_MENUS = 19;
    private final FreeColClient freeColClient;
    private final GUI gui;
    private boolean hasAnItem = false;

    public TilePopup(final FreeColClient freeColClient, final Tile tile) {
        super(Messages.message(StringTemplate.template("tile").addAmount("%x%", tile.getX()).addAmount("%y%", tile.getY())));
        Component lastComponent;
        Settlement settlement;
        Tile unitTile;
        boolean owned;
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        final Player player = freeColClient.getMyPlayer();
        final Unit activeUnit = this.gui.getActiveUnit();
        boolean bl = owned = player != null && activeUnit != null && player.owns(activeUnit);
        if (activeUnit != null && owned && (unitTile = activeUnit.getTile()) != null) {
            JMenuItem gotoMenuItem = null;
            if (activeUnit.isOffensiveUnit() && unitTile.isAdjacent(tile) && activeUnit.getMoveType(tile).isAttack()) {
                CombatModel.CombatOdds combatOdds = activeUnit.getGame().getCombatModel().calculateCombatOdds(activeUnit, tile.getDefendingUnit(activeUnit));
                String victoryPercent = tile.hasSettlement() || combatOdds.win == -1.0f ? "??" : Integer.toString((int)(combatOdds.win * 100.0f));
                gotoMenuItem = GUI.localizedMenuItem(StringTemplate.template("attackTileOdds").addName("%chance%", victoryPercent));
            } else if (activeUnit.getSimpleMoveType(unitTile, tile).isLegal()) {
                gotoMenuItem = GUI.localizedMenuItem("gotoThisTile");
            }
            if (gotoMenuItem != null) {
                gotoMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (!freeColClient.currentPlayerIsMyPlayer()) {
                            return;
                        }
                        Tile currTile = activeUnit.getTile();
                        if (currTile == tile) {
                            return;
                        }
                        freeColClient.getInGameController().goToTile(activeUnit, tile);
                        if (activeUnit.getTile() == currTile) {
                            TilePopup.this.gui.getMapViewer().updateCurrentPathForActiveUnit();
                        }
                    }
                });
                this.add(gotoMenuItem);
            }
            final InGameController igc = freeColClient.getInGameController();
            if (unitTile == tile && activeUnit.hasHighSeasMove()) {
                JMenuItem europeMenuItem = GUI.localizedMenuItem(StringTemplate.template("gotoEurope"));
                europeMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (!freeColClient.currentPlayerIsMyPlayer()) {
                            return;
                        }
                        igc.moveTo(activeUnit, player.getEurope());
                    }
                });
                this.add(europeMenuItem);
                this.hasAnItem = true;
            }
            if (unitTile == tile) {
                JMenuItem ji = null;
                if (activeUnit.checkSetState(Unit.UnitState.ACTIVE)) {
                    ji = GUI.localizedMenuItem("activateUnit");
                    ji.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (activeUnit.checkSetState(Unit.UnitState.ACTIVE)) {
                                igc.changeState(activeUnit, Unit.UnitState.ACTIVE);
                            }
                        }
                    });
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.checkSetState(Unit.UnitState.FORTIFYING)) {
                    ji = GUI.localizedMenuItem("fortifyUnit");
                    ji.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (activeUnit.checkSetState(Unit.UnitState.FORTIFYING)) {
                                igc.changeState(activeUnit, Unit.UnitState.FORTIFYING);
                            }
                        }
                    });
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.checkSetState(Unit.UnitState.SKIPPED)) {
                    ji = GUI.localizedMenuItem("skipUnit");
                    ji.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (activeUnit.checkSetState(Unit.UnitState.SKIPPED)) {
                                igc.changeState(activeUnit, Unit.UnitState.SKIPPED);
                            }
                        }
                    });
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.canCarryTreasure() && activeUnit.canCashInTreasureTrain()) {
                    ji = GUI.localizedMenuItem("cashInTreasureTrain.order");
                    ji.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            igc.checkCashInTreasureTrain(activeUnit);
                        }
                    });
                    ji.setEnabled(true);
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.getDestination() != null) {
                    ji = GUI.localizedMenuItem("clearUnitOrders");
                    ji.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            igc.clearOrders(activeUnit);
                        }
                    });
                    this.add(ji);
                    this.hasAnItem = true;
                }
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == player) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if (tile.isExplored()) {
            this.addTile(tile);
        }
        this.addSeparator();
        int lineCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        boolean moreUnits = false;
        List<Unit> units = tile.getUnitList();
        Unit firstUnit = tile.getFirstUnit();
        Collections.sort(units, ReportPanel.getUnitTypeComparator());
        for (Unit currentUnit : units) {
            if (lineCount > maxUnits) {
                JMenu more = GUI.localizedMenu("more");
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                moreUnits = true;
                lineCount = 0;
                maxUnits = 19;
            }
            lineCount += this.addUnit(currentMenu, currentUnit, !currentUnit.isDamaged(), false);
        }
        if (tile.getUnitCount() > 1 && player.owns(firstUnit)) {
            if (moreUnits) {
                this.addSeparator();
            }
            JMenuItem activateAllItem = GUI.localizedMenuItem(StringTemplate.template("activateAllUnits"));
            activateAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Unit lastUnit = null;
                    for (Unit unit : tile.getUnitList()) {
                        freeColClient.getInGameController().clearOrders(unit);
                        lastUnit = unit;
                    }
                    TilePopup.this.gui.setActiveUnit(lastUnit);
                }
            });
            this.add(activateAllItem);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && freeColClient.getFreeColServer() != null) {
            this.addDebugItems(freeColClient, tile);
        }
        if ((lastComponent = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    public void addDebugItems(final FreeColClient freeColClient, final Tile tile) {
        Tile unitTile;
        Unit activeUnit;
        Object menuItem;
        this.addSeparator();
        JMenu changeOwnership = new JMenu("Change ownership");
        changeOwnership.setOpaque(false);
        JMenu transportLists = new JMenu("Transport lists");
        transportLists.setOpaque(false);
        JMenu changeRole = new JMenu("Change role");
        changeRole.setOpaque(false);
        for (final Unit unit : tile.getUnitList()) {
            JMenuItem toMenuItem = new JMenuItem(unit.toString());
            toMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.changeOwnership(freeColClient, unit);
                }
            });
            changeOwnership.add(toMenuItem);
            if (unit.isCarrier()) {
                menuItem = new JMenuItem(unit.toString());
                ((AbstractButton)menuItem).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        DebugUtils.displayMission(freeColClient, unit);
                    }
                });
                transportLists.add((JMenuItem)menuItem);
            }
            if (!unit.isPerson()) continue;
            JMenuItem roleMenuItem = new JMenuItem(unit.toString());
            roleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.changeRole(freeColClient, unit);
                }
            });
            changeRole.add(roleMenuItem);
        }
        if (transportLists.getItemCount() > 0) {
            this.add(transportLists);
        }
        if (tile.getColony() != null) {
            if (changeOwnership.getItemCount() > 0) {
                changeOwnership.addSeparator();
            }
            JMenuItem toMenuItem = new JMenuItem(tile.getColony().toString());
            final Colony colony = tile.getColony();
            toMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.changeOwnership(freeColClient, colony);
                }
            });
            changeOwnership.add(toMenuItem);
            JMenuItem displayColonyPlan = new JMenuItem("Display Colony Plan");
            displayColonyPlan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.displayColonyPlan(freeColClient, colony);
                }
            });
            this.add(displayColonyPlan);
            JMenuItem applyDisaster = new JMenuItem("Apply Disaster");
            applyDisaster.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.applyDisaster(freeColClient, colony);
                }
            });
            this.add(applyDisaster);
        }
        if (tile.getIndianSettlement() != null) {
            JMenuItem displayGoods = new JMenuItem("Examine Settlement");
            final IndianSettlement is = tile.getIndianSettlement();
            displayGoods.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.summarizeSettlement(freeColClient, is);
                }
            });
            this.add(displayGoods);
        }
        if (changeOwnership.getItemCount() > 0) {
            this.add(changeOwnership);
        }
        if (changeRole.getItemCount() > 0) {
            this.add(changeRole);
        }
        if (tile.hasLostCityRumour()) {
            JMenuItem rumourItem = new JMenuItem("Set Lost City Rumour type");
            rumourItem.setOpaque(false);
            rumourItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.setRumourType(freeColClient, tile);
                }
            });
            this.add(rumourItem);
        }
        JMenuItem addu = new JMenuItem("Add unit");
        addu.setOpaque(false);
        addu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DebugUtils.addNewUnitToTile(freeColClient, tile);
            }
        });
        this.add(addu);
        if (!tile.isEmpty()) {
            JMenuItem adda = new JMenuItem("Reset moves");
            adda.setOpaque(false);
            final List<Unit> tileUnits = tile.getUnitList();
            adda.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.resetMoves(freeColClient, tileUnits);
                }
            });
            this.add(adda);
        }
        if ((activeUnit = this.gui.getActiveUnit()) != null && (unitTile = activeUnit.getTile()) != null) {
            menuItem = new JMenuItem("Show search");
            ((AbstractButton)menuItem).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!freeColClient.currentPlayerIsMyPlayer()) {
                        return;
                    }
                    Tile currTile = activeUnit.getTile();
                    if (currTile == tile) {
                        return;
                    }
                    Map map = activeUnit.getGame().getMap();
                    LogBuilder lb = new LogBuilder(512);
                    PathNode path = map.findPath(activeUnit, activeUnit.getTile(), tile, activeUnit.getCarrier(), null, lb);
                    TilePopup.this.gui.showInformationMessage(lb.toString());
                    TilePopup.this.gui.getMapViewer().setCurrentPath(path);
                    TilePopup.this.gui.refresh();
                }
            });
            this.add((JMenuItem)menuItem);
        }
        for (Unit u : tile.getUnitList()) {
            if (!u.canCarryGoods() || !u.hasSpaceLeft()) continue;
            JMenuItem addg = new JMenuItem("Add goods");
            addg.setOpaque(false);
            final Unit unit = u;
            addg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DebugUtils.addUnitGoods(freeColClient, unit);
                }
            });
            this.add(addg);
            break;
        }
        JMenuItem dumpItem = new JMenuItem("Dump tile");
        dumpItem.setOpaque(false);
        dumpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DebugUtils.dumpTile(freeColClient, tile);
            }
        });
        this.add(dumpItem);
    }

    private int addUnit(Container menu, final Unit unit, boolean enabled, boolean indent) {
        TradeRoute tradeRoute = unit.getTradeRoute();
        StringTemplate occ = unit.getState() == Unit.UnitState.ACTIVE && unit.getMovesLeft() == 0 ? (unit.isDamaged() ? StringTemplate.label(": ").add("model.unit.occupation.underRepair").add(Integer.toString(unit.getTurnsForRepair())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").addName(tradeRoute.getName()) : StringTemplate.key("model.unit.occupation.activeNoMovesLeft"))) : (unit.getState() == Unit.UnitState.IMPROVING && unit.getWorkImprovement() != null ? StringTemplate.label(": ").add(unit.getWorkImprovement().getType() + ".occupationString").add(Integer.toString(unit.getWorkTurnsLeft())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").add(tradeRoute.getName()) : (unit.getDestination() != null ? StringTemplate.key("model.unit.occupation.goingSomewhere") : StringTemplate.key("model.unit.occupation." + unit.getState().toString().toLowerCase()))));
        String text = (indent ? "    " : "") + unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + Messages.message(occ) + ")";
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.setActiveUnit(unit);
            }
        });
        int lineCount = 1;
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
        for (Unit unit2 : unit.getUnitList()) {
            lineCount += this.addUnit(menu, unit2, true, true);
        }
        boolean hasGoods = false;
        for (Goods goods : unit.getGoodsList()) {
            text = (indent ? "         " : "     ") + Messages.message(goods.getLabel(true));
            menuItem = new JMenuItem(text);
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            ++lineCount;
            hasGoods = true;
        }
        if (hasGoods) {
            JMenuItem jMenuItem = GUI.localizedMenuItem("dumpCargo");
            jMenuItem.setAction(new UnloadAction(this.freeColClient, unit));
            menu.add(jMenuItem);
            ++lineCount;
        }
        this.hasAnItem = true;
        return lineCount;
    }

    private void addColony(final Colony colony) {
        StringTemplate name = colony.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = GUI.localizedMenuItem(name);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showColonyPanel(colony, null);
            }
        });
        this.add(menuItem);
        menuItem = GUI.localizedMenuItem("rename");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TilePopup.this.freeColClient.getInGameController().rename(colony);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(final IndianSettlement settlement) {
        StringTemplate name = settlement.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = GUI.localizedMenuItem(name);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showIndianSettlementPanel(settlement);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(final Tile tile) {
        JMenuItem menuItem = new JMenuItem(Messages.getName(tile));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showTilePanel(tile);
            }
        });
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.getComponentCount() > 0;
    }
}

