/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class TerrainCursor
implements ActionListener {
    public static final int OFF = 0;
    public static final int ON = 1;
    private int canvasX;
    private int canvasY;
    private final Timer blinkTimer;
    private boolean active = true;
    private final EventListenerList listenerList;

    public TerrainCursor() {
        int blinkDelay = 500;
        this.blinkTimer = new Timer(500, this);
        this.listenerList = new EventListenerList();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean newState) {
        this.active = newState;
    }

    public void startBlinking() {
        if (!this.blinkTimer.isRunning()) {
            this.blinkTimer.start();
        }
    }

    public void stopBlinking() {
        if (this.blinkTimer.isRunning()) {
            this.blinkTimer.stop();
        }
    }

    public void setCanvasPos(int x, int y) {
        this.canvasX = x;
        this.canvasY = y;
    }

    public int getCanvasX() {
        return this.canvasX;
    }

    public int getCanvasY() {
        return this.canvasY;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionEvent(ActionEvent event) {
        for (ActionListener al : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            al.actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.active = !this.active;
        int eventId = this.active ? 1 : 0;
        ActionEvent blinkEvent = new ActionEvent(this, eventId, "blink");
        this.fireActionEvent(blinkEvent);
    }
}

