/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.common.model.Map;

public class ScrollThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ScrollThread.class.getName());
    private static final int SCROLL_DELAY = 100;
    private final MapViewer mapViewer;
    private Map.Direction direction = null;

    public ScrollThread(MapViewer mapViewer) {
        super("FreeColClient:Mouse scroller");
        this.mapViewer = mapViewer;
    }

    public void setDirection(Map.Direction d) {
        this.direction = d;
    }

    @Override
    public void run() {
        while (this.direction != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!ScrollThread.this.mapViewer.scrollMap(ScrollThread.this.direction)) {
                            ScrollThread.this.direction = null;
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                logger.log(Level.WARNING, "Scroll thread caught error", e);
                break;
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                ScrollThread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

