/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;

public final class ImageLibrary {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final String CROSS = "\u271d";
    public static final String UNIT_SELECT = "unitSelect.image";
    public static final String DELETE = "delete.image";
    public static final String PLOWED = "model.improvement.plow.image";
    public static final String TILE_TAKEN = "tileTaken.image";
    public static final String TILE_OWNED_BY_INDIANS = "nativeLand.image";
    public static final String LOST_CITY_RUMOUR = "lostCityRumour.image";
    public static final String DARKNESS = "halo.dark.image";
    private final float scalingFactor;
    private final Map<String, Integer> imageCounts = new HashMap<String, Integer>();

    public ImageLibrary() {
        this(1.0f);
    }

    public ImageLibrary(float scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    private Image createChip(String text, Color border, Color background, Color foreground) {
        Font font = this.getScaledFont("SimpleFont", 1, 12.0f);
        BufferedImage bi = new BufferedImage(100, 100, 2);
        Graphics2D g2 = bi.createGraphics();
        TextLayout label = new TextLayout(text, font, g2.getFontRenderContext());
        float padding = 6.0f * this.scalingFactor;
        int width = (int)(label.getBounds().getWidth() + (double)padding);
        int height = (int)(label.getAscent() + label.getDescent() + padding);
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        g2.setColor(foreground);
        label.draw(g2, (float)((double)(padding / 2.0f) - label.getBounds().getX()), label.getAscent() + padding / 2.0f);
        g2.dispose();
        return bi.getSubimage(0, 0, width, height);
    }

    private Image createFilledChip(String text, Color border, Color background, double amount, Color fill, Color foreground) {
        Font font = this.getScaledFont("SimpleFont", 1, 12.0f);
        BufferedImage bi = new BufferedImage(100, 100, 2);
        Graphics2D g2 = bi.createGraphics();
        TextLayout label = new TextLayout(text, font, g2.getFontRenderContext());
        float padding = 6.0f * this.scalingFactor;
        int width = (int)(label.getBounds().getWidth() + (double)padding);
        int height = (int)(label.getAscent() + label.getDescent() + padding);
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        if (amount > 0.0 && amount <= 1.0) {
            g2.setColor(fill);
            g2.fillRect(1, 1, width - 2, (int)((double)(height - 2) * amount));
        }
        g2.setColor(foreground);
        label.draw(g2, (float)((double)(padding / 2.0f) - label.getBounds().getX()), label.getAscent() + padding / 2.0f);
        g2.dispose();
        return bi.getSubimage(0, 0, width, height);
    }

    public static BufferedImage fadeImage(Image img, float fade, float target) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        float offset = target * (1.0f - fade);
        float[] scales = new float[]{fade, fade, fade, 1.0f};
        float[] offsets = new float[]{offset, offset, offset, 0.0f};
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(bi, rop, 0, 0);
        g.dispose();
        return bi;
    }

    public static Color getForegroundColor(Color background) {
        return background == null || (double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 >= 126.0 ? Color.BLACK : Color.WHITE;
    }

    public static Color getStringBorderColor(Color color) {
        return (double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0 ? Color.WHITE : Color.BLACK;
    }

    public static void drawTiledImage(String resource, Graphics g, JComponent c, Insets insets) {
        int dy;
        int dx;
        int ymin;
        int xmin;
        int width = c.getWidth();
        int height = c.getHeight();
        Image image = ResourceManager.getImage(resource);
        if (insets == null) {
            xmin = 0;
            ymin = 0;
        } else {
            xmin = insets.left;
            ymin = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (image != null && (dx = image.getWidth(null)) > 0 && (dy = image.getHeight(null)) > 0) {
            int xmax = xmin + width;
            int ymax = ymin + height;
            for (int x = xmin; x < xmax; x += dx) {
                for (int y = ymin; y < ymax; y += dy) {
                    g.drawImage(image, x, y, null);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(xmin, ymin, width, height);
        }
    }

    public Image getAlarmChip(IndianSettlement is, Player player) {
        if (player == null || !is.hasContacted(player)) {
            return null;
        }
        Color ownerColor = is.getOwner().getNationColor();
        Player enemy = is.getMostHated();
        Color enemyColor = enemy == null ? Nation.UNKNOWN_NATION_COLOR : enemy.getNationColor();
        int amount = 4;
        if (enemy == null) {
            amount = 0;
        } else if (player == enemy) {
            Tension alarm = is.getAlarm(enemy);
            int n = amount = alarm == null ? 4 : alarm.getLevel().ordinal();
            if (amount == 0) {
                amount = 1;
            }
        }
        Color foreground = ImageLibrary.getForegroundColor(enemyColor);
        String text = Messages.message(is.worthScouting(player) ? "indianSettlement.contacted" : "indianSettlement.scouted");
        String key = "dynamic.alarm." + text + "." + ownerColor.getRGB() + "." + amount + "." + enemyColor.getRGB();
        Image img = ResourceManager.getImage(key);
        if (img == null) {
            img = this.createFilledChip(text, Color.BLACK, ownerColor, (double)amount / 4.0, enemyColor, foreground);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    private static boolean isEven(int x, int y) {
        return y % 8 <= 2 || (x + y) % 2 == 0;
    }

    public Image getBeachCornerImage(int index, int x, int y) {
        return ResourceManager.getImage("model.tile.beach.corner" + index + (ImageLibrary.isEven(x, y) ? "_even" : "_odd"), this.scalingFactor);
    }

    public Image getBeachEdgeImage(int index, int x, int y) {
        return ResourceManager.getImage("model.tile.beach.edge" + index + (ImageLibrary.isEven(x, y) ? "_even" : "_odd"), this.scalingFactor);
    }

    public Image getBonusImage(ResourceType type) {
        return ImageLibrary.getBonusImage(type, this.scalingFactor);
    }

    public static Image getBonusImage(ResourceType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public Image getBonusImage(Tile tile) {
        return tile.hasResource() ? this.getBonusImage(tile.getTileItemContainer().getResource().getType()) : null;
    }

    public ImageIcon getBonusImageIcon(ResourceType type) {
        return new ImageIcon(this.getBonusImage(type));
    }

    public Image getBorderImage(TileType type, Map.Direction direction, int x, int y) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage(key + ".border_" + (Object)((Object)direction) + (ImageLibrary.isEven(x, y) ? "_even" : "_odd") + ".image", this.scalingFactor);
    }

    public Image getCoatOfArmsImage(Nation nation) {
        return ImageLibrary.getCoatOfArmsImage(nation, this.scalingFactor);
    }

    public static Image getCoatOfArmsImage(Nation nation, double scale) {
        return ResourceManager.getImage(nation.getId() + ".image", scale);
    }

    public static ImageIcon getCoatOfArmsImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".image");
    }

    public Image getCompoundTerrainImage(TileType type, double scale) {
        Image forestImage;
        Image terrainImage = ImageLibrary.getTerrainImage(type, 0, 0, scale);
        Image overlayImage = this.getOverlayImage(type, type.getId(), scale);
        Image image = forestImage = type.isForested() ? ImageLibrary.getForestImage(type, scale) : null;
        if (overlayImage == null && forestImage == null) {
            return terrainImage;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int width = terrainImage.getWidth(null);
        int height = terrainImage.getHeight(null);
        if (overlayImage != null) {
            height = Math.max(height, overlayImage.getHeight(null));
        }
        if (forestImage != null) {
            height = Math.max(height, forestImage.getHeight(null));
        }
        BufferedImage compositeImage = gc.createCompatibleImage(width, height, 3);
        Graphics2D g = compositeImage.createGraphics();
        g.drawImage(terrainImage, 0, height - terrainImage.getHeight(null), null);
        if (overlayImage != null) {
            g.drawImage(overlayImage, 0, height - overlayImage.getHeight(null), null);
        }
        if (forestImage != null) {
            g.drawImage(forestImage, 0, height - forestImage.getHeight(null), null);
        }
        g.dispose();
        return compositeImage;
    }

    public int getCompoundTerrainImageHeight(TileType type) {
        Image terrain = this.getTerrainImage(type, 0, 0);
        int height = terrain.getHeight(null);
        if (type != null) {
            Image overlayImage = this.getOverlayImage(type, type.getId(), this.scalingFactor);
            if (overlayImage != null) {
                height = Math.max(height, overlayImage.getHeight(null));
            }
            if (type.isForested()) {
                height = Math.max(height, this.getForestImage(type).getHeight(null));
            }
        }
        return height;
    }

    public Image getForestImage(TileType type) {
        return ImageLibrary.getForestImage(type, this.scalingFactor);
    }

    public Image getForestImage(TileType type, TileImprovementStyle riverStyle) {
        return ImageLibrary.getForestImage(type, riverStyle, this.scalingFactor);
    }

    public static Image getForestImage(TileType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".forest", scale);
    }

    public static Image getForestImage(TileType type, TileImprovementStyle riverStyle, double scale) {
        if (riverStyle == null) {
            return ResourceManager.getImage(type.getId() + ".forest", scale);
        }
        return ResourceManager.getImage(type.getId() + ".forest" + riverStyle.getMask(), scale);
    }

    public static Image getFoundingFatherImage(FoundingFather father) {
        return ResourceManager.getImage(father.getId() + ".image");
    }

    public Image getGoodsImage(GoodsType goodsType) {
        return ImageLibrary.getGoodsImage(goodsType, this.scalingFactor);
    }

    public static Image getGoodsImage(GoodsType goodsType, double scale) {
        return ResourceManager.getImage(goodsType.getId() + ".image", scale);
    }

    public static ImageIcon getGoodsImageIcon(GoodsType goodsType) {
        return ResourceManager.getImageIcon(goodsType.getId() + ".image");
    }

    public Image getBuildingImage(Building building) {
        return ImageLibrary.getBuildingImage(building.getType(), building.getOwner(), this.scalingFactor);
    }

    public static Image getBuildingImage(Building building, double scale) {
        return ImageLibrary.getBuildingImage(building.getType(), building.getOwner(), scale);
    }

    public static Image getBuildingImage(BuildingType buildingType, Player player, double scale) {
        String key = buildingType.getId() + "." + player.getNationNameKey() + ".image";
        if (!ResourceManager.hasResource(key)) {
            key = buildingType.getId() + ".image";
        }
        return ResourceManager.getImage(key, scale);
    }

    public Image getIndianSettlementChip(IndianSettlement is, String text) {
        Color background = is.getOwner().getNationColor();
        String key = "dynamic.indianSettlement." + text + "." + Integer.toHexString(background.getRGB());
        Image img = ResourceManager.getImage(key);
        if (img == null) {
            img = this.createChip(text, Color.BLACK, background, ImageLibrary.getForegroundColor(background));
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public Image getImage(FreeColGameObjectType type) {
        return ResourceManager.getImage(type.getId() + ".image", this.scalingFactor);
    }

    public static Image getImage(FreeColGameObjectType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        Image image = null;
        if (display instanceof Goods) {
            display = ((Goods)display).getType();
        }
        if (display == null) {
            return new ImageIcon();
        }
        if (display instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)display;
            try {
                image = this.getGoodsImage(goodsType);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for goods " + goodsType, e);
            }
        } else if (display instanceof Unit) {
            Unit unit = (Unit)display;
            try {
                image = this.getUnitImageIcon(unit).getImage();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for unit " + unit, e);
            }
        } else if (display instanceof UnitType) {
            UnitType unitType = (UnitType)display;
            try {
                image = this.getUnitImageIcon(unitType).getImage();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for unit " + unitType, e);
            }
        } else if (display instanceof Settlement) {
            Settlement settlement = (Settlement)display;
            try {
                image = this.getSettlementImage(settlement);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for settlement " + settlement.getId(), e);
            }
        } else if (display instanceof LostCityRumour) {
            try {
                image = this.getMiscImage(LOST_CITY_RUMOUR);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for LCR", e);
            }
        } else if (display instanceof Player) {
            image = this.getCoatOfArmsImage(((Player)display).getNation());
        }
        if (image != null && small) {
            int width = image.getWidth(null) / 3 * 2;
            int height = image.getHeight(null) / 3 * 2;
            return new ImageIcon(image.getScaledInstance(width, height, 4));
        }
        return image == null ? null : new ImageIcon(image);
    }

    public Image getMiscImage(String id) {
        return ImageLibrary.getMiscImage(id, this.scalingFactor);
    }

    public static Image getMiscImage(String id, double scale) {
        return ResourceManager.getImage(id, scale);
    }

    public ImageIcon getMiscImageIcon(String id) {
        return new ImageIcon(this.getMiscImage(id));
    }

    public Image getMissionChip(Player owner, boolean expert) {
        Color background = owner.getNationColor();
        String key = "dynamic.mission." + (expert ? "expert" : "normal") + "." + Integer.toHexString(background.getRGB());
        Image img = ResourceManager.getImage(key, 1.0);
        if (img == null) {
            Color foreground = ResourceManager.getColor("mission." + (expert ? "expert" : "normal") + ".foreground.color");
            if (foreground == null) {
                foreground = expert ? Color.BLACK : Color.GRAY;
            }
            img = this.createChip(CROSS, Color.BLACK, background, foreground);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public static Image getMonarchImage(Nation nation) {
        return ResourceManager.getImage(nation.getId() + ".monarch.image");
    }

    public static ImageIcon getMonarchImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".monarch.image");
    }

    public Image getOccupationIndicatorChip(Unit unit, String text) {
        Color backgroundColor = unit.getOwner().getNationColor();
        Color foregroundColor = unit.getState() == Unit.UnitState.FORTIFIED ? Color.GRAY : ImageLibrary.getForegroundColor(backgroundColor);
        String key = "dynamic.occupationIndicator." + text + "." + Integer.toHexString(backgroundColor.getRGB());
        Image img = ResourceManager.getImage(key, this.scalingFactor);
        if (img == null) {
            img = this.createChip(text, Color.BLACK, backgroundColor, foregroundColor);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public Image getOverlayImage(Tile tile) {
        return this.getOverlayImage(tile.getType(), tile.getId(), this.scalingFactor);
    }

    public Image getOverlayImage(TileType type, String id, double scale) {
        return this.getRandomizedImage(type.getId() + ".overlay", id, scale);
    }

    private Image getRandomizedImage(String prefix, String id, double scale) {
        String key;
        int count = this.getImageCount(prefix);
        if (count > 0 && ResourceManager.hasResource(key = prefix + Math.abs(id.hashCode() % count) + ".image")) {
            return ResourceManager.getImage(key, scale);
        }
        return null;
    }

    private int getImageCount(String prefix) {
        if (!this.imageCounts.containsKey(prefix)) {
            this.imageCounts.put(prefix, ResourceManager.getKeys(prefix).size());
        }
        return this.imageCounts.get(prefix);
    }

    public static Image getPathImage(PathType pt) {
        return pt == null ? null : ResourceManager.getImage(pt.getImageKey());
    }

    public static Image getPathImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathImage(PathType.getPathType(u));
    }

    public static Image getPathNextTurnImage(PathType pt) {
        return pt == null ? null : ResourceManager.getImage(pt.getNextTurnImageKey());
    }

    public static Image getPathNextTurnImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathNextTurnImage(PathType.getPathType(u));
    }

    public Image getRiverImage(TileImprovementStyle style) {
        return ImageLibrary.getRiverImage(style, (double)this.scalingFactor);
    }

    public static Image getRiverImage(TileImprovementStyle style, double scale) {
        return ImageLibrary.getRiverImage(style.getString(), scale);
    }

    public static Image getRiverImage(String style, double scale) {
        return ResourceManager.getImage("model.tile.river" + style, scale);
    }

    public Image getRiverMouthImage(Map.Direction direction, int magnitude, int x, int y) {
        String key = "model.tile.delta_" + (Object)((Object)direction) + (magnitude == 1 ? "_small" : "_large");
        return ResourceManager.getImage(key, this.scalingFactor);
    }

    public static ImageIcon getScaledBonusImageIcon(ResourceType type, float scale) {
        return new ImageIcon(ImageLibrary.getBonusImage(type, scale));
    }

    public static ImageIcon getScaledGoodsImageIcon(GoodsType type, double scale) {
        return new ImageIcon(ImageLibrary.getGoodsImage(type, scale));
    }

    public Font getScaledFont(String resource, float size) {
        return ResourceManager.getFont(resource, (float)Math.rint(size * this.scalingFactor));
    }

    public Font getScaledFont(String resource, int style, float size) {
        return ResourceManager.getFont(resource, style, (float)Math.rint(size * this.scalingFactor));
    }

    public Image getSettlementImage(Settlement settlement) {
        return ImageLibrary.getSettlementImage(settlement, (double)this.scalingFactor);
    }

    public static Image getSettlementImage(Settlement settlement, double scale) {
        return ResourceManager.getImage(settlement.getImageKey(), scale);
    }

    public Image getSettlementImage(SettlementType settlementType) {
        return ImageLibrary.getSettlementImage(settlementType, (double)this.scalingFactor);
    }

    public static Image getSettlementImage(SettlementType settlementType, double scale) {
        return ResourceManager.getImage(settlementType.getId() + ".image", scale);
    }

    public static Image getStringImage(Graphics g, String text, Color color, Font font) {
        String key;
        Image img;
        if (color == null) {
            logger.warning("createStringImage called with color null");
            color = Color.WHITE;
        }
        if ((img = ResourceManager.getImage(key = "dynamic.stringImage." + text + "." + font.getFontName().replace(' ', '-') + "." + Integer.toString(font.getSize()) + "." + Integer.toHexString(color.getRGB()))) == null) {
            FontMetrics fm = g.getFontMetrics(font);
            BufferedImage bi = new BufferedImage(fm.stringWidth(text) + 4, fm.getMaxAscent() + fm.getMaxDescent(), 2);
            Graphics2D big = bi.createGraphics();
            big.setColor(color);
            big.setFont(font);
            big.drawString(text, 2, fm.getMaxAscent());
            int textColor = color.getRGB();
            int borderColor = ImageLibrary.getStringBorderColor(color).getRGB();
            for (int biX = 0; biX < bi.getWidth(); ++biX) {
                for (int biY = 0; biY < bi.getHeight(); ++biY) {
                    int r = bi.getRGB(biX, biY);
                    if (r == textColor) continue;
                    for (int cX = -1; cX <= 1; ++cX) {
                        for (int cY = -1; cY <= 1; ++cY) {
                            if (biX + cX < 0 || biY + cY < 0 || biX + cX >= bi.getWidth() || biY + cY >= bi.getHeight() || bi.getRGB(biX + cX, biY + cY) != textColor) continue;
                            bi.setRGB(biX, biY, borderColor);
                        }
                    }
                }
            }
            ResourceManager.addGameMapping(key, new ImageResource(bi));
            img = ResourceManager.getImage(key);
        }
        return img;
    }

    public Image getTerrainImage(TileType type, int x, int y) {
        return ImageLibrary.getTerrainImage(type, x, y, this.scalingFactor);
    }

    public static Image getTerrainImage(TileType type, int x, int y, double scale) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage(key + ".center" + (ImageLibrary.isEven(x, y) ? "0" : "1") + ".image", scale);
    }

    public ImageIcon getUnitImageIcon(Unit unit) {
        return ImageLibrary.getUnitImageIcon(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale) {
        return ImageLibrary.getUnitImageIcon(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), grayscale, this.scalingFactor);
    }

    public static ImageIcon getUnitImageIcon(Unit unit, boolean grayscale, double scale) {
        return ImageLibrary.getUnitImageIcon(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), grayscale, scale);
    }

    public static ImageIcon getUnitImageIcon(Unit unit, double scale) {
        return ImageLibrary.getUnitImageIcon(unit.getType(), unit.getRole().getId(), unit.hasNativeEthnicity(), false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType) {
        return ImageLibrary.getUnitImageIcon(unitType, unitType.getDisplayRoleId(), false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale) {
        return ImageLibrary.getUnitImageIcon(unitType, unitType.getDisplayRoleId(), false, grayscale, this.scalingFactor);
    }

    public static ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale, double scale) {
        return ImageLibrary.getUnitImageIcon(unitType, unitType.getDisplayRoleId(), false, grayscale, scale);
    }

    public static ImageIcon getUnitImageIcon(UnitType unitType, double scale) {
        return ImageLibrary.getUnitImageIcon(unitType, unitType.getDisplayRoleId(), false, false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, String roleId) {
        return ImageLibrary.getUnitImageIcon(unitType, roleId, false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, String roleId, boolean grayscale) {
        return ImageLibrary.getUnitImageIcon(unitType, roleId, false, grayscale, this.scalingFactor);
    }

    public static ImageIcon getUnitImageIcon(UnitType unitType, String roleId, boolean grayscale, double scale) {
        return ImageLibrary.getUnitImageIcon(unitType, roleId, false, grayscale, scale);
    }

    public static ImageIcon getUnitImageIcon(UnitType unitType, String roleId, double scale) {
        return ImageLibrary.getUnitImageIcon(unitType, roleId, false, false, scale);
    }

    public static ImageIcon getUnitImageIcon(UnitType unitType, String roleId, boolean nativeEthnicity, boolean grayscale, double scale) {
        Image image;
        if (unitType.hasAbility("model.ability.bornInIndianSettlement")) {
            nativeEthnicity = false;
        }
        String roleQual = Role.isDefaultRoleId(roleId) ? "" : "." + Role.getRoleSuffix(roleId);
        String key = unitType.getId() + roleQual + (nativeEthnicity ? ".native" : "") + ".image";
        if (!ResourceManager.hasResource(key) && nativeEthnicity) {
            key = unitType.getId() + roleQual + ".image";
        }
        Image image2 = image = grayscale ? ResourceManager.getGrayscaleImage(key, scale) : ResourceManager.getImage(key, scale);
        if (image == null) {
            String complain = "No image icon for: unitType=" + unitType.getId() + " role=" + roleId + " native=" + nativeEthnicity + " gray=" + grayscale + " scale=" + scale + " roleQual=" + roleQual + " key=" + key;
            logger.warning(complain);
            return null;
        }
        return new ImageIcon(image);
    }

    public static enum PathType {
        NAVAL,
        WAGON,
        HORSE,
        FOOT;


        public String getImageKey() {
            return "path." + this.toString().toLowerCase(Locale.US) + ".image";
        }

        public String getNextTurnImageKey() {
            return "path." + this.toString().toLowerCase(Locale.US) + ".nextTurn.image";
        }

        public static PathType getPathType(Unit u) {
            return u == null ? FOOT : (u.isNaval() ? NAVAL : (u.isMounted() ? HORSE : (u.isPerson() ? FOOT : WAGON)));
        }
    }
}

