/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

public class GrayLayer
extends Component {
    private static final Color MASK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final int FONT_SIZE_DECREMENT = 2;
    private static final int MAX_TEXT_WIDTH = 640;
    private final FreeColClient freeColClient;
    private final ImageLibrary imageLibrary;
    private Player player;

    public GrayLayer(FreeColClient freeColClient, ImageLibrary imageLibrary) {
        this.freeColClient = freeColClient;
        this.imageLibrary = imageLibrary;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle textBounds;
        Rectangle clipArea = g.getClipBounds();
        if (clipArea == null) {
            clipArea = this.getBounds();
            clipArea.y = 0;
            clipArea.x = 0;
        }
        if (clipArea.isEmpty()) {
            return;
        }
        if (!this.freeColClient.getClientOptions().getBoolean("model.option.disableGrayLayer")) {
            g.setColor(MASK_COLOR);
            g.fillRect(clipArea.x, clipArea.y, clipArea.width, clipArea.height);
        }
        ImageIcon coatOfArmsIcon = null;
        String message = null;
        Color colour = null;
        if (this.player == null) {
            message = Messages.message(this.freeColClient.getGame().getTurn().getLabel());
            colour = Color.WHITE;
        } else {
            coatOfArmsIcon = ImageLibrary.getCoatOfArmsImageIcon(this.player.getNation());
            StringTemplate t = StringTemplate.template("waitingFor").addStringTemplate("%nation%", this.player.getNationName());
            message = Messages.message(t);
            colour = this.player.getNationColor();
        }
        Font nameFont = this.getFont();
        FontMetrics nameFontMetrics = this.getFontMetrics(nameFont);
        int fontSize = 18;
        int maxWidth = Math.min(640, this.getSize().width);
        do {
            nameFont = nameFont.deriveFont(1, fontSize);
            nameFontMetrics = this.getFontMetrics(nameFont);
            textBounds = nameFontMetrics.getStringBounds(message, g).getBounds();
            fontSize -= 2;
        } while (textBounds.width > maxWidth);
        Dimension size = this.getSize();
        textBounds.x = (size.width - textBounds.width) / 2;
        textBounds.y = size.height - 128 - 2 * textBounds.height;
        if (textBounds.intersects(clipArea)) {
            g.setFont(nameFont);
            g.setColor(colour);
            g.drawString(message, textBounds.x, textBounds.y + textBounds.height);
        }
        if (coatOfArmsIcon != null) {
            Rectangle iconBounds = new Rectangle();
            iconBounds.width = coatOfArmsIcon.getIconWidth();
            iconBounds.height = coatOfArmsIcon.getIconHeight();
            iconBounds.x = (size.width - iconBounds.width) / 2;
            iconBounds.y = textBounds.y + 3 * textBounds.height / 2;
            if (iconBounds.intersects(clipArea)) {
                coatOfArmsIcon.paintIcon(this, g, iconBounds.x, iconBounds.y);
            }
        }
    }

    public void setPlayer(Player player) {
        if (this.player == player) {
            return;
        }
        this.player = player;
        this.repaint();
    }
}

