/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.FreeColFrame;
import net.sf.freecol.client.gui.FullScreenFrame;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.WindowedFrame;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.menu.InGameMenuBar;
import net.sf.freecol.client.gui.menu.MapEditorMenuBar;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;
import net.sf.freecol.client.gui.panel.CornerMapControls;
import net.sf.freecol.client.gui.panel.DialogHandler;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.client.gui.panel.TradeRoutePanel;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;

public class GUI {
    private static final Logger logger = Logger.getLogger(GUI.class.getName());
    private static final String[] levels = new String[]{"low", "normal", "high"};
    private static final int DEFAULT_TEXT_COLUMNS = 20;
    private static final int DEFAULT_SCREEN_INSET_WIDTH = 0;
    private static final int DEFAULT_SCREEN_INSET_HEIGHT = 32;
    private static final int DEFAULT_WINDOW_INSET_WIDTH = 16;
    private static final int DEFAULT_WINDOW_INSET_HEIGHT = 39;
    public static final int MOVE_UNITS_MODE = 0;
    public static final int VIEW_TERRAIN_MODE = 1;
    public static final Color BORDER_COLOR = ResourceManager.getColor("lookAndFeel.border.color");
    public static final Color LINK_COLOR = ResourceManager.getColor("lookAndFeel.link.color");
    public static final Color WARNING_COLOR = ResourceManager.getColor("lookAndFeel.warning.color");
    public static final Border TRIVIAL_LINE_BORDER = BorderFactory.createLineBorder(BORDER_COLOR);
    public static final Border BEVEL_BORDER = BorderFactory.createBevelBorder(1);
    public static final Border COLOR_CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 10, 5, 10, ResourceManager.getImageIcon("background.ColorCellRenderer")), BorderFactory.createLineBorder(BORDER_COLOR));
    public static final Border DIALOG_BORDER = BorderFactory.createCompoundBorder(TRIVIAL_LINE_BORDER, GUI.blankBorder(10, 20, 10, 20));
    public static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    public static final Border PRODUCTION_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOR), GUI.blankBorder(2, 2, 2, 2));
    public static final Border PROGRESS_BORDER = BorderFactory.createLineBorder(new Color(122, 109, 82));
    public static final Border SIMPLE_LINE_BORDER = BorderFactory.createCompoundBorder(TRIVIAL_LINE_BORDER, GUI.blankBorder(5, 5, 5, 5));
    public static final Border TOPCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border CELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border LEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border TOPLEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Font DEFAULT_FONT = ResourceManager.getFont("NormalFont", 13.0f);
    public static final Font DEFAULT_BOLD_FONT = DEFAULT_FONT.deriveFont(1);
    public static final Font LESS_TINY_DEFAULT_FONT = ResourceManager.getFont("NormalFont", 14.0f);
    public static final Font TINY_SIMPLE_FONT = ResourceManager.getFont("SimpleFont", 1, 12.0f);
    public static final Font SMALLER_SIMPLE_FONT = ResourceManager.getFont("SimpleFont", 1, 16.0f);
    public static final Font SMALL_SIMPLE_FONT = ResourceManager.getFont("SimpleFont", 1, 24.0f);
    public static final Font SMALL_HEADER_FONT = ResourceManager.getFont("HeaderFont", 24.0f);
    public static final Font MEDIUM_HEADER_FONT = ResourceManager.getFont("HeaderFont", 36.0f);
    public static final Font BIG_HEADER_FONT = ResourceManager.getFont("HeaderFont", 48.0f);
    public static final Insets EMPTY_MARGIN = new Insets(0, 0, 0, 0);
    public static final StyleContext STYLE_CONTEXT = new StyleContext();
    private final FreeColClient freeColClient;
    private Canvas canvas;
    private MapViewer colonyTileGUI;
    private FreeColFrame frame;
    private final ImageLibrary imageLibrary;
    private MapViewer mapViewer;
    private MapControls mapControls;
    private SoundPlayer soundPlayer;
    private JWindow splash;
    private boolean windowed;
    private Rectangle windowBounds;

    public GUI(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.imageLibrary = new ImageLibrary();
    }

    private InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public FreeColFrame getFrame() {
        return this.frame;
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public MapViewer getMapViewer() {
        return this.mapViewer;
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void setWindowed(boolean windowed) {
        this.windowed = windowed;
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public void activateGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null || this.mapViewer == null) {
            return;
        }
        if (this.mapViewer.isGotoStarted()) {
            this.mapViewer.stopGoto();
        } else {
            Tile tile;
            this.mapViewer.startGoto();
            Point pt = this.canvas.getMousePosition();
            if (pt != null && (tile = this.mapViewer.convertToMapTile(pt.x, pt.y)) != null && unit.getTile() != tile) {
                this.mapViewer.setGotoPath(unit.findPath(tile));
            }
        }
    }

    public void clearGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null || this.mapViewer == null) {
            return;
        }
        this.mapViewer.stopGoto();
        this.refresh();
    }

    public void changeWindowedMode(boolean windowed) {
        GraphicsDevice gd;
        if (this.frame != null) {
            GraphicsConfiguration GraphicsConf = this.frame.getGraphicsConfiguration();
            gd = GraphicsConf.getDevice();
        } else {
            gd = GUI.getGoodGraphicsDevice();
        }
        JMenuBar menuBar = null;
        if (this.frame != null) {
            menuBar = this.frame.getJMenuBar();
            if (this.frame instanceof WindowedFrame) {
                this.windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.setWindowed(windowed);
        this.frame = windowed ? new WindowedFrame(this.freeColClient, gd) : new FullScreenFrame(this.freeColClient, gd);
        this.frame.setJMenuBar(menuBar);
        this.frame.setCanvas(this.canvas);
        this.frame.updateBounds(this.getWindowBounds());
        if (windowed) {
            this.frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    logger.info("Window size changes to " + GUI.this.canvas.getSize());
                    ResourceManager.preload();
                }
            });
        }
        this.mapViewer.forceReposition();
        this.canvas.updateSizes();
        this.frame.setVisible(true);
    }

    public BufferedImage createMiniMapThumbNail() {
        MiniMap miniMap = new MiniMap(this.freeColClient);
        miniMap.setTileSize(24);
        int width = this.freeColClient.getGame().getMap().getWidth() * 24 + 12;
        int height = this.freeColClient.getGame().getMap().getHeight() * 24 / 4;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        miniMap.paintMap(g2d);
        double scaledWidth = Math.min(64 * width / height, 128);
        BufferedImage scaledImage = new BufferedImage((int)scaledWidth, 64, 2);
        scaledImage.createGraphics().drawImage(image, 0, 0, (int)scaledWidth, 64, null);
        return scaledImage;
    }

    public void displayChatMessage(Player player, String message, boolean privateChat) {
        if (this.mapViewer == null || this.canvas == null) {
            return;
        }
        this.mapViewer.addMessage(new GUIMessage(player.getName() + ": " + message, player.getNationColor()));
        this.canvas.repaint(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
    }

    public void displayColonyTile(Graphics2D g, Tile tile, Colony colony) {
        if (this.colonyTileGUI == null) {
            return;
        }
        this.colonyTileGUI.displayColonyTile(g, tile, colony);
    }

    public void displaySplashScreen(String splashFilename, GraphicsDevice gd) {
        this.splash = null;
        if (splashFilename == null) {
            return;
        }
        try {
            Image im = Toolkit.getDefaultToolkit().getImage(splashFilename);
            this.splash = new JWindow(gd.getDefaultConfiguration());
            this.splash.getContentPane().add(new JLabel(new ImageIcon(im)));
            this.splash.pack();
            Point start = this.splash.getLocation();
            DisplayMode dm = gd.getDisplayMode();
            this.splash.setLocation(start.x + dm.getWidth() / 2 - this.splash.getWidth() / 2, start.y + dm.getHeight() / 2 - this.splash.getHeight() / 2);
            this.splash.setVisible(true);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Splash fail", e);
            this.splash = null;
        }
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        return this.imageLibrary.getImageIcon(display, small);
    }

    public void hideSplashScreen() {
        if (this.splash != null) {
            this.splash.setVisible(false);
            this.splash.dispose();
            this.splash = null;
        }
    }

    public void initializeInGame(Tile tile) {
        if (this.frame == null || this.canvas == null) {
            return;
        }
        this.frame.setJMenuBar(new InGameMenuBar(this.freeColClient));
        this.frame.paintAll(this.canvas.getGraphics());
        this.enableMapControls(this.freeColClient.getClientOptions().getBoolean("model.option.displayMapControls"));
        this.setSelectedTile(tile, false);
    }

    public void playSound(String sound) {
        if (!this.canPlaySound()) {
            return;
        }
        if (sound == null) {
            this.soundPlayer.stop();
        } else {
            File file = ResourceManager.getAudio(sound);
            if (file != null) {
                this.soundPlayer.playOnce(file);
            }
            logger.finest((file == null ? "Could not load" : "Playing") + " sound: " + sound);
        }
    }

    public void quit() throws Exception {
        if (this.frame != null) {
            GraphicsConfiguration GraphicsConf = this.frame.getGraphicsConfiguration();
            GraphicsDevice gd = GraphicsConf.getDevice();
            if (!this.isWindowed()) {
                gd.setFullScreenWindow(null);
            }
        }
    }

    public void refresh() {
        if (this.mapViewer == null || this.canvas == null) {
            return;
        }
        this.mapViewer.forceReposition();
        this.canvas.refresh();
    }

    public void refreshTile(Tile tile) {
        if (this.mapViewer == null || this.canvas == null) {
            return;
        }
        if (tile.getX() >= 0 && tile.getY() >= 0) {
            this.canvas.repaint(this.mapViewer.getTileBounds(tile));
        }
    }

    public void resetMenuBar() {
        if (this.frame == null) {
            return;
        }
        JMenuBar menuBar = this.frame.getJMenuBar();
        if (menuBar != null) {
            ((FreeColMenuBar)menuBar).reset();
        }
    }

    public void scaleMap(float scale) {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.scaleMap(scale);
        this.refresh();
    }

    public void setActiveUnit(Unit unit) {
        if (this.mapViewer == null || this.canvas == null) {
            return;
        }
        this.mapViewer.setActiveUnit(unit);
        this.updateMapControls();
        if (unit != null && !this.freeColClient.getMyPlayer().owns(unit)) {
            this.canvas.refresh();
        }
        this.updateMenuBar();
    }

    public void setupMouseListeners() {
        if (this.canvas == null || this.mapViewer == null) {
            return;
        }
        this.canvas.setupMouseListeners(this.mapViewer);
    }

    public void startGUI(GraphicsDevice gd, Dimension desiredWindowSize, boolean sound) {
        Dimension windowSize;
        ClientOptions opts = this.freeColClient.getClientOptions();
        if (sound) {
            AudioMixerOption amo = (AudioMixerOption)opts.getOption("model.option.audioMixer");
            PercentageOption volume = (PercentageOption)opts.getOption("model.option.audioVolume");
            try {
                this.soundPlayer = new SoundPlayer(amo, volume);
            }
            catch (Exception e) {
                this.soundPlayer = null;
                logger.log(Level.WARNING, "Sound disabled", e);
            }
        } else {
            this.soundPlayer = null;
        }
        if (gd == null) {
            logger.info("It seems that the GraphicsEnvironment is headless!");
            return;
        }
        String pmoffscreen = "sun.java2d.pmoffscreen";
        BooleanOption usePixmaps = (BooleanOption)opts.getOption("model.option.usePixmaps");
        String pmoffscreenValue = System.getProperty("sun.java2d.pmoffscreen");
        if (pmoffscreenValue == null) {
            System.setProperty("sun.java2d.pmoffscreen", usePixmaps.getValue().toString());
            logger.info("sun.java2d.pmoffscreen using client option: " + usePixmaps.getValue());
        } else {
            usePixmaps.setValue(Boolean.valueOf(pmoffscreenValue));
            logger.info("sun.java2d.pmoffscreen overrides client option: " + pmoffscreenValue);
        }
        usePixmaps.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String newValue = e.getNewValue().toString();
                System.setProperty("sun.java2d.pmoffscreen", newValue);
                logger.info("Set sun.java2d.pmoffscreen to: " + newValue);
            }
        });
        if (desiredWindowSize == null) {
            if (gd.isFullScreenSupported()) {
                this.setWindowed(false);
                windowSize = GUI.determineFullScreenSize(gd);
                logger.info("Full screen window size is " + windowSize);
            } else {
                this.setWindowed(true);
                windowSize = new Dimension(-1, -1);
                logger.warning("Full screen not supported.");
                System.err.println(Messages.message("client.fullScreen"));
            }
        } else {
            this.setWindowed(true);
            windowSize = desiredWindowSize;
            logger.info("Desired window size is " + windowSize);
        }
        if (this.isWindowed() && (windowSize.width <= 0 || windowSize.height <= 0)) {
            windowSize = GUI.determineWindowSize(gd);
            logger.info("Inner window size is " + windowSize);
        }
        this.mapViewer = new MapViewer(this.freeColClient, windowSize, this.imageLibrary);
        this.canvas = new Canvas(this.freeColClient, windowSize, this.mapViewer);
        this.colonyTileGUI = new MapViewer(this.freeColClient, windowSize, this.imageLibrary);
        this.changeWindowedMode(this.isWindowed());
        this.frame.setIconImage(ResourceManager.getImage("FrameIcon.image"));
        LanguageOption o = (LanguageOption)this.freeColClient.getClientOptions().getOption("model.option.languageOption");
        o.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                LanguageOption.Language language = (LanguageOption.Language)e.getNewValue();
                logger.info("Set language to: " + language);
                if ("automatic".equalsIgnoreCase(language.getKey())) {
                    GUI.this.showInformationMessage("autodetectLanguageSelected");
                } else {
                    Locale l = language.getLocale();
                    Messages.setMessageBundle(l);
                    Messages.setModMessageBundle(l);
                    GUI.this.showInformationMessage(StringTemplate.template("newLanguageSelected").addName("%language%", l.getDisplayName()));
                }
            }
        });
        this.mapViewer.startCursorBlinking();
    }

    public void startMapEditorGUI() {
        if (this.frame == null || this.canvas == null) {
            return;
        }
        this.scaleMap(2.0f);
        this.frame.setJMenuBar(new MapEditorMenuBar(this.freeColClient));
        this.canvas.showMapEditorTransformPanel();
        CanvasMapEditorMouseListener listener = new CanvasMapEditorMouseListener(this.freeColClient, this.canvas);
        this.canvas.addMouseListener(listener);
        this.canvas.addMouseMotionListener(listener);
    }

    public void updateMenuBar() {
        if (this.frame != null && this.frame.getJMenuBar() != null) {
            ((FreeColMenuBar)this.frame.getJMenuBar()).update();
        }
    }

    private static Dimension determineFullScreenSize(GraphicsDevice gd) {
        Rectangle bounds = gd.getDefaultConfiguration().getBounds();
        return new Dimension(bounds.width - bounds.x, bounds.height - bounds.y);
    }

    private static Dimension determineWindowSize(GraphicsDevice gd) {
        DisplayMode dm = gd.getDisplayMode();
        int width = dm.getWidth();
        int height = dm.getHeight();
        LogBuilder lb = new LogBuilder(256);
        lb.add("determineWindowSize\n", "  Display mode size: ", width, "x", height, "\n");
        try {
            Insets in = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
            height -= in.bottom + in.top;
            width -= in.left + in.right;
            lb.add("  less insets: ", in.left + in.right, "x", in.bottom + in.top, "\n");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to get screen insets", e);
        }
        lb.add("  less faked window decoration adjust: ", 16, "x", 39, "\n");
        Dimension size = new Dimension(width -= 16, height -= 39);
        lb.add("  = ", size);
        lb.log(logger, Level.INFO);
        return size;
    }

    public static JLabel getDefaultHeader(String text) {
        JLabel header = new JLabel(text, 0);
        header.setFont(BIG_HEADER_FONT);
        header.setBorder(GUI.blankBorder(20, 0, 20, 0));
        return header;
    }

    public static GraphicsDevice getGoodGraphicsDevice() {
        try {
            return MouseInfo.getPointerInfo().getDevice();
        }
        catch (HeadlessException he) {
            try {
                GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                return lge.getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                return null;
            }
        }
    }

    public static JButton getLinkButton(String text, Icon icon, String action) {
        JButton button = new JButton(text, icon);
        button.setMargin(EMPTY_MARGIN);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setAlignmentY(0.8f);
        button.setBorder(GUI.blankBorder(0, 0, 0, 0));
        button.setActionCommand(action);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    public static JTextArea getDefaultTextArea(StringTemplate template) {
        return GUI.getDefaultTextArea(Messages.message(template));
    }

    public static JTextArea getDefaultTextArea(StringTemplate template, int columns) {
        return GUI.getDefaultTextArea(Messages.message(template), columns);
    }

    public static JTextArea getDefaultTextArea(String text) {
        return GUI.getDefaultTextArea(text, 20);
    }

    public static JTextArea getDefaultTextArea(String text, int columns) {
        JTextArea textArea = new JTextArea(text);
        textArea.setColumns(columns);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setFont(DEFAULT_FONT);
        textArea.setSize(textArea.getPreferredSize());
        return textArea;
    }

    public static JTextPane getDefaultTextPane() {
        return GUI.getDefaultTextPane(null);
    }

    public static JTextPane getDefaultTextPane(String text) {
        DefaultStyledDocument document = new DefaultStyledDocument(STYLE_CONTEXT){

            @Override
            public Font getFont(AttributeSet attr) {
                Font font = ResourceManager.getFont(StyleConstants.getFontFamily(attr), StyleConstants.getFontSize(attr));
                int fontStyle = 0;
                if (StyleConstants.isBold(attr)) {
                    fontStyle |= 1;
                }
                if (StyleConstants.isItalic(attr)) {
                    fontStyle |= 2;
                }
                return fontStyle == 0 ? font : font.deriveFont(fontStyle);
            }
        };
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setLogicalStyle(STYLE_CONTEXT.getStyle("regular"));
        textPane.setText(text);
        return textPane;
    }

    public static Border blankBorder(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(top, left, bottom, right);
    }

    public static void padBorder(JComponent component, int top, int left, int bottom, int right) {
        component.setBorder(BorderFactory.createCompoundBorder(GUI.blankBorder(top, left, bottom, right), component.getBorder()));
    }

    public static void localizeBorder(JComponent component, StringTemplate template) {
        TitledBorder tb = (TitledBorder)component.getBorder();
        tb.setTitle(Messages.message(template));
    }

    public static TitledBorder localizedBorder(String key) {
        return BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message(key));
    }

    public static TitledBorder localizedBorder(String key, Color color) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color, 1), Messages.message(key));
    }

    public static JButton localizedButton(String key) {
        return new JButton(Messages.message(key));
    }

    public static JButton localizedButton(StringTemplate template) {
        return new JButton(Messages.message(template));
    }

    public static JCheckBoxMenuItem localizedCheckBoxMenuItem(String key, boolean value) {
        return new JCheckBoxMenuItem(Messages.message(key), value);
    }

    public static JLabel localizedLabel(String key) {
        return GUI.localizedLabel(Messages.message(key), 10);
    }

    public static JLabel localizedLabel(String key, int alignment) {
        return GUI.localizedLabel(key, null, alignment);
    }

    public static JLabel localizedLabel(String key, Icon icon, int alignment) {
        return GUI.localizedLabel(StringTemplate.key(key), icon, alignment);
    }

    public static JLabel localizedLabel(StringTemplate template) {
        return GUI.localizedLabel(template, null, 10);
    }

    public static JLabel localizedLabel(StringTemplate template, Icon icon, int alignment) {
        return new JLabel(Messages.message(template), icon, alignment);
    }

    public static JMenu localizedMenu(String key) {
        return new JMenu(Messages.message(key));
    }

    public static JMenu localizedMenu(StringTemplate template) {
        return new JMenu(Messages.message(template));
    }

    public static JMenuItem localizedMenuItem(String key) {
        return GUI.localizedMenuItem(key, null);
    }

    public static JMenuItem localizedMenuItem(String key, Icon icon) {
        return new JMenuItem(Messages.message(key), icon);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template) {
        return GUI.localizedMenuItem(template, null);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template, Icon icon) {
        return new JMenuItem(Messages.message(template), icon);
    }

    public static JRadioButtonMenuItem localizedRadioButtonMenuItem(StringTemplate template, boolean value) {
        return new JRadioButtonMenuItem(Messages.message(template), value);
    }

    public static JComponent localizeToolTip(JComponent comp, String key) {
        comp.setToolTipText(Messages.message(key));
        return comp;
    }

    public static JComponent localizeToolTip(JComponent comp, StringTemplate template) {
        comp.setToolTipText(Messages.message(template));
        return comp;
    }

    public int getAnimationSpeed(Unit unit) {
        String key = this.freeColClient.getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
        return this.freeColClient.getClientOptions().getInteger(key);
    }

    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        if (this.canvas == null) {
            return;
        }
        Animations.unitAttack(this, attacker, defender, attackerTile, defenderTile, success);
    }

    public void animateUnitMove(Unit unit, Tile srcTile, Tile dstTile) {
        if (this.canvas == null) {
            return;
        }
        Animations.unitMove(this, unit, srcTile, dstTile);
    }

    public void enableMapControls(boolean enable) {
        if (enable && this.mapControls == null) {
            String className = this.freeColClient.getClientOptions().getString("model.option.mapControls");
            try {
                String panelName = "net.sf.freecol.client.gui.panel." + StringUtils.lastPart(className, ".");
                Class<?> controls = Class.forName(panelName);
                this.mapControls = (MapControls)controls.getConstructor(FreeColClient.class).newInstance(this.freeColClient);
                logger.info("Instantiated " + panelName);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Fallback to CornerMapControls from " + className, e);
                this.mapControls = new CornerMapControls(this.freeColClient);
            }
            if (this.mapControls != null) {
                this.mapControls.addToComponent(this.canvas);
                this.mapControls.update();
            }
        } else if (!enable && this.mapControls != null) {
            this.mapControls.removeFromComponent(this.canvas);
            this.mapControls = null;
        }
    }

    public void updateMapControls() {
        if (this.canvas == null) {
            return;
        }
        if (this.mapControls != null) {
            this.mapControls.update();
        }
    }

    public void updateMapControlsInCanvas() {
        if (this.canvas == null || this.mapControls == null) {
            return;
        }
        this.mapControls.removeFromComponent(this.canvas);
        this.mapControls.addToComponent(this.canvas);
    }

    public void zoomInMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomIn();
    }

    public void zoomOutMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomOut();
    }

    public boolean canZoomInMapControls() {
        return this.mapControls != null && this.mapControls.canZoomInMapControls();
    }

    public boolean canZoomOutMapControls() {
        return this.mapControls != null && this.mapControls.canZoomOutMapControls();
    }

    public void miniMapToggleViewControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.toggleView();
    }

    public void miniMapToggleFogOfWarControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.toggleFogOfWar();
    }

    public boolean confirm(String textKey, String okKey, String cancelKey) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showConfirmDialog(true, null, Messages.message(textKey), null, okKey, cancelKey);
    }

    public boolean confirm(boolean modal, Tile tile, StringTemplate template, Object obj, String okKey, String cancelKey) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showConfirmDialog(modal, tile, GUI.getDefaultTextArea(template), this.getImageIcon(obj, false), okKey, cancelKey);
    }

    public boolean confirmClearTradeRoute(Unit unit) {
        TradeRoute tr = unit.getTradeRoute();
        if (tr == null) {
            return true;
        }
        StringTemplate template = StringTemplate.template("traderoute.reassignRoute").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%route%", tr.getName());
        return this.confirm(true, unit.getTile(), template, unit, "yes", "no");
    }

    public List<String> confirmDeclaration() {
        return this.canvas == null ? Collections.emptyList() : this.canvas.showConfirmDeclarationDialog();
    }

    public int confirmEuropeanTribute(Unit attacker, Colony colony, NationSummary ns) {
        Player player = attacker.getOwner();
        Player other = colony.getOwner();
        int strength = player.calculateStrength(false);
        int otherStrength = ns.getMilitaryStrength();
        int mil = otherStrength <= 1 || otherStrength * 5 < strength ? 0 : (strength == 0 || strength * 5 < otherStrength ? 2 : 1);
        int gold = ns.getGold();
        if (gold == 0) {
            StringTemplate t = StringTemplate.template("confirmTribute.broke").addStringTemplate("%nation%", other.getNationName());
            this.showInformationMessage(t);
            return -1;
        }
        int fin = gold <= 100 ? 0 : (gold <= 1000 ? 1 : 2);
        StringTemplate t = StringTemplate.template("confirmTribute.european").addStringTemplate("%nation%", other.getNationName()).addStringTemplate("%danger%", StringTemplate.template("danger." + levels[mil])).addStringTemplate("%finance%", StringTemplate.template("finance." + levels[fin]));
        return this.showSelectTributeAmountDialog(t, gold);
    }

    public boolean confirmHostileAction(Unit attacker, Tile target) {
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.hasSettlement()) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        String messageId = null;
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case CEASE_FIRE: {
                messageId = "model.diplomacy.attack.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageId = "model.diplomacy.attack.alliance";
                break;
            }
            default: {
                messageId = "model.diplomacy.attack.peace";
            }
        }
        return this.confirm(true, attacker.getTile(), StringTemplate.template(messageId).addStringTemplate("%nation%", enemy.getNationName()), attacker, "model.diplomacy.attack.confirm", "cancel");
    }

    public boolean confirmLeaveColony(Unit unit) {
        Colony colony = unit.getColony();
        StringTemplate message = colony.getReducePopulationMessage();
        if (message != null) {
            this.showInformationMessage(message);
            return false;
        }
        StringTemplate template = unit.getAbandonEducationMessage(true);
        return template == null || this.confirm(true, unit.getTile(), template, unit, "abandonEducation.yes", "abandonEducation.no");
    }

    public int confirmNativeTribute(Unit attacker, IndianSettlement is) {
        Player player = attacker.getOwner();
        Player other = is.getOwner();
        int strength = player.calculateStrength(false);
        String messageId = other.getNumberOfSettlements() >= strength ? "confirmTribute.unwise" : (other.getStance(player) == Player.Stance.CEASE_FIRE ? "confirmTribute.warLikely" : (is.getAlarm(player).getLevel() == Tension.Level.HAPPY ? "confirmTribute.happy" : "confirmTribute.normal"));
        return this.confirm(true, is.getTile(), StringTemplate.template(messageId).addName("%settlement%", is.getName()).addStringTemplate("%nation%", other.getNationName()), attacker, "confirmTribute.yes", "confirmTribute.no") ? 1 : -1;
    }

    public boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            return this.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    public boolean confirmStopGame() {
        return this.confirm("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no");
    }

    public ArmedUnitSettlementAction getArmedUnitSettlementChoice(Settlement settlement) {
        Player player = this.freeColClient.getMyPlayer();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ArmedUnitSettlementAction>(Messages.message("armedUnitSettlement.tribute"), ArmedUnitSettlementAction.SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ArmedUnitSettlementAction>(Messages.message("armedUnitSettlement.attack"), ArmedUnitSettlementAction.SETTLEMENT_ATTACK));
        return (ArmedUnitSettlementAction)((Object)this.getChoice(true, settlement.getTile(), GUI.getDefaultTextArea(settlement.getAlarmLevelMessage(player)), settlement, "cancel", choices));
    }

    public BoycottAction getBoycottChoice(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        StringTemplate template = StringTemplate.template("boycottedGoods.text").add("%goods%", goods.getNameKey()).add("%europe%", europe.getNameKey()).addAmount("%amount%", arrears);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.payArrears"), BoycottAction.PAY_ARREARS));
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.dumpGoods"), BoycottAction.DUMP_CARGO));
        return (BoycottAction)((Object)this.getChoice(true, null, GUI.getDefaultTextArea(template), goods, "cancel", choices));
    }

    public BuyAction getBuyChoice(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        StringTemplate template = StringTemplate.template("buy.text").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addStringTemplate("%goods%", goods.getLabel(true)).addAmount("%gold%", gold);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.takeOffer"), BuyAction.BUY, canBuy));
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.moreGold"), BuyAction.HAGGLE));
        return (BuyAction)((Object)this.getChoice(true, unit.getTile(), GUI.getDefaultTextArea(template), goods, "buyProposition.cancel", choices));
    }

    public ClaimAction getClaimChoice(Tile tile, Player player, int price, Player owner) {
        StringTemplate template;
        ArrayList choices = new ArrayList();
        if (owner.hasContacted(player)) {
            template = StringTemplate.template("indianLand.text").addStringTemplate("%player%", owner.getNationName());
            StringTemplate pay = StringTemplate.template("indianLand.pay").addAmount("%amount%", price);
            choices.add(new ChoiceItem<ClaimAction>(Messages.message(pay), ClaimAction.ACCEPT, player.checkGold(price)));
        } else {
            template = StringTemplate.template("indianLand.unknown");
        }
        choices.add(new ChoiceItem<ClaimAction>(Messages.message("indianLand.take"), ClaimAction.STEAL));
        return (ClaimAction)((Object)this.getChoice(true, tile, GUI.getDefaultTextArea(template), owner, "indianLand.cancel", choices));
    }

    public TradeAction getIndianSettlementTradeChoice(Settlement settlement, StringTemplate template, boolean canBuy, boolean canSell, boolean canGift) {
        ArrayList choices = new ArrayList();
        if (canBuy) {
            choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toBuy"), TradeAction.BUY, canBuy));
        }
        if (canSell) {
            choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toSell"), TradeAction.SELL, canSell));
        }
        if (canGift) {
            choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toGift"), TradeAction.GIFT, canGift));
        }
        if (choices.isEmpty()) {
            return null;
        }
        return (TradeAction)((Object)this.getChoice(true, settlement.getTile(), GUI.getDefaultTextArea(template), settlement, "tradeProposition.cancel", choices));
    }

    public MissionaryAction getMissionaryChoice(Unit unit, IndianSettlement settlement, boolean canEstablish, boolean canDenounce) {
        StringBuilder sb = new StringBuilder(256);
        StringTemplate t = settlement.getAlarmLevelMessage(unit.getOwner());
        sb.append(Messages.message(t)).append("\n\n");
        t = StringTemplate.template("missionarySettlement.question").addName("%settlement%", settlement.getName());
        sb.append(Messages.message(t));
        ArrayList choices = new ArrayList();
        if (canEstablish) {
            choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.establish"), MissionaryAction.ESTABLISH_MISSION, canEstablish));
        }
        if (canDenounce) {
            choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.heresy"), MissionaryAction.DENOUNCE_HERESY, canDenounce));
        }
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.incite"), MissionaryAction.INCITE_INDIANS));
        return (MissionaryAction)((Object)this.getChoice(true, unit.getTile(), GUI.getDefaultTextArea(sb.toString()), settlement, "cancel", choices));
    }

    public ScoutColonyAction getScoutForeignColonyChoice(Colony colony, Unit unit, boolean neg) {
        StringTemplate template = StringTemplate.template("scoutColony.text").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%colony%", colony.getName());
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.negotiate"), ScoutColonyAction.FOREIGN_COLONY_NEGOTIATE, neg));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.spy"), ScoutColonyAction.FOREIGN_COLONY_SPY));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.attack"), ScoutColonyAction.FOREIGN_COLONY_ATTACK));
        return (ScoutColonyAction)((Object)this.getChoice(true, unit.getTile(), GUI.getDefaultTextArea(template), colony, "cancel", choices));
    }

    public ScoutIndianSettlementAction getScoutIndianSettlementChoice(IndianSettlement settlement, String numberString) {
        Player player = this.freeColClient.getMyPlayer();
        Player owner = settlement.getOwner();
        StringBuilder sb = new StringBuilder(400);
        sb.append(Messages.message(settlement.getAlarmLevelMessage(player))).append("\n\n");
        String key = ((IndianNationType)owner.getNationType()).getSettlementTypeKey(true);
        sb.append(Messages.message(StringTemplate.template("scoutSettlement.greetings").addStringTemplate("%nation%", owner.getNationName()).addName("%settlement%", settlement.getName()).addName("%number%", numberString).add("%settlementType%", key))).append(" ");
        if (settlement.getLearnableSkill() != null) {
            key = settlement.getLearnableSkill().getNameKey();
            sb.append(Messages.message(StringTemplate.template("scoutSettlement.skill").add("%skill%", key))).append(" ");
        }
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        int present = 0;
        for (present = 0; present < wantedGoods.length && wantedGoods[present] != null; ++present) {
        }
        if (present > 0) {
            StringTemplate t = StringTemplate.template("scoutSettlement.trade." + Integer.toString(present));
            for (int i = 0; i < present; ++i) {
                t.add("%goods" + Integer.toString(i + 1) + "%", wantedGoods[i].getNameKey());
            }
            sb.append(Messages.message(t)).append("\n\n");
        }
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.speak"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_SPEAK));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        return (ScoutIndianSettlementAction)((Object)this.getChoice(true, settlement.getTile(), GUI.getDefaultTextArea(sb.toString()), settlement, "cancel", choices));
    }

    public SellAction getSellChoice(Unit unit, Settlement settlement, Goods goods, int gold) {
        StringTemplate goodsTemplate = goods.getLabel(true);
        StringTemplate template = StringTemplate.template("sell.text").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.takeOffer"), SellAction.SELL));
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.moreGold"), SellAction.HAGGLE));
        choices.add(new ChoiceItem<SellAction>(Messages.message(StringTemplate.template("sell.gift").addStringTemplate("%goods%", goodsTemplate)), SellAction.GIFT));
        return (SellAction)((Object)this.getChoice(true, unit.getTile(), GUI.getDefaultTextArea(template), goods, "sellProposition.cancel", choices));
    }

    public <T> T getChoice(boolean modal, Tile tile, Object explain, Object obj, String cancelKey, List<ChoiceItem<T>> choices) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showChoiceDialog(modal, tile, explain, this.getImageIcon(obj, false), cancelKey, choices);
    }

    public String getInput(boolean modal, Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showInputDialog(modal, tile, template, defaultValue, okKey, cancelKey);
    }

    public void closeMainPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.closeMainPanel();
    }

    public void closeMenus() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.closeMenus();
    }

    public void closeStatusPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.closeStatusPanel();
    }

    public boolean containsInGameComponents() {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.containsInGameComponents();
    }

    public void displayChat(String senderName, String message, boolean privateChat) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.displayChat(senderName, message, privateChat);
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.getLoadingSavegameDialog();
    }

    public boolean isClientOptionsDialogShowing() {
        return this.canvas != null && this.canvas.isClientOptionsDialogShowing();
    }

    public boolean isMapboardActionsEnabled() {
        return this.canvas != null && this.canvas.isMapboardActionsEnabled();
    }

    public boolean isShowingSubPanel() {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.isShowingSubPanel();
    }

    public void paintImmediatelyCanvasIn(Rectangle rectangle) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.paintImmediately(rectangle);
    }

    public void paintImmediatelyCanvasInItsBounds() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.paintImmediately(this.canvas.getBounds());
    }

    public void refreshPlayersTable() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.refreshPlayersTable();
    }

    public void removeFromCanvas(Component component) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.remove(component);
    }

    public void removeInGameComponents() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.removeInGameComponents();
    }

    public void removeTradeRoutePanel(TradeRoutePanel panel) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.removeTradeRoutePanel(panel);
    }

    public void requestFocusForSubPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.getShowingSubPanel().requestFocus();
    }

    public boolean requestFocusInWindow() {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.requestFocusInWindow();
    }

    public void restoreSavedSize(Component comp, int w, int h) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.restoreSavedSize(comp, new Dimension(w, h));
    }

    public void restoreSavedSize(Component comp, Dimension size) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.restoreSavedSize(comp, size);
    }

    public void returnToTitle() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.returnToTitle();
    }

    public void showAboutPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showAboutPanel();
    }

    public void showBuildQueuePanel(Colony colony) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showBuildQueuePanel(colony);
    }

    public void showBuildQueuePanel(Colony colony, Runnable callBack) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showBuildQueuePanel(colony, callBack);
    }

    public void showCaptureGoodsDialog(final Unit unit, List<Goods> gl, final String defenderId) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showCaptureGoodsDialog(unit, gl, new DialogHandler<List<Goods>>(){

            @Override
            public void handle(List<Goods> gl) {
                GUI.this.igc().lootCargo(unit, gl, defenderId);
            }
        });
    }

    public void showChatPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showChatPanel();
    }

    public void showChooseFoundingFatherDialog(final List<FoundingFather> ffs) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showChooseFoundingFatherDialog(ffs, new DialogHandler<FoundingFather>(){

            @Override
            public void handle(FoundingFather ff) {
                GUI.this.igc().chooseFoundingFather(ffs, ff);
            }
        });
    }

    public OptionGroup showClientOptionsDialog() {
        if (this.canvas == null) {
            return null;
        }
        OptionGroup group = this.canvas.showClientOptionsDialog();
        if (!this.freeColClient.isInGame()) {
            this.showMainPanel(null);
        }
        return group;
    }

    public ColonyPanel showColonyPanel(Colony colony, Unit unit) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showColonyPanel(colony, unit);
    }

    public void showColopediaPanel(String nodeId) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showColopediaPanel(nodeId);
    }

    public ColorChooserPanel showColorChooserPanel(ActionListener al) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showColorChooserPanel(al);
    }

    public void showCompactLabourReport() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showCompactLabourReport();
    }

    public void showCompactLabourReport(LabourData.UnitData unitData) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showCompactLabourReport(unitData);
    }

    public void showDeclarationPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showDeclarationPanel();
    }

    public OptionGroup showDifficultyDialog() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showDifficultyDialog();
    }

    public OptionGroup showDifficultyDialog(Specification spec, OptionGroup group) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showDifficultyDialog(spec, group);
    }

    public void showDumpCargoDialog(Unit unit) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showDumpCargoDialog(unit, new DialogHandler<List<Goods>>(){

            @Override
            public void handle(List<Goods> goodsList) {
                for (Goods g : goodsList) {
                    GUI.this.igc().unloadCargo(g, true);
                }
            }
        });
    }

    public boolean showEditOptionDialog(Option option) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showEditOptionDialog(option);
    }

    public void showEmigrationDialog(final Player player, final int n, final boolean fountainOfYouth) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showEmigrationDialog(player, fountainOfYouth, new DialogHandler<Integer>(){

            @Override
            public void handle(Integer value) {
                GUI.this.igc().emigrate(player, Europe.MigrationType.convertToMigrantSlot(value));
                if (n > 1) {
                    GUI.this.showEmigrationDialog(player, n - 1, fountainOfYouth);
                }
            }
        });
    }

    public void showEndTurnDialog(List<Unit> units) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showEndTurnDialog(units, new DialogHandler<Boolean>(){

            @Override
            public void handle(Boolean value) {
                if (value != null && value.booleanValue()) {
                    GUI.this.igc().endTurn(false);
                }
            }
        });
    }

    public void showErrorMessage(StringTemplate template) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showErrorMessage(Messages.message(template));
    }

    public void showErrorMessage(String messageId) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showErrorMessage(messageId);
    }

    public void showErrorMessage(String messageID, String message) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showErrorMessage(messageID, message);
    }

    public void showEuropePanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showEuropePanel();
    }

    public void showEventPanel(String header, String image, String footer) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showEventPanel(header, image, footer);
    }

    public void showFindSettlementPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showFindSettlementPanel();
    }

    public OptionGroup showGameOptionsDialog(boolean editable, boolean custom) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showGameOptionsDialog(editable, custom);
    }

    public void showHighScoresPanel(String messageId, List<HighScore> scores) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showHighScoresPanel(messageId, scores);
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showIndianSettlementPanel(indianSettlement);
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showInformationMessage(displayObject, messageId);
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showInformationMessage(displayObject, template);
    }

    public void showInformationMessage(ModelMessage message) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showInformationMessage(message);
    }

    public void showInformationMessage(String messageId) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showInformationMessage(messageId);
    }

    public void showInformationMessage(StringTemplate template) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showInformationMessage(template);
    }

    public File showLoadDialog(File directory) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showLoadDialog(directory);
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showLoadDialog(directory, fileFilters);
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showLoadingSavegameDialog(publicServer, singlePlayer);
    }

    public void showLogFilePanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showLogFilePanel();
    }

    public void showMainPanel(String userMsg) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showMainPanel(userMsg);
    }

    public OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showMapGeneratorOptionsDialog(editable);
    }

    public Dimension showMapSizeDialog() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showMapSizeDialog();
    }

    public void showModelMessages(List<ModelMessage> modelMessages) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showModelMessages(modelMessages);
    }

    public void showMonarchDialog(final Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showMonarchDialog(action, template, monarchKey, new DialogHandler<Boolean>(){

            @Override
            public void handle(Boolean b) {
                GUI.this.igc().monarchAction(action, b);
                GUI.this.updateMenuBar();
            }
        });
    }

    public void showNameNewLandDialog(String key, final String defaultName, final Unit unit) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showNameNewLandDialog(key, defaultName, unit, new DialogHandler<String>(){

            @Override
            public void handle(String name) {
                if (name == null || name.isEmpty()) {
                    name = defaultName;
                }
                GUI.this.igc().nameNewLand(unit, name);
            }
        });
    }

    public void showNameNewRegionDialog(StringTemplate template, final String defaultName, final Unit unit, final Tile tile, final Region region) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showNameNewRegionDialog(template, defaultName, unit, new DialogHandler<String>(){

            @Override
            public void handle(String name) {
                if (name == null || name.isEmpty()) {
                    name = defaultName;
                }
                GUI.this.igc().nameNewRegion(tile, unit, region, name);
            }
        });
    }

    public void showFirstContactDialog(final Player player, final Player other, final Tile tile, int settlementCount) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showFirstContactDialog(player, other, tile, settlementCount, new DialogHandler<Boolean>(){

            @Override
            public void handle(Boolean b) {
                GUI.this.igc().firstContact(player, other, tile, b);
            }
        });
    }

    public DiplomaticTrade showDiplomaticTradeDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showDiplomaticTradeDialog(our, other, agreement, comment);
    }

    public void showNewPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showNewPanel();
    }

    public void showNewPanel(Specification specification) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showNewPanel(specification);
    }

    public void showOpeningVideoPanel(String userMsg) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showOpeningVideoPanel(userMsg);
    }

    public void showSpyColonyPanel(Tile tile, Runnable callback) {
        if (this.canvas == null) {
            return;
        }
        ColonyPanel panel = this.canvas.showSpyColonyPanel(tile);
        panel.addClosingCallback(callback);
    }

    public Parameters showParametersDialog() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showParametersDialog();
    }

    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showPreCombatDialog(attacker, defender, tile);
    }

    public void showPurchasePanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showPurchasePanel();
    }

    public void showRecruitPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showRecruitPanel();
    }

    public void showReportCargoPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportCargoPanel();
    }

    public void showReportColonyPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportColonyPanel();
    }

    public void showReportContinentalCongressPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportContinentalCongressPanel();
    }

    public void showReportEducationPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportEducationPanel();
    }

    public void showReportExplorationPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportExplorationPanel();
    }

    public void showReportForeignAffairPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportForeignAffairPanel();
    }

    public void showReportHistoryPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportHistoryPanel();
    }

    public void showReportIndianPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportIndianPanel();
    }

    public void showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportLabourDetailPanel(unitType, data, unitCount, colonies);
    }

    public void showReportLabourPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportLabourPanel();
    }

    public void showReportMilitaryPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportMilitaryPanel();
    }

    public void showReportNavalPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportNavalPanel();
    }

    public void showReportProductionPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportProductionPanel();
    }

    public void showReportReligiousPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportReligiousPanel();
    }

    public void showReportRequirementsPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportRequirementsPanel();
    }

    public void showReportTradePanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportTradePanel();
    }

    public void showReportTurnPanel(List<ModelMessage> messages) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showReportTurnPanel(messages);
    }

    public File showSaveDialog(File directory, String defaultName) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showSaveDialog(directory, defaultName);
    }

    public File showSaveDialog(File directory, FileFilter[] fileFilters, String defaultName, String extension) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showSaveDialog(directory, fileFilters, defaultName, extension);
    }

    public Dimension showScaleMapSizeDialog() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showScaleMapSizeDialog();
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        if (this.canvas == null) {
            return -1;
        }
        return this.canvas.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        if (this.canvas == null) {
            return -1;
        }
        return this.canvas.showSelectTributeAmountDialog(question, maximum);
    }

    public Location showSelectDestinationDialog(Unit unit) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.showSelectDestinationDialog(unit);
    }

    public void showServerListPanel(List<ServerInfo> serverList) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showServerListPanel(serverList);
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showStartGamePanel(game, player, singlePlayerMode);
    }

    public void showStatisticsPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showStatisticsPanel();
    }

    public void showStatusPanel(String message) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showStatusPanel(message);
    }

    public void showTilePanel(Tile tile) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showTilePanel(tile);
    }

    public void showTilePopUpAtSelectedTile() {
        if (this.canvas == null || this.mapViewer == null) {
            return;
        }
        this.canvas.showTilePopup(this.getSelectedTile(), this.mapViewer.getCursor().getCanvasX(), this.mapViewer.getCursor().getCanvasY());
    }

    public void showTradeRoutePanel(Unit unit) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showTradeRoutePanel(unit);
    }

    public void showTradeRouteInputPanel(TradeRoute newRoute, Runnable callBack) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showTradeRouteInputPanel(newRoute, callBack);
    }

    public void showTrainPanel() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showTrainPanel();
    }

    public void showVictoryDialog() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showVictoryDialog(new DialogHandler<Boolean>(){

            @Override
            public void handle(Boolean result) {
                GUI.this.igc().victory(result);
            }
        });
    }

    public boolean showWarehouseDialog(Colony colony) {
        if (this.canvas == null) {
            return false;
        }
        return this.canvas.showWarehouseDialog(colony);
    }

    public void showWorkProductionPanel(Unit unit) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.showWorkProductionPanel(unit);
    }

    public void updateEuropeanSubpanels() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.updateEuropeanSubpanels();
    }

    public void updateGameOptions() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.updateGameOptions();
    }

    public void updateMapGeneratorOptions() {
        if (this.canvas == null) {
            return;
        }
        this.canvas.updateMapGeneratorOptions();
    }

    public void centerActiveUnit() {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.centerActiveUnit();
    }

    public void changeViewMode(int newViewMode) {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.changeViewMode(newViewMode);
    }

    public void executeWithUnitOutForAnimation(Unit unit, Tile sourceTile, OutForAnimationCallback r) {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.executeWithUnitOutForAnimation(unit, sourceTile, r);
    }

    public Unit getActiveUnit() {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getActiveUnit();
    }

    public Tile getFocus() {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getFocus();
    }

    public float getMapScale() {
        if (this.mapViewer == null) {
            return 1.0f;
        }
        return this.mapViewer.getMapScale();
    }

    public Tile getSelectedTile() {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getSelectedTile();
    }

    public Rectangle getTileBounds(Tile tile) {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getTileBounds(tile);
    }

    public Point getTilePosition(Tile tile) {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getTilePosition(tile);
    }

    public int getViewMode() {
        if (this.mapViewer == null) {
            return -1;
        }
        return this.mapViewer.getViewMode();
    }

    public boolean onScreen(Tile tileToCheck) {
        if (this.mapViewer == null) {
            return true;
        }
        return this.mapViewer.onScreen(tileToCheck);
    }

    public void setFocus(Tile tileToFocus) {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.setFocus(tileToFocus);
    }

    public void setFocusImmediately(Tile tileToFocus) {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.setFocusImmediately(tileToFocus);
    }

    public boolean setSelectedTile(Tile newTileToSelect, boolean clearGoToOrders) {
        if (this.mapViewer == null) {
            return true;
        }
        return this.mapViewer.setSelectedTile(newTileToSelect, clearGoToOrders);
    }

    public void toggleViewMode() {
        if (this.mapViewer == null) {
            return;
        }
        this.mapViewer.toggleViewMode();
    }

    static {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = STYLE_CONTEXT.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(regular, "NormalFont");
        StyleConstants.setFontSize(regular, 13);
        Style buttonStyle = STYLE_CONTEXT.addStyle("button", regular);
        StyleConstants.setForeground(buttonStyle, LINK_COLOR);
        Style right = STYLE_CONTEXT.addStyle("right", regular);
        StyleConstants.setAlignment(right, 2);
    }

    public static enum TradeAction {
        BUY,
        SELL,
        GIFT;

    }

    public static enum SellAction {
        SELL,
        HAGGLE,
        GIFT;

    }

    public static enum ScoutIndianSettlementAction {
        INDIAN_SETTLEMENT_SPEAK,
        INDIAN_SETTLEMENT_TRIBUTE,
        INDIAN_SETTLEMENT_ATTACK;

    }

    public static enum ScoutColonyAction {
        FOREIGN_COLONY_NEGOTIATE,
        FOREIGN_COLONY_SPY,
        FOREIGN_COLONY_ATTACK;

    }

    public static enum MissionaryAction {
        ESTABLISH_MISSION,
        DENOUNCE_HERESY,
        INCITE_INDIANS;

    }

    public static enum ClaimAction {
        ACCEPT,
        STEAL;

    }

    public static enum BuyAction {
        BUY,
        HAGGLE;

    }

    public static enum BoycottAction {
        PAY_ARREARS,
        DUMP_CARGO;

    }

    public static enum ArmedUnitSettlementAction {
        SETTLEMENT_ATTACK,
        SETTLEMENT_TRIBUTE;

    }
}

