/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.option.OptionGroup;

public final class PreGameController {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;

    public PreGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
    }

    public void chat(String message) {
        this.freeColClient.askServer().chat(this.freeColClient.getMyPlayer(), message);
    }

    public void setReady(boolean ready) {
        this.freeColClient.getMyPlayer().setReady(ready);
        this.freeColClient.askServer().setReady(ready);
    }

    public void requestLaunch() {
        if (this.freeColClient.getGame().allPlayersReadyToLaunch()) {
            this.gui.showStatusPanel(Messages.message("status.startingGame"));
            this.freeColClient.askServer().requestLaunch();
        } else {
            this.gui.showErrorMessage("server.notAllReady");
        }
    }

    public void setAvailable(Nation nation, NationOptions.NationState state) {
        this.freeColClient.getGame().getNationOptions().getNations().put(nation, state);
        this.freeColClient.askServer().setAvailable(nation, state);
    }

    public void setColor(Nation nation, Color color) {
        nation.setColor(color);
        this.freeColClient.askServer().setColor(nation, color);
    }

    public void setNation(Nation nation) {
        this.freeColClient.getMyPlayer().setNation(nation);
        this.freeColClient.askServer().setNation(nation);
    }

    public void setNationType(NationType nationType) {
        this.freeColClient.getMyPlayer().changeNationType(nationType);
        this.freeColClient.askServer().setNationType(nationType);
    }

    public boolean startGame() {
        Player player = this.freeColClient.getMyPlayer();
        if (!this.freeColClient.isHeadless()) {
            this.gui.closeMainPanel();
            this.gui.closeMenus();
            this.gui.closeStatusPanel();
            this.gui.playSound(null);
            this.gui.playSound("sound.intro." + player.getNationId());
        }
        this.freeColClient.askServer().registerMessageHandler(this.freeColClient.getInGameInputHandler());
        this.freeColClient.setInGame(true);
        this.gui.initializeInGame((Tile)player.getEntryLocation());
        InGameController igc = this.freeColClient.getInGameController();
        if (this.freeColClient.currentPlayerIsMyPlayer()) {
            igc.nextActiveUnit();
        }
        this.gui.setupMouseListeners();
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && FreeColDebugger.getDebugRunTurns() > 0) {
            this.freeColClient.skipTurns(FreeColDebugger.getDebugRunTurns());
            return false;
        }
        if (this.freeColClient.getGame().getTurn().getNumber() == 1) {
            Map.Direction sailDirection = player.getNation().startsOnEastCoast() ? Map.Direction.W : Map.Direction.E;
            player.addModelMessage(new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.startGame", player).add("%direction%", sailDirection.getNameKey()));
            igc.nextModelMessage();
        }
        return true;
    }

    public void updateGameOptions() {
        OptionGroup gameOptions = this.freeColClient.getGame().getGameOptions();
        this.freeColClient.getGame().getSpecification().clean("update game options (client initiated)");
        this.freeColClient.askServer().updateGameOptions(gameOptions);
    }

    public void updateMapGeneratorOptions() {
        OptionGroup mgo = this.freeColClient.getGame().getMapGeneratorOptions();
        this.freeColClient.askServer().updateMapGeneratorOptions(mgo);
    }
}

