/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class InGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(InGameInputHandler.class.getName());
    private final Runnable closeMenusRunnable = new Runnable(){

        @Override
        public void run() {
            InGameInputHandler.this.getGUI().closeMenus();
        }
    };
    private final Runnable deselectActiveUnitRunnable = new Runnable(){

        @Override
        public void run() {
            InGameInputHandler.this.getGUI().setActiveUnit(null);
        }
    };
    private final Runnable displayModelMessagesRunnable = new Runnable(){

        @Override
        public void run() {
            InGameInputHandler.this.igc().displayModelMessages(false);
        }
    };
    private final Runnable reconnectRunnable = new Runnable(){

        @Override
        public void run() {
            InGameInputHandler.this.igc().reconnect();
        }
    };
    private final Runnable updateMenuBarRunnable = new Runnable(){

        @Override
        public void run() {
            InGameInputHandler.this.getGUI().updateMenuBar();
        }
    };
    private Unit lastAnimatedUnit = null;

    public InGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    private InGameController igc() {
        return this.getFreeColClient().getInGameController();
    }

    private void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refreshCanvas(final boolean focus) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.getGUI().refresh();
                if (focus && !InGameInputHandler.this.getGUI().isShowingSubPanel()) {
                    InGameInputHandler.this.getGUI().requestFocusInWindow();
                }
            }
        });
    }

    private static int getIntegerAttribute(Element element, String attrib) {
        int n;
        try {
            n = Integer.parseInt(element.getAttribute(attrib));
        }
        catch (NumberFormatException e) {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    private static Element selectElement(Element parent, String key) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            if (!key.equals(FreeColObject.readId(e))) continue;
            return e;
        }
        return null;
    }

    private static Unit selectUnitFromElement(Game game, Element element, String id) {
        Element e = InGameInputHandler.selectElement(element, id);
        Unit u = null;
        if (e != null && (u = new Unit(game, e)).getLocation() == null) {
            throw new IllegalStateException("Null location: " + u);
        }
        return u;
    }

    @Override
    public Element handle(Connection connection, Element element) {
        Element reply;
        if (element == null) {
            throw new RuntimeException("Received empty (null) message!");
        }
        String type = element.getTagName();
        logger.log(Level.FINEST, "Received message: " + type);
        if ("disconnect".equals(type)) {
            reply = this.disconnect(element);
        } else if ("addObject".equals(type)) {
            reply = this.addObject(element);
        } else if ("addPlayer".equals(type)) {
            reply = this.addPlayer(element);
        } else if ("animateAttack".equals(type)) {
            reply = this.animateAttack(element);
        } else if ("animateMove".equals(type)) {
            reply = this.animateMove(element);
        } else if ("chat".equals(type)) {
            reply = this.chat(element);
        } else if ("chooseFoundingFather".equals(type)) {
            reply = this.chooseFoundingFather(element);
        } else if ("closeMenus".equals(type)) {
            reply = this.closeMenus();
        } else if ("diplomacy".equals(type)) {
            reply = this.diplomacy(element);
        } else if ("error".equals(type)) {
            reply = this.error(element);
        } else if ("featureChange".equals(type)) {
            reply = this.featureChange(element);
        } else if ("firstContact".equals(type)) {
            reply = this.firstContact(element);
        } else if ("fountainOfYouth".equals(type)) {
            reply = this.fountainOfYouth(element);
        } else if ("gameEnded".equals(type)) {
            reply = this.gameEnded(element);
        } else if ("indianDemand".equals(type)) {
            reply = this.indianDemand(element);
        } else if ("lootCargo".equals(type)) {
            reply = this.lootCargo(element);
        } else if ("monarchAction".equals(type)) {
            reply = this.monarchAction(element);
        } else if ("multiple".equals(type)) {
            reply = this.multiple(connection, element);
        } else if ("newLandName".equals(type)) {
            reply = this.newLandName(element);
        } else if ("newRegionName".equals(type)) {
            reply = this.newRegionName(element);
        } else if ("newTurn".equals(type)) {
            reply = this.newTurn(element);
        } else if ("reconnect".equals(type)) {
            reply = this.reconnect(element);
        } else if ("remove".equals(type)) {
            reply = this.remove(element);
        } else if ("setAI".equals(type)) {
            reply = this.setAI(element);
        } else if ("setCurrentPlayer".equals(type)) {
            reply = this.setCurrentPlayer(element);
        } else if ("setDead".equals(type)) {
            reply = this.setDead(element);
        } else if ("setStance".equals(type)) {
            reply = this.setStance(element);
        } else if ("spyResult".equals(type)) {
            reply = this.spyResult(element);
        } else if ("update".equals(type)) {
            reply = this.update(element);
        } else {
            logger.warning("Unsupported message type: " + type);
            return null;
        }
        logger.log(Level.FINEST, "Handled message: " + type + " replying with: " + (reply == null ? "null" : reply.getTagName()));
        FreeColClient fcc = this.getFreeColClient();
        if (Boolean.TRUE.toString().equals(element.getAttribute("flush")) && fcc.currentPlayerIsMyPlayer()) {
            SwingUtilities.invokeLater(this.displayModelMessagesRunnable);
        }
        return reply;
    }

    private Element addObject(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String owner = e.getAttribute("owner");
            Player player = game.getFreeColGameObject(owner, Player.class);
            if (player == null) {
                logger.warning("addObject with broken owner: " + owner);
                continue;
            }
            String tag = e.getTagName();
            if (FoundingFather.getXMLElementTagName().equals(tag)) {
                FoundingFather father = spec.getFoundingFather(FreeColObject.readId(e));
                if (father != null) {
                    player.addFather(father);
                }
                player.invalidateCanSeeTiles();
                continue;
            }
            if (HistoryEvent.getXMLElementTagName().equals(tag)) {
                player.getHistory().add(new HistoryEvent(e));
                continue;
            }
            if (LastSale.getXMLElementTagName().equals(tag)) {
                player.addLastSale(new LastSale(e));
                continue;
            }
            if (ModelMessage.getXMLElementTagName().equals(tag)) {
                player.addModelMessage(new ModelMessage(e));
                continue;
            }
            if (TradeRoute.getXMLElementTagName().equals(tag)) {
                player.getTradeRoutes().add(new TradeRoute(game, e));
                continue;
            }
            logger.warning("addObject unrecognized: " + tag);
        }
        return null;
    }

    private Element addPlayer(Element element) {
        Element playerElement;
        String id;
        Game game = this.getGame();
        if (game.getFreeColGameObject(id = FreeColObject.readId(playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0)), Player.class) == null) {
            game.addPlayer(new Player(game, playerElement));
        } else {
            game.getFreeColGameObject(id).readFromXMLElement(playerElement);
        }
        return null;
    }

    private Element animateAttack(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        if (freeColClient.isHeadless()) {
            return null;
        }
        Game game = this.getGame();
        Player player = freeColClient.getMyPlayer();
        String str = element.getAttribute("attacker");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing attacker attribute.");
        }
        Unit u = game.getFreeColGameObject(str, Unit.class);
        if (u == null && (u = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted attacker: " + str);
        }
        final Unit attacker = u;
        str = element.getAttribute("defender");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing defender attribute.");
        }
        u = game.getFreeColGameObject(str, Unit.class);
        if (u == null && (u = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted defender: " + str);
        }
        final Unit defender = u;
        str = element.getAttribute("attackerTile");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing attacker tile attribute.");
        }
        final Tile attackerTile = game.getFreeColGameObject(str, Tile.class);
        if (attackerTile == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted attacker tile: " + str);
        }
        str = element.getAttribute("defenderTile");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing defender tile attribute.");
        }
        final Tile defenderTile = game.getFreeColGameObject(str, Tile.class);
        if (defenderTile == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted defender tile: " + str);
        }
        final boolean success = Boolean.parseBoolean(element.getAttribute("success"));
        final boolean focus = this.lastAnimatedUnit != attacker;
        this.lastAnimatedUnit = attacker;
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (focus || !InGameInputHandler.this.getGUI().onScreen(attackerTile) || !InGameInputHandler.this.getGUI().onScreen(defenderTile)) {
                    InGameInputHandler.this.getGUI().setFocusImmediately(attackerTile);
                }
                InGameInputHandler.this.getGUI().animateUnitAttack(attacker, defender, attackerTile, defenderTile, success);
                InGameInputHandler.this.refreshCanvas(false);
            }
        });
        return null;
    }

    private Element animateMove(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        if (freeColClient.isHeadless()) {
            return null;
        }
        Game game = this.getGame();
        Player player = freeColClient.getMyPlayer();
        String unitId = element.getAttribute("unit");
        if (unitId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing unitId.");
            return null;
        }
        Unit u = game.getFreeColGameObject(unitId, Unit.class);
        if (u == null) {
            u = InGameInputHandler.selectUnitFromElement(game, element, unitId);
        }
        if (u == null) {
            logger.warning("Animation for: " + player.getId() + " missing unit:" + unitId);
            return null;
        }
        final Unit unit = u;
        String oldTileId = element.getAttribute("oldTile");
        if (oldTileId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing oldTileId");
            return null;
        }
        final Tile oldTile = game.getFreeColGameObject(oldTileId, Tile.class);
        if (oldTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing oldTile: " + oldTileId);
            return null;
        }
        String newTileId = element.getAttribute("newTile");
        if (newTileId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing newTileId");
            return null;
        }
        final Tile newTile = game.getFreeColGameObject(newTileId, Tile.class);
        if (newTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing newTile: " + newTileId);
            return null;
        }
        final boolean focus = unit != this.lastAnimatedUnit;
        this.lastAnimatedUnit = unit;
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (InGameInputHandler.this.getGUI().getAnimationSpeed(unit) > 0) {
                    if (focus || !InGameInputHandler.this.getGUI().onScreen(oldTile)) {
                        InGameInputHandler.this.getGUI().setFocusImmediately(oldTile);
                    }
                    InGameInputHandler.this.getGUI().animateUnitMove(unit, oldTile, newTile);
                    InGameInputHandler.this.refreshCanvas(false);
                } else if (!InGameInputHandler.this.getGUI().onScreen(oldTile) && InGameInputHandler.this.getFreeColClient().getClientOptions().getBoolean("model.option.alwaysCenter")) {
                    InGameInputHandler.this.getGUI().setFocus(oldTile);
                }
            }
        });
        return null;
    }

    private Element chat(Element element) {
        final Game game = this.getGame();
        final ChatMessage chatMessage = new ChatMessage(game, element);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.getGUI().displayChatMessage(chatMessage.getPlayer(game), chatMessage.getMessage(), chatMessage.isPrivate());
            }
        });
        return null;
    }

    private Element chooseFoundingFather(Element element) {
        ChooseFoundingFatherMessage message = new ChooseFoundingFatherMessage(this.getGame(), element);
        List<FoundingFather> ffs = message.getFathers();
        this.getGUI().showChooseFoundingFatherDialog(ffs);
        return null;
    }

    private Element closeMenus() {
        this.invokeAndWait(this.closeMenusRunnable);
        return null;
    }

    private Element diplomacy(Element element) {
        Game game = this.getGame();
        final DiplomacyMessage message = new DiplomacyMessage(this.getGame(), element);
        final DiplomaticTrade agreement = message.getAgreement();
        final FreeColGameObject our = message.getOurFCGO(game);
        if (our == null) {
            logger.warning("Our FCGO omitted from diplomacy message.");
            return null;
        }
        final FreeColGameObject other = message.getOtherFCGO(game);
        if (other == null) {
            logger.warning("Other FCGO omitted from diplomacy message.");
            return null;
        }
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                message.setAgreement(InGameInputHandler.this.igc().diplomacy(our, other, agreement));
            }
        });
        SwingUtilities.invokeLater(this.updateMenuBarRunnable);
        return message.getAgreement() == null ? null : message.toXMLElement();
    }

    private Element disposeUnits(Element element) {
        Game game = this.getGame();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String id = FreeColObject.readId(e);
            Unit u = game.getFreeColGameObject(id, Unit.class);
            if (u == null) {
                logger.warning("Object is not a unit");
                continue;
            }
            u.dispose();
        }
        return null;
    }

    private Element error(Element element) {
        final String messageId = element.getAttribute("messageID");
        final String message = element.getAttribute("message");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.getGUI().showErrorMessage(messageId, message);
            }
        });
        return null;
    }

    private Element featureChange(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        boolean add = "add".equalsIgnoreCase(element.getAttribute("add"));
        String id = FreeColObject.readId(element);
        FreeColGameObject object = game.getFreeColGameObject(id);
        if (object == null) {
            logger.warning("featureChange with null object");
            return null;
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String tag = e.getTagName();
            if (Ability.getXMLElementTagName().equals(tag)) {
                if (add) {
                    object.addAbility(new Ability(e, spec));
                    continue;
                }
                object.removeAbility(new Ability(e, spec));
                continue;
            }
            if (Modifier.getXMLElementTagName().equals(tag)) {
                if (add) {
                    object.addModifier(new Modifier(e, spec));
                    continue;
                }
                object.removeModifier(new Modifier(e, spec));
                continue;
            }
            logger.warning("featureChange unrecognized: " + tag);
        }
        return null;
    }

    private Element firstContact(Element element) {
        Game game = this.getGame();
        FirstContactMessage message = new FirstContactMessage(game, element);
        Player player = message.getPlayer(game);
        if (player == null || player != this.getFreeColClient().getMyPlayer()) {
            logger.warning("firstContact with bad player: " + player);
            return null;
        }
        Player other = message.getOtherPlayer(game);
        if (other == null || other == player || !other.isIndian()) {
            logger.warning("firstContact with bad other player: " + other);
            return null;
        }
        Tile tile = message.getTile(game);
        if (tile != null && tile.getOwner() != other) {
            logger.warning("firstContact with bad tile: " + tile);
            return null;
        }
        this.getGUI().showFirstContactDialog(player, other, tile, message.getSettlementCount());
        return null;
    }

    private Element fountainOfYouth(Element element) {
        int n = InGameInputHandler.getIntegerAttribute(element, "migrants");
        if (n > 0) {
            this.getGUI().showEmigrationDialog(this.getFreeColClient().getMyPlayer(), n, true);
        } else {
            logger.warning("Invalid migrants attribute: " + element.getAttribute("migrants"));
        }
        return null;
    }

    private Element gameEnded(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        FreeColDebugger.finishDebugRun(freeColClient, true);
        Player winner = this.getGame().getFreeColGameObject(element.getAttribute("winner"), Player.class);
        final boolean highScore = "true".equalsIgnoreCase(element.getAttribute("highScore"));
        if (winner == freeColClient.getMyPlayer()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InGameInputHandler.this.igc().displayHighScores(highScore);
                }
            });
            this.getGUI().showVictoryDialog();
        }
        return null;
    }

    private Element indianDemand(Element element) {
        final Game game = this.getGame();
        Player player = this.getFreeColClient().getMyPlayer();
        final IndianDemandMessage message = new IndianDemandMessage(game, element);
        final Unit unit = message.getUnit(game);
        if (unit == null) {
            logger.warning("IndianDemand with null unit: " + element.getAttribute("unit"));
            return null;
        }
        final Colony colony = message.getColony(game);
        if (colony == null) {
            logger.warning("IndianDemand with null colony: " + element.getAttribute("colony"));
            return null;
        }
        if (!player.owns(colony)) {
            throw new IllegalArgumentException("Demand to anothers colony");
        }
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean accepted = InGameInputHandler.this.igc().indianDemand(unit, colony, message.getType(game), message.getAmount());
                message.setResult(accepted);
            }
        });
        return message.toXMLElement();
    }

    private Element lootCargo(Element element) {
        Game game = this.getGame();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        String defenderId = message.getDefenderId();
        List<Goods> goods = message.getGoods();
        if (unit == null || goods == null) {
            return null;
        }
        this.getGUI().showCaptureGoodsDialog(unit, goods, defenderId);
        return null;
    }

    private Element monarchAction(Element element) {
        Game game = this.getGame();
        MonarchActionMessage message = new MonarchActionMessage(game, element);
        this.getGUI().showMonarchDialog(message.getAction(), message.getTemplate(), message.getMonarchKey());
        return null;
    }

    private Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                Element reply = this.handle(connection, (Element)nodes.item(i));
                if (reply == null) continue;
                results.add(reply);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Caught crash in multiple item " + i + ", continuing.", e);
            }
        }
        return DOMMessage.collapseElements(results);
    }

    private Element newLandName(Element element) {
        Game game = this.getGame();
        NewLandNameMessage message = new NewLandNameMessage(game, element);
        Unit unit = message.getUnit(this.getFreeColClient().getMyPlayer());
        String defaultName = message.getNewLandName();
        if (unit == null || defaultName == null || !unit.hasTile()) {
            return null;
        }
        this.getGUI().showNameNewLandDialog("newLand.text", defaultName, unit);
        return null;
    }

    private Element newRegionName(Element element) {
        Game game = this.getGame();
        NewRegionNameMessage message = new NewRegionNameMessage(game, element);
        Tile tile = message.getTile(game);
        Unit unit = message.getUnit(this.getFreeColClient().getMyPlayer());
        Region region = message.getRegion(game);
        String defaultName = message.getNewRegionName();
        if (defaultName == null || region == null) {
            return null;
        }
        if (region.isPacific()) {
            this.getGUI().showEventPanel(Messages.message("event.discoverPacific"), "EventImage.discoverPacific", null);
            this.igc().nameNewRegion(tile, unit, region, defaultName);
        } else {
            StringTemplate template = StringTemplate.template("nameRegion.text").addStringTemplate("%type%", region.getLabel());
            this.getGUI().showNameNewRegionDialog(template, defaultName, unit, tile, region);
        }
        return null;
    }

    private Element newTurn(Element element) {
        final int n = InGameInputHandler.getIntegerAttribute(element, "turn");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.igc().newTurn(n);
            }
        });
        this.igc().setCurrentPlayer(null);
        this.refreshCanvas(false);
        SwingUtilities.invokeLater(this.updateMenuBarRunnable);
        return null;
    }

    private Element reconnect(Element element) {
        logger.finest("Entered reconnect.");
        SwingUtilities.invokeLater(this.reconnectRunnable);
        return null;
    }

    private Element remove(Element element) {
        Game game = this.getGame();
        String ds = element.getAttribute("divert");
        FreeColGameObject divert = game.getFreeColGameObject(ds);
        Player player = this.getFreeColClient().getMyPlayer();
        boolean visibilityChange = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e = (Element)nodeList.item(i);
            String idString = FreeColObject.readId(e);
            FreeColGameObject fcgo = game.getFreeColGameObject(idString);
            if (fcgo == null) continue;
            if (divert != null) {
                player.divertModelMessages(fcgo, divert);
            }
            if (fcgo instanceof Settlement) {
                Settlement settlement = (Settlement)fcgo;
                if (settlement != null && settlement.getOwner() != null) {
                    settlement.getOwner().removeSettlement(settlement);
                }
                visibilityChange = true;
            } else if (fcgo instanceof Unit) {
                Unit u = (Unit)fcgo;
                if (u == this.getGUI().getActiveUnit()) {
                    this.invokeAndWait(this.deselectActiveUnitRunnable);
                }
                if (u != null && u.getOwner() != null) {
                    u.getOwner().removeUnit(u);
                }
                visibilityChange = true;
            }
            fcgo.disposeResources();
        }
        if (visibilityChange) {
            player.invalidateCanSeeTiles();
        }
        this.refreshCanvas(false);
        return null;
    }

    private Element setAI(Element element) {
        Game game = this.getGame();
        Player p = game.getFreeColGameObject(element.getAttribute("player"), Player.class);
        p.setAI(Boolean.parseBoolean(element.getAttribute("ai")));
        return null;
    }

    private Element setCurrentPlayer(Element element) {
        Player player = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        this.igc().setCurrentPlayer(player);
        this.refreshCanvas(true);
        return null;
    }

    private Element setDead(Element element) {
        final Player player = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.igc().setDead(player);
            }
        });
        return null;
    }

    private Element setStance(Element element) {
        Game game = this.getGame();
        final Player.Stance stance = Enum.valueOf(Player.Stance.class, element.getAttribute("stance"));
        final Player p1 = game.getFreeColGameObject(element.getAttribute("first"), Player.class);
        final Player p2 = game.getFreeColGameObject(element.getAttribute("second"), Player.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InGameInputHandler.this.igc().setStance(stance, p1, p2);
            }
        });
        return null;
    }

    private Element spyResult(Element element) {
        String tileId;
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() != 2) {
            logger.warning("spyResult length = " + nodeList.getLength());
            return null;
        }
        Game game = this.getGame();
        final Tile tile = game.getFreeColGameObject(tileId = element.getAttribute("tile"), Tile.class);
        if (tile == null) {
            logger.warning("spyResult bad tile = " + tileId);
            return null;
        }
        final Element fullElement = (Element)nodeList.item(0);
        final Element normalElement = (Element)nodeList.item(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tile.readFromXMLElement(fullElement);
                InGameInputHandler.this.getGUI().showSpyColonyPanel(tile, new Runnable(){

                    @Override
                    public void run() {
                        tile.readFromXMLElement(normalElement);
                    }
                });
            }
        });
        return null;
    }

    private Element update(Element element) {
        Player player = this.getFreeColClient().getMyPlayer();
        boolean visibilityChange = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e = (Element)nodeList.item(i);
            String id = FreeColObject.readId(e);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            if (fcgo == null) {
                logger.warning("Update object not present in client: " + id);
            } else {
                fcgo.readFromXMLElement(e);
            }
            if ((!(fcgo instanceof Player) || fcgo != player) && (!(fcgo instanceof Settlement) && !(fcgo instanceof Unit) || !player.owns((Ownable)((Object)fcgo)))) continue;
            visibilityChange = true;
        }
        if (visibilityChange) {
            player.invalidateCanSeeTiles();
        }
        this.refreshCanvas(false);
        return null;
    }
}

