/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConnectController {
    private static final Logger logger = Logger.getLogger(ConnectController.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;

    public ConnectController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
    }

    private void finish() {
        ResourceManager.setScenarioMapping(null);
        if (!this.freeColClient.isHeadless()) {
            this.freeColClient.setInGame(false);
        }
        this.freeColClient.setGame(null);
        this.freeColClient.setMyPlayer(null);
        this.freeColClient.askServer().reset();
        this.freeColClient.setLoggedIn(false);
    }

    private boolean unblockServer(int port) {
        FreeColServer freeColServer = this.freeColClient.getFreeColServer();
        if (freeColServer != null && freeColServer.getServer().getPort() == port) {
            if (this.gui.confirm("stopServer.text", "stopServer.yes", "stopServer.no")) {
                freeColServer.getController().shutdown();
            } else {
                return false;
            }
        }
        return true;
    }

    private FreeColServer startServer(boolean publicServer, boolean singlePlayer, Specification spec, int port) {
        try {
            return new FreeColServer(publicServer, singlePlayer, spec, port, null);
        }
        catch (NoRouteToServerException e) {
            this.gui.showErrorMessage("server.noRouteToServer");
            logger.log(Level.WARNING, "No route to server.", e);
        }
        catch (IOException e) {
            this.gui.showErrorMessage("server.couldNotStart");
            logger.log(Level.WARNING, "Could not start server.", e);
        }
        return null;
    }

    private Connection getConnection(String host, int port) {
        try {
            return new Connection(host, port, null, "FreeColClient:");
        }
        catch (IOException e) {
            this.gui.showErrorMessage("server.couldNotConnect", e.getMessage());
            logger.log(Level.WARNING, "Could not connect to " + host + ":" + port, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FreeColServer.GameState getGameState(String host, int port) {
        String state = null;
        Element element = DOMMessage.createMessage("gameState", new String[0]);
        try (Connection mc = this.getConnection(host, port);){
            if (mc == null) {
                FreeColServer.GameState gameState = null;
                return gameState;
            }
            Element reply = mc.ask(element);
            if (reply == null) {
                this.gui.showErrorMessage("server.couldNotConnect", "no reply");
                FreeColServer.GameState gameState = null;
                return gameState;
            }
            if (!"gameState".equals(reply.getTagName())) {
                logger.warning("The reply has an unknown type: " + reply.getTagName());
                this.gui.showErrorMessage("server.couldNotConnect", "bad reply: " + reply.getTagName());
                FreeColServer.GameState gameState = null;
                return gameState;
            }
            state = reply.getAttribute("state");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send message to server.", e);
            this.gui.showErrorMessage("server.couldNotConnect", e.getMessage());
            return null;
        }
        try {
            return Enum.valueOf(FreeColServer.GameState.class, state);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Bad state: " + state, e);
            this.gui.showErrorMessage("server.couldNotConnect", e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getVacantPlayers(String host, int port) {
        ArrayList<String> items = new ArrayList<String>();
        Element element = DOMMessage.createMessage("getVacantPlayers", new String[0]);
        try (Connection mc = this.getConnection(host, port);){
            if (mc == null) {
                List<String> list = null;
                return list;
            }
            Element reply = mc.ask(element);
            if (reply == null) {
                logger.warning("The server did not return a list.");
                List<String> list = null;
                return list;
            }
            if (!"vacantPlayers".equals(reply.getTagName())) {
                logger.warning("The reply has an unknown type: " + reply.getTagName());
                List<String> list = null;
                return list;
            }
            NodeList nl = reply.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                items.add(((Element)nl.item(i)).getAttribute("username"));
                ++i;
            }
            return items;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send message to server.", e);
        }
        return items;
    }

    public boolean login(String user, String host, int port) {
        Game game;
        this.freeColClient.setMapEditor(false);
        this.freeColClient.askServer().disconnect();
        String message = null;
        try {
            if (!this.freeColClient.askServer().connect("FreeColClient:" + user, host, port, this.freeColClient.getPreGameInputHandler())) {
                message = "repeated failure";
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        if (message != null) {
            this.gui.showErrorMessage("server.couldNotConnect", message);
            return false;
        }
        logger.info("Connected to " + host + ":" + port);
        LoginMessage msg = this.freeColClient.askServer().login(user, FreeCol.getVersion());
        if (msg == null || (game = msg.getGame()) == null) {
            this.gui.showErrorMessage("server.couldNotLogin");
            return false;
        }
        this.freeColClient.setGame(game);
        Player player = game.getPlayerByName(user);
        if (player == null) {
            logger.warning("New game does not contain player: " + user);
            this.gui.showErrorMessage(StringTemplate.template("server.noSuchPlayer").addName("%player%", user));
            return false;
        }
        this.freeColClient.setMyPlayer(player);
        this.freeColClient.addSpecificationActions(game.getSpecification());
        this.freeColClient.updateActions();
        logger.info("FreeColClient logged in as " + user + "/" + player.getId());
        if (msg.getStartGame()) {
            Tile entryTile = player.getEntryLocation() == null ? null : player.getEntryLocation().getTile();
            this.freeColClient.setSinglePlayer(msg.isSinglePlayer());
            boolean play = this.freeColClient.getPreGameController().startGame();
            if (play) {
                this.gui.setActiveUnit(null);
                if (msg.isCurrentPlayer()) {
                    this.freeColClient.getInGameController().setCurrentPlayer(player);
                    Unit activeUnit = msg.getActiveUnit();
                    if (activeUnit != null) {
                        activeUnit.getOwner().resetIterators();
                        activeUnit.getOwner().setNextActiveUnit(activeUnit);
                        this.gui.setActiveUnit(activeUnit);
                    } else {
                        this.gui.setSelectedTile(entryTile, false);
                    }
                } else {
                    this.gui.setSelectedTile(entryTile, false);
                }
            }
        }
        this.freeColClient.setLoggedIn(true);
        return true;
    }

    public boolean startMultiplayerGame(Specification specification, boolean publicServer, int port) {
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if (!this.unblockServer(port)) {
            return false;
        }
        FreeColServer freeColServer = this.startServer(publicServer, false, specification, port);
        if (freeColServer == null) {
            return false;
        }
        this.freeColClient.setFreeColServer(freeColServer);
        return this.joinMultiplayerGame(freeColServer.getHost(), freeColServer.getPort());
    }

    public boolean joinMultiplayerGame(String host, int port) {
        FreeColServer.GameState state;
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if ((state = this.getGameState(host, port)) == null) {
            return false;
        }
        switch (state) {
            case STARTING_GAME: {
                if (!this.login(FreeCol.getName(), host, port)) {
                    return false;
                }
                this.gui.showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), false);
                this.freeColClient.setSinglePlayer(false);
                break;
            }
            case IN_GAME: {
                if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
                    this.gui.showErrorMessage("connectController.debugConnect");
                    return false;
                }
                List<String> names = this.getVacantPlayers(host, port);
                if (names == null || names.isEmpty()) {
                    this.gui.showErrorMessage("connectController.noPlayers");
                    return false;
                }
                ArrayList choices = new ArrayList();
                for (String n : names) {
                    choices.add(new ChoiceItem<String>(Messages.getName(n), n));
                }
                String choice = (String)this.gui.getChoice(true, null, Messages.message("connectController.choicePlayer"), null, "cancel", choices);
                if (choice == null) {
                    return false;
                }
                if (!this.login(Messages.getRulerName(choice), host, port)) {
                    return false;
                }
                this.freeColClient.setSinglePlayer(false);
                break;
            }
            default: {
                this.gui.showErrorMessage("connectController.ending");
                return false;
            }
        }
        return true;
    }

    public boolean startSinglePlayerGame(Specification spec, boolean skip) {
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if (!this.unblockServer(FreeCol.getServerPort())) {
            return false;
        }
        spec.loadMods(this.freeColClient.getClientOptions().getActiveMods());
        FreeColServer freeColServer = this.startServer(false, true, spec, -1);
        if (freeColServer == null) {
            return false;
        }
        this.freeColClient.setFreeColServer(freeColServer);
        this.freeColClient.setSinglePlayer(true);
        if (!this.login(FreeCol.getName(), freeColServer.getHost(), freeColServer.getPort())) {
            return false;
        }
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co.getBoolean("model.option.autosaveDelete")) {
            FreeColServer.removeAutosaves(co.getText("model.option.autoSavePrefix"));
        }
        this.freeColClient.getPreGameController().setReady(true);
        if (skip) {
            this.freeColClient.getPreGameController().requestLaunch();
        } else {
            this.gui.showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean startSavedGame(File file, final String userMsg) {
        class ErrorJob
        implements Runnable {
            private final String message;

            ErrorJob(String message) {
                this.message = message;
            }

            @Override
            public void run() {
                ConnectController.this.gui.closeMenus();
                ConnectController.this.gui.showErrorMessage(this.message);
            }
        }
        int port;
        String name;
        boolean singlePlayer;
        boolean show;
        boolean defaultPublicServer;
        boolean defaultSinglePlayer;
        this.freeColClient.setMapEditor(false);
        FreeColSavegameFile fis = null;
        try {
            fis = new FreeColSavegameFile(file);
        }
        catch (IOException ioe) {
            SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
            logger.log(Level.WARNING, "Could not open save file: " + file.getName());
            return false;
        }
        try (FreeColXMLReader xr = fis.getFreeColXMLReader();){
            xr.nextTag();
            String str = xr.getAttribute("owner", null);
            if (str != null) {
                FreeCol.setName(str);
            }
            defaultSinglePlayer = xr.getAttribute("singleplayer", false);
            defaultPublicServer = xr.getAttribute("publicServer", false);
            ClientOptions options = this.freeColClient.getClientOptions();
            options.updateOptions(fis.getInputStream("client-options.xml"));
            options.fixClientOptions();
        }
        catch (FileNotFoundException e) {
            SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
            logger.log(Level.WARNING, "Can not find file: " + file.getName(), e);
            return false;
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, "Error reading game from: " + file.getName(), e);
            SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
            return false;
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new ErrorJob("couldNotLoadGame"));
            logger.log(Level.WARNING, "Could not load game from: " + file.getName(), e);
            return false;
        }
        int sgo = this.freeColClient.getClientOptions().getInteger("model.option.showSavegameSettings");
        boolean bl = show = sgo == 2 || !defaultSinglePlayer && sgo == 1;
        if (show) {
            if (!this.gui.showLoadingSavegameDialog(defaultPublicServer, defaultSinglePlayer)) {
                return false;
            }
            LoadingSavegameDialog lsd = this.gui.getLoadingSavegameDialog();
            singlePlayer = lsd.isSinglePlayer();
            name = lsd.getServerName();
            port = lsd.getPort();
        } else {
            void var3_15;
            singlePlayer = var3_15;
            name = null;
            port = -1;
        }
        if (!this.unblockServer(port)) {
            return false;
        }
        this.gui.showStatusPanel(Messages.message("status.loadingGame"));
        final File theFile = file;
        Runnable loadGameJob = new Runnable(){

            @Override
            public void run() {
                FreeColServer freeColServer = null;
                String err = null;
                try {
                    final FreeColSavegameFile saveGame = new FreeColSavegameFile(theFile);
                    freeColServer = new FreeColServer(saveGame, null, port, name);
                    ConnectController.this.freeColClient.setFreeColServer(freeColServer);
                    ConnectController.this.freeColClient.setSinglePlayer(singlePlayer);
                    ConnectController.this.freeColClient.getInGameController().setGameConnected();
                    if (ConnectController.this.login(FreeCol.getName(), freeColServer.getHost(), freeColServer.getPort())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ResourceManager.setScenarioMapping(saveGame.getResourceMapping());
                                if (userMsg != null) {
                                    ConnectController.this.gui.showInformationMessage(userMsg);
                                }
                                ConnectController.this.gui.closeStatusPanel();
                            }
                        });
                        return;
                    }
                    err = "server.loginFail";
                    logger.warning("Could not log in.");
                }
                catch (FileNotFoundException e) {
                    err = "fileNotFound";
                    logger.log(Level.WARNING, "Can not find file.", e);
                }
                catch (FreeColException e) {
                    err = e.getMessage();
                    logger.log(Level.WARNING, "FreeCol error.", e);
                }
                catch (IOException e) {
                    err = "server.couldNotStart";
                    logger.log(Level.WARNING, "Error starting game.", e);
                }
                catch (NoRouteToServerException e) {
                    err = "server.noRouteToServer";
                    logger.log(Level.WARNING, "No route to server.", e);
                }
                catch (XMLStreamException e) {
                    err = "server.streamError";
                    logger.log(Level.WARNING, "Stream error.", e);
                }
                if (err != null) {
                    if (ConnectController.this.freeColClient.isHeadless() || FreeColDebugger.getDebugRunTurns() >= 0) {
                        FreeCol.fatal(Messages.message(err));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ConnectController.this.gui.closeMainPanel();
                            ConnectController.this.gui.showMainPanel(null);
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(err));
                }
            }
        };
        this.freeColClient.setWork(loadGameJob);
        return true;
    }

    public boolean reconnect() {
        String host = this.freeColClient.askServer().getHost();
        int port = this.freeColClient.askServer().getPort();
        this.gui.removeInGameComponents();
        this.logout(true);
        if (!this.login(FreeCol.getName(), host, port)) {
            return false;
        }
        this.freeColClient.getInGameController().nextModelMessage();
        return true;
    }

    public void logout(boolean notifyServer) {
        if (notifyServer) {
            this.freeColClient.askServer().logout();
        }
        this.freeColClient.askServer().disconnect();
        this.finish();
    }

    public void quitGame(boolean stopServer, boolean notifyServer) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        if (stopServer && server != null) {
            server.getController().shutdown();
            this.freeColClient.setFreeColServer(null);
            this.finish();
        } else if (this.freeColClient.isLoggedIn()) {
            this.logout(notifyServer);
        }
    }

    public void quitGame(boolean stopServer) {
        this.quitGame(stopServer, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ServerInfo> getServerList() {
        try (Connection mc = new Connection("meta.freecol.org", 3540, null, "FreeColClient:");){
            Element reply = null;
            try {
                reply = mc.ask(DOMMessage.createMessage("getServerList", new String[0]));
            }
            catch (IOException e222) {
                reply = null;
            }
            if (reply == null) {
                this.gui.showErrorMessage("metaServer.communicationError");
                logger.warning("The meta-server did not return a list.");
                List<ServerInfo> e222 = null;
                return e222;
            }
            ArrayList<ServerInfo> items = new ArrayList<ServerInfo>();
            NodeList nl = reply.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                items.add(new ServerInfo((Element)nl.item(i)));
            }
            ArrayList<ServerInfo> arrayList = items;
            return arrayList;
        }
        catch (IOException e) {
            this.gui.showErrorMessage("metaServer.couldNotConnect");
            logger.log(Level.WARNING, "Could not connect to the meta-server.", e);
            return null;
        }
    }
}

