/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.networking.UserServerAPI;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.server.FreeColServer;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private final ConnectController connectController;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameController inGameController;
    private final InGameInputHandler inGameInputHandler;
    private final MapEditorController mapEditorController;
    private FreeColServer freeColServer = null;
    private final ServerAPI serverAPI;
    private final GUI gui;
    private final ActionManager actionManager;
    private Game game;
    private Player player;
    private ClientOptions clientOptions;
    public final Worker worker;
    private boolean inGame = false;
    private boolean mapEditor = false;
    private boolean singlePlayer;
    private boolean loggedIn = false;
    private final boolean headless = "true".equals(System.getProperty("java.awt.headless", "false"));

    public FreeColClient(final File savedGame, Dimension size, boolean sound, String splashFilename, boolean showOpeningVideo, String fontName, final String userMsg, final Specification spec) {
        if (this.headless) {
            if (!FreeColDebugger.isInDebugMode() || FreeColDebugger.getDebugRunTurns() <= 0) {
                this.fatal(Messages.message("client.headlessDebug"));
            }
            if (savedGame == null && spec == null) {
                this.fatal(Messages.message("client.headlessRequires"));
            }
        }
        File baseDirectory = FreeColDirectories.getBaseDirectory();
        FreeColDataFile baseData = null;
        String ioeMessage = null;
        if (baseDirectory.exists() && baseDirectory.isDirectory()) {
            try {
                baseData = new FreeColDataFile(baseDirectory);
            }
            catch (IOException ioe) {
                ioeMessage = ioe.getMessage();
            }
        }
        if (baseData == null) {
            this.fatal(Messages.message(StringTemplate.template("client.baseData").addName("%dir%", baseDirectory.getName())) + (ioeMessage == null ? "" : "\n" + ioeMessage));
        }
        ResourceManager.setBaseMapping(baseData.getResourceMapping());
        this.gui = new GUI(this);
        this.serverAPI = new UserServerAPI(this.gui);
        GraphicsDevice gd = null;
        if (!this.headless) {
            gd = GUI.getGoodGraphicsDevice();
            this.gui.displaySplashScreen(splashFilename, gd);
        }
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameController = new InGameController(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.mapEditorController = new MapEditorController(this);
        this.worker = new Worker();
        this.worker.start();
        try {
            FreeColTcFile tcData = new FreeColTcFile("classic");
            ResourceManager.setTcMapping(tcData.getResourceMapping());
        }
        catch (IOException e) {
            this.fatal(Messages.message("client.classic") + "\n" + e.getMessage());
        }
        this.actionManager = new ActionManager(this);
        this.actionManager.initializeActions(this.inGameController, this.connectController);
        this.loadClientOptions(savedGame);
        if (!this.headless) {
            Font font = null;
            if (fontName != null && (font = Font.decode(fontName)) == null) {
                logger.warning("Font not found: " + fontName);
            }
            if (font == null) {
                font = ResourceManager.getFont("NormalFont");
            }
            try {
                FreeColLookAndFeel fclaf = new FreeColLookAndFeel();
                FreeColLookAndFeel.install(fclaf, font);
            }
            catch (Exception e) {
                this.fatal(Messages.message("client.laf") + "\n" + e.getMessage());
            }
            logger.info("Preload of resources starting.");
            ResourceManager.preload();
            this.gui.hideSplashScreen();
        }
        this.gui.startGUI(gd, size, sound);
        if (savedGame != null) {
            this.gui.playSound("sound.intro.general");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!FreeColClient.this.connectController.startSavedGame(savedGame, userMsg)) {
                        FreeColClient.this.gui.showMainPanel(userMsg);
                    }
                }
            });
        } else if (spec != null) {
            this.gui.playSound("sound.intro.general");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!FreeColClient.this.connectController.startSinglePlayerGame(spec, true)) {
                        FreeColClient.this.gui.showMainPanel(userMsg);
                    }
                }
            });
        } else if (showOpeningVideo) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FreeColClient.this.gui.showOpeningVideoPanel(userMsg);
                }
            });
        } else {
            this.gui.playSound("sound.intro.general");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FreeColClient.this.gui.showMainPanel(userMsg);
                }
            });
        }
        String quit = "FreeColClient:Quit Game";
        Runtime.getRuntime().addShutdownHook(new Thread(quit){

            @Override
            public void run() {
                FreeColClient.this.getConnectController().quitGame(true);
            }
        });
    }

    private void loadClientOptions(File savedGame) {
        File userOptions;
        this.clientOptions = new ClientOptions();
        logger.info("Loaded default client options.");
        if (this.actionManager != null) {
            this.clientOptions.add(this.actionManager);
            logger.info("Loaded client options from the action manager.");
        }
        if (savedGame != null) {
            try {
                FreeColSavegameFile save = new FreeColSavegameFile(savedGame);
                String fileName = "client-options.xml";
                this.clientOptions.loadOptions(save.getInputStream(fileName));
                logger.info("Loaded client options from saved game:" + savedGame.getPath() + "(" + fileName + ")");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to read client options from: " + savedGame.getPath(), e);
            }
        }
        if ((userOptions = FreeColDirectories.getClientOptionsFile()) != null && userOptions.exists()) {
            this.clientOptions.updateOptions(userOptions);
            logger.info("Updated client options from user options file: " + userOptions.getPath());
        } else {
            logger.warning("User options file not present.");
        }
        ArrayList<ResourceMapping> modMappings = new ArrayList<ResourceMapping>();
        for (FreeColModFile f : this.clientOptions.getActiveMods()) {
            modMappings.add(f.getResourceMapping());
        }
        ResourceManager.setModMappings(modMappings);
        if (this.actionManager != null) {
            this.actionManager.update();
        }
    }

    private void fatal(String err) {
        logger.log(Level.SEVERE, err);
        FreeCol.fatal(err);
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public ServerAPI askServer() {
        return this.serverAPI;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public boolean tutorialMode() {
        return this.getClientOptions().getBoolean("model.option.guiShowTutorial");
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public void setSinglePlayer(boolean singlePlayer) {
        this.singlePlayer = singlePlayer;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void updateActions() {
        this.actionManager.update();
    }

    public void addSpecificationActions(Specification specification) {
        this.actionManager.addSpecificationActions(specification);
    }

    public boolean isAdmin() {
        return this.player != null && this.player.isAdmin();
    }

    public boolean canSaveCurrentGame() {
        return this.freeColServer != null && (this.isAdmin() || this.freeColServer.getGameState() != FreeColServer.GameState.IN_GAME);
    }

    public boolean currentPlayerIsMyPlayer() {
        return this.inGame && this.game != null && this.player != null && this.player.equals(this.game.getCurrentPlayer());
    }

    public List<Colony> getMySortedColonies() {
        return this.clientOptions == null || this.player == null ? Collections.emptyList() : this.clientOptions.getSortedColonies(this.player);
    }

    public void setWork(Runnable runnable) {
        this.worker.schedule(runnable);
    }

    public void newGame() {
        Specification specification = null;
        if (this.getGame() != null) {
            if (this.isMapEditor()) {
                specification = this.getGame().getSpecification();
            } else if (this.gui.confirmStopGame()) {
                this.getConnectController().quitGame(true);
                FreeColSeed.incrementFreeColSeed();
            } else {
                return;
            }
        }
        this.gui.removeInGameComponents();
        this.gui.showNewPanel(specification);
    }

    public void continuePlaying() {
        this.askServer().continuePlaying();
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        if (turns <= 0) {
            this.freeColServer.getInGameController().setSkippedTurns(0);
            return;
        }
        this.gui.closeMenus();
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.askServer().startSkipping();
    }

    public void askToQuit() {
        if (this.gui.confirm("quitDialog.areYouSure.text", "ok", "cancel")) {
            this.quit();
        }
    }

    public void retire() {
        if (this.gui.confirm("retireDialog.areYouSure.text", "ok", "cancel")) {
            Player player = this.getMyPlayer();
            player.changePlayerType(Player.PlayerType.RETIRED);
            this.askServer().retire();
            this.gui.showHighScoresPanel(null, this.askServer().getHighScores());
        }
    }

    public void quit() {
        this.getConnectController().quitGame(this.isSinglePlayer());
        try {
            String[] flist;
            long validPeriod = 86400000L * (long)this.clientOptions.getInteger("model.option.autosaveValidity");
            long timeNow = System.currentTimeMillis();
            File autoSave = FreeColDirectories.getAutosaveDirectory();
            if (validPeriod != 0L && autoSave != null && (flist = autoSave.list()) != null) {
                for (String f : flist) {
                    File saveGameFile;
                    if (!f.endsWith(".fsg") || (saveGameFile = new File(autoSave, f)).lastModified() + validPeriod >= timeNow) continue;
                    saveGameFile.delete();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to delete autosave", e);
        }
        try {
            this.gui.quit();
        }
        catch (Exception e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

