/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

public class SnapshotInfo
implements ToXContent,
Streamable {
    private static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
    private String name;
    private SnapshotState state;
    private String reason;
    private ImmutableList<String> indices;
    private long startTime;
    private long endTime;
    private int totalShards;
    private int successfulShards;
    private ImmutableList<SnapshotShardFailure> shardFailures;
    private Version version;

    SnapshotInfo() {
    }

    public SnapshotInfo(Snapshot snapshot) {
        this.name = snapshot.name();
        this.state = snapshot.state();
        this.reason = snapshot.reason();
        this.indices = snapshot.indices();
        this.startTime = snapshot.startTime();
        this.endTime = snapshot.endTime();
        this.totalShards = snapshot.totalShard();
        this.successfulShards = snapshot.successfulShards();
        this.shardFailures = snapshot.shardFailures();
        this.version = snapshot.version();
    }

    public String name() {
        return this.name;
    }

    public SnapshotState state() {
        return this.state;
    }

    public String reason() {
        return this.reason;
    }

    public ImmutableList<String> indices() {
        return this.indices;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public ImmutableList<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    public Version version() {
        return this.version;
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", this.name);
        if (this.version != null) {
            builder.field(Fields.VERSION_ID, this.version.id);
            builder.field(Fields.VERSION, this.version.toString());
        }
        builder.startArray(Fields.INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.field(Fields.STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(Fields.REASON, this.reason);
        }
        if (this.startTime != 0L) {
            builder.field(Fields.START_TIME, DATE_TIME_FORMATTER.printer().print(this.startTime));
            builder.field(Fields.START_TIME_IN_MILLIS, this.startTime);
        }
        if (this.endTime != 0L) {
            builder.field(Fields.END_TIME, DATE_TIME_FORMATTER.printer().print(this.endTime));
            builder.field(Fields.END_TIME_IN_MILLIS, this.endTime);
            builder.timeValueField(Fields.DURATION_IN_MILLIS, Fields.DURATION, this.endTime - this.startTime);
        }
        builder.startArray(Fields.FAILURES);
        for (SnapshotShardFailure shardFailure : this.shardFailures) {
            SnapshotShardFailure.toXContent(shardFailure, builder, params);
        }
        builder.endArray();
        builder.startObject(Fields.SHARDS);
        builder.field(Fields.TOTAL, this.totalShards);
        builder.field(Fields.FAILED, this.failedShards());
        builder.field(Fields.SUCCESSFUL, this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        ImmutableList.Builder indicesListBuilder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            indicesListBuilder.add(in.readString());
        }
        this.indices = indicesListBuilder.build();
        this.state = SnapshotState.fromValue(in.readByte());
        this.reason = in.readOptionalString();
        this.startTime = in.readVLong();
        this.endTime = in.readVLong();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        size = in.readVInt();
        if (size > 0) {
            ImmutableList.Builder failureBuilder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                failureBuilder.add(SnapshotShardFailure.readSnapshotShardFailure(in));
            }
            this.shardFailures = failureBuilder.build();
        } else {
            this.shardFailures = ImmutableList.of();
        }
        if (in.getVersion().onOrAfter(Version.V_1_7_0)) {
            this.version = Version.readVersion(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.indices.size());
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeByte(this.state.value());
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.size());
        for (SnapshotShardFailure failure : this.shardFailures) {
            failure.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_1_7_0)) {
            Version.writeVersion(this.version, out);
        }
    }

    public static SnapshotInfo readSnapshotInfo(StreamInput in) throws IOException {
        SnapshotInfo snapshotInfo = new SnapshotInfo();
        snapshotInfo.readFrom(in);
        return snapshotInfo;
    }

    public static SnapshotInfo readOptionalSnapshotInfo(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new SnapshotInfo());
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString START_TIME_IN_MILLIS = new XContentBuilderString("start_time_in_millis");
        static final XContentBuilderString END_TIME = new XContentBuilderString("end_time");
        static final XContentBuilderString END_TIME_IN_MILLIS = new XContentBuilderString("end_time_in_millis");
        static final XContentBuilderString DURATION = new XContentBuilderString("duration");
        static final XContentBuilderString DURATION_IN_MILLIS = new XContentBuilderString("duration_in_millis");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
        static final XContentBuilderString VERSION_ID = new XContentBuilderString("version_id");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");

        Fields() {
        }
    }
}

