/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;

public class SourceLookup
implements Map {
    private AtomicReader reader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;
    private XContentType sourceContentType;

    public Map<String, Object> source() {
        return this.source;
    }

    public XContentType sourceContentType() {
        return this.sourceContentType;
    }

    private Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(this.sourceAsBytes);
            this.sourceContentType = tuple.v1();
            this.source = tuple.v2();
            return this.source;
        }
        try {
            JustSourceFieldsVisitor sourceFieldVisitor = new JustSourceFieldsVisitor();
            this.reader.document(this.docId, (StoredFieldVisitor)sourceFieldVisitor);
            BytesReference source = sourceFieldVisitor.source();
            if (source == null) {
                this.source = ImmutableMap.of();
                this.sourceContentType = null;
            } else {
                Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(source);
                this.sourceContentType = tuple.v1();
                this.source = tuple.v2();
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("failed to parse / load source", e);
        }
        return this.source;
    }

    public static Tuple<XContentType, Map<String, Object>> sourceAsMapAndType(BytesReference source) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(source, false);
    }

    public static Map<String, Object> sourceAsMap(BytesReference source) throws ElasticsearchParseException {
        return SourceLookup.sourceAsMapAndType(source).v2();
    }

    public static Tuple<XContentType, Map<String, Object>> sourceAsMapAndType(byte[] bytes, int offset, int length) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(bytes, offset, length, false);
    }

    public static Map<String, Object> sourceAsMap(byte[] bytes, int offset, int length) throws ElasticsearchParseException {
        return SourceLookup.sourceAsMapAndType(bytes, offset, length).v2();
    }

    public void setNextReader(AtomicReaderContext context) {
        if (this.reader == context.reader()) {
            return;
        }
        this.reader = context.reader();
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = -1;
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.sourceAsBytes = null;
        this.source = null;
    }

    public void setNextSource(BytesReference source) {
        this.sourceAsBytes = source;
    }

    public void setNextSourceContentType(XContentType sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public void setNextSource(Map<String, Object> source) {
        this.source = source;
    }

    public BytesReference internalSourceRef() {
        return this.sourceAsBytes;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValues.extractRawValues(path, this.loadSourceIfNeeded());
    }

    public Object filter(String[] includes, String[] excludes) {
        return XContentMapValues.filter(this.loadSourceIfNeeded(), includes, excludes);
    }

    public Object extractValue(String path) {
        return XContentMapValues.extractValue(path, this.loadSourceIfNeeded());
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

