/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptGeoDistanceFacetExecutor
extends GeoDistanceFacetExecutor {
    private final SearchScript script;

    public ScriptGeoDistanceFacetExecutor(IndexGeoPointFieldData indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, String scriptLang, String script, ScriptService.ScriptType scriptType, Map<String, Object> params) {
        super(indexFieldData, lat, lon, unit, geoDistance, entries, context);
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, scriptType, ScriptContext.Standard.AGGS, params);
    }

    @Override
    public Collector collector() {
        return new Collector(new ScriptAggregator(this.fixedSourceDistance, this.entries, this.script));
    }

    public static final class ScriptAggregator
    extends GeoDistanceFacetExecutor.Aggregator {
        private double scriptValue;

        public ScriptAggregator(GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistanceFacet.Entry[] entries, SearchScript script) {
            super(fixedSourceDistance, entries);
        }

        @Override
        protected void collectGeoPoint(GeoDistanceFacet.Entry entry, int docId, double distance) {
            double scriptValue = this.scriptValue;
            ++entry.count;
            ++entry.totalCount;
            entry.total += scriptValue;
            if (scriptValue < entry.min) {
                entry.min = scriptValue;
            }
            if (scriptValue > entry.max) {
                entry.max = scriptValue;
            }
        }
    }

    class Collector
    extends GeoDistanceFacetExecutor.Collector {
        private ScriptAggregator scriptAggregator;

        Collector(ScriptAggregator aggregator) {
            super(aggregator);
            this.scriptAggregator = aggregator;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ScriptGeoDistanceFacetExecutor.this.script.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            ScriptGeoDistanceFacetExecutor.this.script.setNextReader(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            ScriptGeoDistanceFacetExecutor.this.script.setNextDocId(doc);
            this.scriptAggregator.scriptValue = ScriptGeoDistanceFacetExecutor.this.script.runAsDouble();
            super.collect(doc);
        }
    }
}

