/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;

public abstract class AggregationBuilder<B extends AggregationBuilder<B>>
extends AbstractAggregationBuilder {
    private List<AbstractAggregationBuilder> aggregations;
    private BytesReference aggregationsBinary;

    protected AggregationBuilder(String name, String type) {
        super(name, type);
    }

    public B subAggregation(AbstractAggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = Lists.newArrayList();
        }
        this.aggregations.add(aggregation);
        return (B)this;
    }

    public B subAggregation(byte[] aggregationsBinary) {
        return this.subAggregation(aggregationsBinary, 0, aggregationsBinary.length);
    }

    public B subAggregation(byte[] aggregationsBinary, int aggregationsBinaryOffset, int aggregationsBinaryLength) {
        return this.subAggregation(new BytesArray(aggregationsBinary, aggregationsBinaryOffset, aggregationsBinaryLength));
    }

    public B subAggregation(BytesReference aggregationsBinary) {
        this.aggregationsBinary = aggregationsBinary;
        return (B)this;
    }

    public B subAggregation(XContentBuilder facets) {
        return this.subAggregation(facets.bytes());
    }

    public B subAggregation(Map<String, Object> facets) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(facets);
            return this.subAggregation(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + facets + "]", e);
        }
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(this.type);
        this.internalXContent(builder, params);
        if (this.aggregations != null || this.aggregationsBinary != null) {
            if (this.aggregations != null) {
                builder.startObject("aggregations");
                for (AbstractAggregationBuilder subAgg : this.aggregations) {
                    subAgg.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (this.aggregationsBinary != null) {
                if (XContentFactory.xContentType(this.aggregationsBinary) == builder.contentType()) {
                    builder.rawField("aggregations", this.aggregationsBinary);
                } else {
                    builder.field("aggregations_binary", this.aggregationsBinary);
                }
            }
        }
        return builder.endObject();
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

